/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.blog;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.Trackback;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class FileBackedTrackback
extends Trackback {
    private transient Log _logger = LogFactory.getLog((Class)FileBackedTrackback.class);
    protected transient File _source;

    public FileBackedTrackback() {
    }

    public FileBackedTrackback(String title, String excerpt, String url, String blogName) {
        super(title, excerpt, url, blogName);
    }

    public File getSource() {
        return this._source;
    }

    public void setSource(File source) {
        this._source = source;
    }

    public void load(BlogUser blogUser) throws BlojsomException {
        if (this._source == null) {
            throw new BlojsomException("No source file set for this trackback");
        }
        int trackbackSwitch = 0;
        this.setTrackbackDateLong(this._source.lastModified());
        try {
            String trackbackLine;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._source), blogUser.getBlog().getBlogFileEncoding()));
            while ((trackbackLine = br.readLine()) != null && trackbackSwitch < 4) {
                switch (trackbackSwitch) {
                    case 0: {
                        if (!"".equals(trackbackLine.trim())) {
                            this.setTitle(trackbackLine);
                        }
                        ++trackbackSwitch;
                        break;
                    }
                    case 1: {
                        if (!"".equals(trackbackLine.trim())) {
                            this.setExcerpt(trackbackLine);
                        }
                        ++trackbackSwitch;
                        break;
                    }
                    case 2: {
                        if (!"".equals(trackbackLine.trim())) {
                            this.setUrl(trackbackLine);
                        }
                        ++trackbackSwitch;
                        break;
                    }
                    case 3: {
                        if (!"".equals(trackbackLine.trim())) {
                            this.setBlogName(trackbackLine);
                        }
                        ++trackbackSwitch;
                    }
                }
            }
            this.setId(this._source.getName());
            br.close();
            File trackbackMetaData = new File(BlojsomUtils.getFilename(this._source.toString()) + ".meta");
            if (trackbackMetaData.exists()) {
                this._logger.debug((Object)("Loading trackback meta-data: " + trackbackMetaData.toString()));
                BlojsomProperties trackbackMetaDataProperties = new BlojsomProperties();
                FileInputStream fis = new FileInputStream(trackbackMetaData);
                ((Properties)trackbackMetaDataProperties).load(fis);
                fis.close();
                this.setMetaData(BlojsomUtils.propertiesToMap(trackbackMetaDataProperties));
            }
        }
        catch (IOException e) {
            this._logger.error((Object)e);
        }
    }

    public void save(BlogUser blogUser) throws BlojsomException {
        File trackbackEntry;
        if (this._blogEntry == null) {
            throw new BlojsomException("Blog entry for this trackback not available");
        }
        Blog blog = blogUser.getBlog();
        long originalTimestamp = -1L;
        originalTimestamp = this._trackbackDateLong;
        if (this._source == null) {
            StringBuffer trackbackDirectory = new StringBuffer();
            String permalinkFilename = this._blogEntry.getPermalink();
            if ((permalinkFilename = BlojsomUtils.urlDecode(permalinkFilename)) == null) {
                this._logger.debug((Object)("Invalid permalink trackback for: " + permalinkFilename));
                throw new BlojsomException("Invalid permalink trackback for: " + permalinkFilename);
            }
            trackbackDirectory.append(blog.getBlogHome());
            trackbackDirectory.append(BlojsomUtils.removeInitialSlash(this._blogEntry.getCategory()));
            File blogEntry = new File(trackbackDirectory.toString() + File.separator + permalinkFilename);
            if (!blogEntry.exists()) {
                this._logger.error((Object)("Trying to create trackback for invalid blog entry: " + permalinkFilename));
                throw new BlojsomException("Trying to create trackback for invalid blog entry: " + permalinkFilename);
            }
            trackbackDirectory.append(blog.getBlogTrackbackDirectory());
            trackbackDirectory.append(File.separator);
            trackbackDirectory.append(permalinkFilename);
            trackbackDirectory.append(File.separator);
            String trackbackFilename = trackbackDirectory.toString() + this.getTrackbackDateLong() + ".tb";
            this.setId(this.getTrackbackDateLong() + ".tb");
            File trackbackDir = new File(trackbackDirectory.toString());
            if (!trackbackDir.exists() && !trackbackDir.mkdirs()) {
                this._logger.error((Object)("Could not create directory for trackbacks: " + trackbackDirectory));
                throw new BlojsomException("Could not create directory for trackbacks: " + trackbackDirectory);
            }
            trackbackEntry = new File(trackbackFilename);
        } else {
            trackbackEntry = this._source;
            originalTimestamp = this._trackbackDateLong;
        }
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(trackbackEntry), blog.getBlogFileEncoding()));
            bw.write(BlojsomUtils.nullToBlank(this.getTitle()).trim());
            bw.newLine();
            bw.write(BlojsomUtils.nullToBlank(this.getExcerpt()).trim());
            bw.newLine();
            bw.write(BlojsomUtils.nullToBlank(this.getUrl()).trim());
            bw.newLine();
            bw.write(BlojsomUtils.nullToBlank(this.getBlogName()).trim());
            bw.newLine();
            bw.close();
            this._logger.debug((Object)("Added trackback: " + trackbackEntry.getName()));
            Properties trackbackMetaDataProperties = BlojsomUtils.mapToProperties(this._metaData, "UTF-8");
            String trackbackMetaDataFilename = BlojsomUtils.getFilename(trackbackEntry.toString()) + ".meta";
            FileOutputStream fos = new FileOutputStream(new File(trackbackMetaDataFilename));
            trackbackMetaDataProperties.store(fos, null);
            fos.close();
            this._logger.debug((Object)("Wrote trackback meta-data: " + trackbackMetaDataFilename));
            this._source = trackbackEntry;
            if (originalTimestamp != -1L) {
                this._source.setLastModified(originalTimestamp);
                File trackbackMetaData = new File(trackbackMetaDataFilename);
                trackbackMetaData.setLastModified(originalTimestamp);
            }
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new BlojsomException(e);
        }
    }

    public void delete(BlogUser blogUser) throws BlojsomException {
        Blog blog = blogUser.getBlog();
        if (this._source == null || this._blogEntry == null) {
            throw new BlojsomException("No source file found to delete trackback");
        }
        this._logger.debug((Object)("Deleting trackback " + this._source.getAbsolutePath()));
        if (!this._source.delete()) {
            throw new BlojsomException("Unable to delete trackback: " + this.getId());
        }
        File metaFile = new File(blog.getBlogHome() + this._blogEntry.getCategory() + blog.getBlogTrackbackDirectory() + File.separatorChar + this._blogEntry.getPermalink() + File.separatorChar + BlojsomUtils.getFilename(this._source.getName()) + blog.getBlogEntryMetaDataExtension());
        if (metaFile.exists()) {
            metaFile.delete();
        }
    }
}

