/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.blog;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.Pingback;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class FileBackedPingback
extends Pingback {
    private transient Log _logger = LogFactory.getLog((Class)FileBackedPingback.class);
    protected static final int PINGBACK_GENERIC_FAULT_CODE = 0;
    protected static final int PINGBACK_SOURCE_URI_NON_EXISTENT_CODE = 16;
    protected static final int PINGBACK_NO_LINK_TO_TARGET_URI_CODE = 17;
    protected static final int PINGBACK_TARGET_URI_NON_EXISTENT_CODE = 32;
    protected static final int PINGBACK_TARGET_URI_NOT_ENABLED_CODE = 33;
    protected static final int PINGBACK_ALREADY_REGISTERED_CODE = 48;
    protected static final int PINGBACK_ACCESS_DENIED_CODE = 49;
    protected static final int PINGBACK_UPSTREAM_SERVER_ERROR_CODE = 50;
    protected transient File _source;

    public FileBackedPingback() {
    }

    public FileBackedPingback(String title, String excerpt, String url, String blogName) {
        super(title, excerpt, url, blogName);
    }

    public File getSource() {
        return this._source;
    }

    public void setSource(File source) {
        this._source = source;
    }

    public void load(BlogUser blogUser) throws BlojsomException {
        if (this._source == null) {
            throw new BlojsomException("No source file set for this pingback");
        }
        int pingbackSwitch = 0;
        this.setTrackbackDateLong(this._source.lastModified());
        StringBuffer pingbackExcerpt = new StringBuffer();
        try {
            String pingbackLine;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._source), blogUser.getBlog().getBlogFileEncoding()));
            block7: while ((pingbackLine = br.readLine()) != null && pingbackSwitch < 4) {
                switch (pingbackSwitch) {
                    case 0: {
                        if (!"".equals(pingbackLine.trim())) {
                            this.setTitle(pingbackLine);
                        }
                        ++pingbackSwitch;
                        continue block7;
                    }
                    case 1: {
                        if (!"".equals(pingbackLine.trim())) {
                            this.setUrl(pingbackLine);
                        }
                        ++pingbackSwitch;
                        continue block7;
                    }
                    case 2: {
                        if (!"".equals(pingbackLine.trim())) {
                            this.setBlogName(pingbackLine);
                        }
                        ++pingbackSwitch;
                        continue block7;
                    }
                }
                pingbackExcerpt.append(pingbackLine).append(BlojsomUtils.LINE_SEPARATOR);
            }
            this.setExcerpt(pingbackExcerpt.toString());
            this.setId(this._source.getName());
            br.close();
            File pingbackMetaData = new File(BlojsomUtils.getFilename(this._source.toString()) + ".meta");
            if (pingbackMetaData.exists()) {
                this._logger.debug((Object)("Loading pingback meta-data: " + pingbackMetaData.toString()));
                BlojsomProperties pingbackMetaDataProperties = new BlojsomProperties(true);
                FileInputStream fis = new FileInputStream(pingbackMetaData);
                ((Properties)pingbackMetaDataProperties).load(fis);
                fis.close();
                this.setMetaData(BlojsomUtils.propertiesToMap(pingbackMetaDataProperties));
            }
        }
        catch (IOException e) {
            this._logger.error((Object)e);
        }
    }

    public void save(BlogUser blogUser) throws BlojsomException {
        if (this._blogEntry == null) {
            throw new BlojsomException("Blog entry for this pingback not available");
        }
        Blog blog = blogUser.getBlog();
        long originalTimestamp = -1L;
        originalTimestamp = this._trackbackDateLong;
        StringBuffer pingbackDirectory = new StringBuffer();
        String permalinkFilename = this._blogEntry.getPermalink();
        if ((permalinkFilename = BlojsomUtils.urlDecode(permalinkFilename)) == null) {
            this._logger.error((Object)("Invalid permalink pingback for: " + permalinkFilename));
            throw new BlojsomException("Invalid permalink pingback for: " + permalinkFilename, (Throwable)new XmlRpcException(32, "Target URI does not exist"));
        }
        pingbackDirectory.append(blog.getBlogHome());
        pingbackDirectory.append(BlojsomUtils.removeInitialSlash(this._blogEntry.getCategory()));
        File blogEntry = new File(pingbackDirectory.toString() + File.separator + permalinkFilename);
        this._logger.debug((Object)("Directory: " + blogEntry.toString()));
        if (!blogEntry.exists()) {
            this._logger.error((Object)("Trying to create pingback for invalid blog entry: " + permalinkFilename));
            throw new BlojsomException("Trying to create pingback for invalid blog entry: " + permalinkFilename, (Throwable)new XmlRpcException(32, "Target URI does not exist"));
        }
        pingbackDirectory.append(blog.getBlogPingbacksDirectory());
        pingbackDirectory.append(File.separator);
        pingbackDirectory.append(permalinkFilename);
        pingbackDirectory.append(File.separator);
        String pingbackFilename = pingbackDirectory.toString() + this._id + ".pb";
        File pingbackDir = new File(pingbackDirectory.toString());
        if (!pingbackDir.exists() && !pingbackDir.mkdirs()) {
            this._logger.error((Object)("Could not create directory for pingbacks: " + pingbackDirectory));
            throw new BlojsomException("Could not create directory for pingbacks: " + pingbackDirectory, (Throwable)new XmlRpcException(49, "Access denied"));
        }
        File pingbackEntry = new File(pingbackFilename);
        if (pingbackEntry.exists()) {
            this._logger.debug((Object)"Pingback already registered");
            throw new BlojsomException("Pingback already registered", (Throwable)new XmlRpcException(48, "Pingback already registered"));
        }
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pingbackEntry), blog.getBlogFileEncoding()));
            bw.write(BlojsomUtils.nullToBlank(this.getTitle()).trim());
            bw.newLine();
            bw.write(BlojsomUtils.nullToBlank(this.getUrl()).trim());
            bw.newLine();
            bw.write(BlojsomUtils.nullToBlank(this.getBlogName()).trim());
            bw.newLine();
            bw.write(BlojsomUtils.nullToBlank(this.getExcerpt()).trim());
            bw.newLine();
            bw.close();
            this._logger.debug((Object)("Added pingback: " + pingbackFilename));
            Properties pingbackMetaDataProperties = BlojsomUtils.mapToProperties(this._metaData, "UTF-8");
            String pingbackMetaDataFilename = BlojsomUtils.getFilename(pingbackEntry.toString()) + ".meta";
            FileOutputStream fos = new FileOutputStream(new File(pingbackMetaDataFilename));
            pingbackMetaDataProperties.store(fos, null);
            fos.close();
            this._logger.debug((Object)("Wrote pingback meta-data: " + pingbackMetaDataFilename));
            this._source = pingbackEntry;
            if (originalTimestamp != -1L) {
                this._source.setLastModified(originalTimestamp);
                File pingbackMetaData = new File(pingbackMetaDataFilename);
                pingbackMetaData.setLastModified(originalTimestamp);
            }
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new BlojsomException(e.getMessage(), (Throwable)new XmlRpcException(0, "Unknown exception occurred"));
        }
    }

    public void delete(BlogUser blogUser) throws BlojsomException {
        Blog blog = blogUser.getBlog();
        if (this._source == null || this._blogEntry == null) {
            throw new BlojsomException("No source file found to delete pingback");
        }
        this._logger.debug((Object)("Deleting pingback " + this._source.getAbsolutePath()));
        if (!this._source.delete()) {
            throw new BlojsomException("Unable to delete pingback: " + this.getId());
        }
        File metaFile = new File(blog.getBlogHome() + this._blogEntry.getCategory() + blog.getBlogPingbacksDirectory() + File.separatorChar + this._blogEntry.getPermalink() + File.separatorChar + BlojsomUtils.getFilename(this._source.getName()) + blog.getBlogEntryMetaDataExtension());
        if (metaFile.exists()) {
            metaFile.delete();
        }
    }
}

