/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.blog;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogComment;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.FileBackedBlogCategory;
import org.blojsom.blog.FileBackedBlogComment;
import org.blojsom.blog.FileBackedPingback;
import org.blojsom.blog.FileBackedTrackback;
import org.blojsom.blog.Pingback;
import org.blojsom.blog.Trackback;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class FileBackedBlogEntry
extends BlogEntry {
    protected transient Log _logger = LogFactory.getLog((Class)FileBackedBlogEntry.class);
    protected transient File _source;
    protected transient String _commentsDirectory;
    protected transient String _trackbacksDirectory;
    protected transient String _pingbacksDirectory;
    protected transient String _blogFileEncoding;

    public FileBackedBlogEntry() {
        this._commentsDirectory = ".comments";
        this._trackbacksDirectory = ".trackbacks";
        this._pingbacksDirectory = ".pingbacks";
        this._blogFileEncoding = "UTF-8";
    }

    public FileBackedBlogEntry(String title, String link, String description, File source) {
        this._title = title;
        this._link = link;
        this._description = description;
        this._source = source;
        this._entryDate = new Date(this._source.lastModified());
    }

    public void setBlogFileEncoding(String blogFileEncoding) {
        this._blogFileEncoding = blogFileEncoding;
    }

    public File getSource() {
        return this._source;
    }

    public void setSource(File source) {
        this._source = source;
    }

    public String getId() {
        String startingSlash = "";
        if (!this._category.startsWith("/")) {
            startingSlash = "/";
        }
        return startingSlash + BlojsomUtils.urlEncodeForLink(this._category) + '?' + "permalink" + '=' + BlojsomUtils.urlEncode(this._source.getName());
    }

    public String getPermalink() {
        return BlojsomUtils.urlEncode(this._source.getName());
    }

    protected void reloadSource(Blog blog) throws IOException {
        boolean hasLoadedTitle = false;
        String lineSeparator = LINE_SEPARATOR;
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._source), blog.getBlogFileEncoding()));
            StringBuffer description = new StringBuffer();
            while ((line = br.readLine()) != null) {
                if (!hasLoadedTitle) {
                    this._title = line;
                    hasLoadedTitle = true;
                    continue;
                }
                description.append(line);
                description.append(lineSeparator);
            }
            br.close();
            this._description = description.toString();
            this._entryDate = new Date(this._source.lastModified());
            this._lastModified = this._source.lastModified();
        }
        catch (IOException e) {
            this._logger.error((Object)e);
        }
    }

    public boolean supportsComments() {
        return this._source.canWrite();
    }

    public boolean supportsTrackbacks() {
        return this._source.canWrite();
    }

    public boolean supportsPingbacks() {
        return this._source.canWrite() && !BlojsomUtils.checkMapForKey(this._metaData, "blog-entry-pingbacks-disabled");
    }

    public void setCommentsDirectory(String commentsDirectory) {
        this._commentsDirectory = commentsDirectory;
    }

    protected void loadComments(BlogUser blogUser) {
        if (this.supportsComments()) {
            String commentsDirectoryPath = this._source.getParent() == null ? File.separator + this._commentsDirectory + File.separator + this._source.getName() : this._source.getParent() + File.separator + this._commentsDirectory + File.separator + this._source.getName();
            File commentsDirectory = new File(commentsDirectoryPath);
            File[] comments = commentsDirectory.listFiles(BlojsomUtils.getExtensionFilter(".cmt"));
            if (comments != null && comments.length > 0) {
                this._logger.debug((Object)("Adding " + comments.length + " comments to blog entry: " + this.getPermalink()));
                Arrays.sort(comments, BlojsomUtils.FILE_TIME_ASCENDING_COMPARATOR);
                this._comments = new ArrayList(comments.length);
                for (int i = 0; i < comments.length; ++i) {
                    File comment = comments[i];
                    try {
                        BlogComment blogComment = this.loadComment(comment, blogUser.getBlog().getBlogFileEncoding(), blogUser);
                        this._comments.add(blogComment);
                        continue;
                    }
                    catch (BlojsomException e) {
                        this._logger.error((Object)e);
                    }
                }
            }
        } else {
            this._logger.debug((Object)"Blog entry does not support comments");
        }
    }

    protected BlogComment loadComment(File commentFile, String blogFileEncoding, BlogUser blogUser) throws BlojsomException {
        FileBackedBlogComment comment = new FileBackedBlogComment();
        comment.setSource(commentFile);
        comment.setBlogEntry(this);
        comment.load(blogUser);
        return comment;
    }

    public void setTrackbacksDirectory(String trackbacksDirectory) {
        this._trackbacksDirectory = trackbacksDirectory;
    }

    protected void loadTrackbacks(BlogUser blogUser) {
        String trackbacksDirectoryPath = this._source.getParent() == null ? File.separator + this._trackbacksDirectory + File.separator + this._source.getName() : this._source.getParent() + File.separator + this._trackbacksDirectory + File.separator + this._source.getName();
        File trackbacksDirectory = new File(trackbacksDirectoryPath);
        File[] trackbacks = trackbacksDirectory.listFiles(BlojsomUtils.getExtensionFilter(".tb"));
        if (trackbacks != null && trackbacks.length > 0) {
            this._logger.debug((Object)("Adding " + trackbacks.length + " trackbacks to blog entry: " + this.getPermalink()));
            Arrays.sort(trackbacks, BlojsomUtils.FILE_TIME_ASCENDING_COMPARATOR);
            this._trackbacks = new ArrayList(trackbacks.length);
            for (int i = 0; i < trackbacks.length; ++i) {
                File trackbackFile = trackbacks[i];
                try {
                    Trackback trackback = this.loadTrackback(trackbackFile, blogUser.getBlog().getBlogFileEncoding(), blogUser);
                    this._trackbacks.add(trackback);
                    continue;
                }
                catch (BlojsomException e) {
                    this._logger.error((Object)e);
                }
            }
        }
    }

    protected Trackback loadTrackback(File trackbackFile, String blogFileEncoding, BlogUser blogUser) throws BlojsomException {
        FileBackedTrackback trackback = new FileBackedTrackback();
        trackback.setSource(trackbackFile);
        trackback.setBlogEntry(this);
        trackback.load(blogUser);
        return trackback;
    }

    public void setPingbacksDirectory(String pingbacksDirectory) {
        this._pingbacksDirectory = pingbacksDirectory;
    }

    protected void loadPingbacks(BlogUser blogUser) {
        String pingbacksDirectoryPath = this._source.getParent() == null ? File.separator + this._pingbacksDirectory + File.separator + this._source.getName() : this._source.getParent() + File.separator + this._pingbacksDirectory + File.separator + this._source.getName();
        File pingbacksDirectory = new File(pingbacksDirectoryPath);
        File[] pingbacks = pingbacksDirectory.listFiles(BlojsomUtils.getExtensionFilter(".pb"));
        if (pingbacks != null && pingbacks.length > 0) {
            this._logger.debug((Object)("Adding " + pingbacks.length + " pingbacks to blog entry: " + this.getPermalink()));
            Arrays.sort(pingbacks, BlojsomUtils.FILE_TIME_ASCENDING_COMPARATOR);
            this._pingbacks = new ArrayList(pingbacks.length);
            for (int i = 0; i < pingbacks.length; ++i) {
                File pingbackFile = pingbacks[i];
                try {
                    Pingback pingback = this.loadPingback(pingbackFile, blogUser.getBlog().getBlogFileEncoding(), blogUser);
                    this._pingbacks.add(pingback);
                    continue;
                }
                catch (BlojsomException e) {
                    this._logger.error((Object)e);
                }
            }
        }
    }

    protected Pingback loadPingback(File pingbackFile, String blogFileEncoding, BlogUser blogUser) throws BlojsomException {
        FileBackedPingback pingback = new FileBackedPingback();
        pingback.setSource(pingbackFile);
        pingback.setBlogEntry(this);
        pingback.load(blogUser);
        return pingback;
    }

    protected void loadMetaData(Blog blog) {
        String blogHome = blog.getBlogHome();
        String blogEntryMetaDataExtension = blog.getBlogEntryMetaDataExtension();
        if (BlojsomUtils.checkNullOrBlank(blogEntryMetaDataExtension)) {
            return;
        }
        String entryFilename = BlojsomUtils.getFilename(this._source.getName());
        File blogEntryMetaData = new File(blogHome + BlojsomUtils.removeInitialSlash(this._category) + entryFilename + blogEntryMetaDataExtension);
        if (blogEntryMetaData.exists()) {
            try {
                BlojsomProperties entryMetaData = new BlojsomProperties(blog.getBlogFileEncoding());
                FileInputStream fis = new FileInputStream(blogEntryMetaData);
                ((Properties)entryMetaData).load(fis);
                fis.close();
                Iterator<Object> keys = entryMetaData.keySet().iterator();
                if (this._metaData == null) {
                    this._metaData = new HashMap(5);
                }
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this._metaData.put(key, ((Properties)entryMetaData).getProperty(key));
                }
                if (this._metaData.containsKey("blog-entry-metadata-timestamp")) {
                    try {
                        long originalTimestamp = Long.parseLong((String)this._metaData.get("blog-entry-metadata-timestamp"));
                        this._entryDate = new Date(originalTimestamp);
                        this._lastModified = originalTimestamp;
                    }
                    catch (NumberFormatException e) {
                        this._logger.error((Object)e);
                    }
                }
                this._logger.debug((Object)("Loaded meta-data from: " + blogEntryMetaData.toString()));
            }
            catch (IOException e) {
                this._logger.error((Object)("Failed loading meta-data from: " + blogEntryMetaData.toString()));
            }
        } else if (this._metaData == null) {
            this._metaData = new HashMap(5);
        }
    }

    protected void saveMetaData(Blog blog) {
        String blogHome = blog.getBlogHome();
        String blogEntryMetaDataExtension = blog.getBlogEntryMetaDataExtension();
        if (BlojsomUtils.checkNullOrBlank(blogEntryMetaDataExtension) || this._metaData == null) {
            return;
        }
        String entryFilename = BlojsomUtils.getFilename(this._source.getName());
        File blogEntryMetaData = new File(blogHome + BlojsomUtils.removeInitialSlash(this._category) + File.separator + entryFilename + blogEntryMetaDataExtension);
        try {
            Properties entryMetaData = BlojsomUtils.mapToProperties(this._metaData, "UTF-8");
            FileOutputStream fos = new FileOutputStream(blogEntryMetaData);
            entryMetaData.store(fos, null);
            fos.close();
            this._logger.debug((Object)("Saved meta-data to: " + blogEntryMetaData.toString()));
        }
        catch (IOException e) {
            this._logger.error((Object)("Failed saving meta-data to: " + blogEntryMetaData.toString()), (Throwable)e);
        }
    }

    protected void loadBlogCategory(BlogUser blogUser) {
        if (this._category != null) {
            Blog blog = blogUser.getBlog();
            FileBackedBlogCategory blogCategoryForEntry = new FileBackedBlogCategory();
            blogCategoryForEntry.setCategory(this._category);
            blogCategoryForEntry.setCategoryURL(blog.getBlogURL() + BlojsomUtils.removeInitialSlash(this._category));
            try {
                blogCategoryForEntry.load(blogUser);
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e);
            }
            if ("/".equals(this._category)) {
                this.setLink(blog.getBlogURL() + '?' + "permalink" + '=' + BlojsomUtils.urlEncode(this._source.getName()));
            } else {
                this.setLink(blog.getBlogURL() + BlojsomUtils.removeInitialSlash(BlojsomUtils.urlEncodeForLink(this._category.substring(0, this._category.length() - 1))) + "/?" + "permalink" + '=' + BlojsomUtils.urlEncode(this._source.getName()));
            }
            this._blogCategory = blogCategoryForEntry;
        }
    }

    public void load(BlogUser blogUser) throws BlojsomException {
        Blog blog = blogUser.getBlog();
        if (this._source == null) {
            throw new BlojsomException("No source file set for this blog entry.");
        }
        try {
            this.reloadSource(blog);
            this.loadBlogCategory(blogUser);
            if (blog.getBlogCommentsEnabled().booleanValue()) {
                this.loadComments(blogUser);
            }
            if (blog.getBlogTrackbacksEnabled().booleanValue()) {
                this.loadTrackbacks(blogUser);
            }
            if (blog.getBlogPingbacksEnabled().booleanValue()) {
                this.loadPingbacks(blogUser);
            }
            this.loadMetaData(blog);
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new BlojsomException(e);
        }
    }

    public void save(BlogUser blogUser) throws BlojsomException {
        Blog blog = blogUser.getBlog();
        if (this._source == null) {
            String category = BlojsomUtils.normalize(this._category);
            category = BlojsomUtils.addSlashes(category);
            String proposedFilename = BlojsomUtils.getBlogEntryFilename(this._title, this._description);
            String fileExtension = blog.getBlogProperty("blog-default-file-extension");
            if (BlojsomUtils.checkNullOrBlank(fileExtension)) {
                fileExtension = ".html";
            }
            File blogFilename = new File(blog.getBlogHome() + category + proposedFilename + fileExtension);
            int fileTag = 1;
            while (blogFilename.exists()) {
                blogFilename = new File(blog.getBlogHome() + category + proposedFilename + "-" + fileTag + fileExtension);
                ++fileTag;
            }
            this._logger.debug((Object)("Created blog entry file: " + blogFilename.toString()));
            this._source = blogFilename;
        }
        try {
            long originalTimestamp = this._source.lastModified();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._source.getAbsolutePath(), false), blog.getBlogFileEncoding()));
            if (BlojsomUtils.checkNullOrBlank(this._title)) {
                bw.write(BlojsomUtils.nullToBlank(this._description));
                bw.close();
            } else {
                bw.write(BlojsomUtils.nullToBlank(this._title));
                bw.newLine();
                bw.write(BlojsomUtils.nullToBlank(this._description));
                bw.close();
            }
            if (this._metaData.containsKey("blog-entry-metadata-timestamp")) {
                try {
                    originalTimestamp = Long.parseLong((String)this._metaData.get("blog-entry-metadata-timestamp"));
                }
                catch (NumberFormatException e) {
                    this._logger.error((Object)e);
                }
            } else {
                this._metaData.put("blog-entry-metadata-timestamp", new Long(originalTimestamp));
            }
            this._source.setLastModified(originalTimestamp);
            this.saveMetaData(blog);
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new BlojsomException(e);
        }
    }

    public void delete(BlogUser blogUser) throws BlojsomException {
        Blog blog = blogUser.getBlog();
        if (this._source == null) {
            throw new BlojsomException("No source file set for this blog entry.");
        }
        this._logger.debug((Object)("Deleting post " + this._source.getAbsolutePath()));
        if (!this._source.delete()) {
            throw new BlojsomException("Unable to delete entry: " + this.getId());
        }
        File _comments = new File(blog.getBlogHome() + this._category + blog.getBlogCommentsDirectory() + File.separatorChar + this._source.getName() + File.separatorChar);
        BlojsomUtils.deleteDirectory(_comments);
        File _trackbacks = new File(blog.getBlogHome() + this._category + blog.getBlogTrackbackDirectory() + File.separatorChar + this._source.getName() + File.separatorChar);
        BlojsomUtils.deleteDirectory(_trackbacks);
        File _pingbacks = new File(blog.getBlogHome() + this._category + blog.getBlogPingbacksDirectory() + File.separatorChar + this._source.getName() + File.separatorChar);
        BlojsomUtils.deleteDirectory(_pingbacks);
        File metaFile = new File(blog.getBlogHome() + this._category + BlojsomUtils.getFilename(this._source.getName()) + blog.getBlogEntryMetaDataExtension());
        if (metaFile.exists()) {
            metaFile.delete();
        }
    }

    public void setAttributes(Map attributeMap) {
        if (attributeMap.containsKey("blog-entry-source")) {
            this._source = (File)attributeMap.get("blog-entry-source");
        }
    }
}

