/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.blog;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogComment;
import org.blojsom.blog.BlogUser;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class FileBackedBlogComment
extends BlogComment {
    private transient Log _logger = LogFactory.getLog((Class)FileBackedBlogComment.class);
    protected transient File _source;

    public File getSource() {
        return this._source;
    }

    public void setSource(File source) {
        this._source = source;
    }

    public void load(BlogUser blogUser) throws BlojsomException {
        if (this._source == null) {
            throw new BlojsomException("No source file set for this comment");
        }
        int commentSwitch = 0;
        this.setCommentDateLong(this._source.lastModified());
        StringBuffer commentDescription = new StringBuffer();
        String separator = BlojsomConstants.LINE_SEPARATOR;
        try {
            String commentLine;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._source), blogUser.getBlog().getBlogFileEncoding()));
            block7: while ((commentLine = br.readLine()) != null) {
                switch (commentSwitch) {
                    case 0: {
                        this.setAuthor(commentLine);
                        ++commentSwitch;
                        continue block7;
                    }
                    case 1: {
                        this.setAuthorEmail(commentLine);
                        ++commentSwitch;
                        continue block7;
                    }
                    case 2: {
                        this.setAuthorURL(commentLine);
                        ++commentSwitch;
                        continue block7;
                    }
                }
                commentDescription.append(commentLine).append(separator);
            }
            this.setComment(commentDescription.toString());
            this.setCommentDate(new Date(this._source.lastModified()));
            this.setId(this._source.getName());
            br.close();
            File commentMetaData = new File(BlojsomUtils.getFilename(this._source.toString()) + ".meta");
            if (commentMetaData.exists()) {
                this._logger.debug((Object)("Loading comment meta-data: " + commentMetaData.toString()));
                BlojsomProperties commentMetaDataProperties = new BlojsomProperties();
                FileInputStream fis = new FileInputStream(commentMetaData);
                ((Properties)commentMetaDataProperties).load(fis);
                fis.close();
                this.setMetaData(BlojsomUtils.propertiesToMap(commentMetaDataProperties));
            }
        }
        catch (IOException e) {
            this._logger.error((Object)e);
        }
    }

    public void save(BlogUser blogUser) throws BlojsomException {
        File commentEntry;
        if (this._blogEntry == null) {
            throw new BlojsomException("Blog entry for this comment not available");
        }
        Blog blog = blogUser.getBlog();
        long originalTimestamp = -1L;
        originalTimestamp = this._commentDateLong;
        if (this._source == null) {
            StringBuffer commentDirectory = new StringBuffer();
            String permalinkFilename = this._blogEntry.getPermalink();
            if ((permalinkFilename = BlojsomUtils.urlDecode(permalinkFilename)) == null) {
                this._logger.debug((Object)("Invalid permalink comment for: " + this._blogEntry.getPermalink()));
                throw new BlojsomException("Invalid permalink comment for: " + this._blogEntry.getPermalink());
            }
            commentDirectory.append(blog.getBlogHome());
            commentDirectory.append(BlojsomUtils.removeInitialSlash(this._blogEntry.getCategory()));
            File blogEntry = new File(commentDirectory.toString() + File.separator + permalinkFilename);
            if (!blogEntry.exists()) {
                this._logger.error((Object)("Trying to create comment for invalid blog entry: " + this._blogEntry.getPermalink()));
                throw new BlojsomException("Trying to create comment for invalid blog entry: " + this._blogEntry.getPermalink());
            }
            commentDirectory.append(blog.getBlogCommentsDirectory());
            commentDirectory.append(File.separator);
            commentDirectory.append(permalinkFilename);
            commentDirectory.append(File.separator);
            String commentHashable = this._author + this._comment;
            String hashedComment = BlojsomUtils.digestString(commentHashable).toUpperCase();
            String commentFilename = commentDirectory.toString() + hashedComment + ".cmt";
            this.setId(hashedComment + ".cmt");
            File commentDir = new File(commentDirectory.toString());
            if (!commentDir.exists() && !commentDir.mkdirs()) {
                this._logger.error((Object)("Could not create directory for comments: " + commentDirectory));
                throw new BlojsomException("Could not create directory for comments: " + commentDirectory);
            }
            commentEntry = new File(commentFilename);
        } else {
            commentEntry = this._source;
            originalTimestamp = this._commentDateLong;
        }
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(commentEntry), blog.getBlogFileEncoding()));
            bw.write(BlojsomUtils.nullToBlank(this.getAuthor()).trim());
            bw.newLine();
            bw.write(BlojsomUtils.nullToBlank(this.getAuthorEmail()).trim());
            bw.newLine();
            bw.write(BlojsomUtils.nullToBlank(this.getAuthorURL()).trim());
            bw.newLine();
            bw.write(BlojsomUtils.nullToBlank(this.getComment()).trim());
            bw.newLine();
            bw.close();
            this._logger.debug((Object)("Added blog comment: " + this._id));
            Properties commentMetaDataProperties = BlojsomUtils.mapToProperties(this._metaData, "UTF-8");
            String commentMetaDataFilename = BlojsomUtils.getFilename(commentEntry.toString()) + ".meta";
            FileOutputStream fos = new FileOutputStream(new File(commentMetaDataFilename));
            commentMetaDataProperties.store(fos, null);
            fos.close();
            this._logger.debug((Object)("Wrote comment meta-data: " + commentMetaDataFilename));
            this._source = commentEntry;
            if (originalTimestamp != -1L) {
                this._source.setLastModified(originalTimestamp);
                File commentMetaData = new File(commentMetaDataFilename);
                commentMetaData.setLastModified(originalTimestamp);
            }
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new BlojsomException(e);
        }
    }

    public void delete(BlogUser blogUser) throws BlojsomException {
        Blog blog = blogUser.getBlog();
        if (this._source == null || this._blogEntry == null) {
            throw new BlojsomException("No source file found to delete comment");
        }
        this._logger.debug((Object)("Deleting comment " + this._source.getAbsolutePath()));
        if (!this._source.delete()) {
            throw new BlojsomException("Unable to delete commnent: " + this.getId());
        }
        File metaFile = new File(blog.getBlogHome() + this._blogEntry.getCategory() + blog.getBlogCommentsDirectory() + File.separatorChar + this._blogEntry.getPermalink() + File.separatorChar + BlojsomUtils.getFilename(this._source.getName()) + blog.getBlogEntryMetaDataExtension());
        if (metaFile.exists()) {
            metaFile.delete();
        } else {
            this._logger.error((Object)("Unable to delete comment meta-data: " + metaFile));
        }
    }
}

