/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.authorization;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.authorization.AuthorizationProvider;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.blog.BlojsomConfigurationException;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class PropertiesAuthorizationProvider
implements AuthorizationProvider,
BlojsomConstants {
    private Log _logger = LogFactory.getLog((Class)PropertiesAuthorizationProvider.class);
    protected ServletConfig _servletConfig;
    protected String _baseConfigurationDirectory;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomConfigurationException {
        this._servletConfig = servletConfig;
        this._baseConfigurationDirectory = blojsomConfiguration.getBaseConfigurationDirectory();
        this._logger.debug((Object)"Initialized properties authorization provider");
    }

    public void loadAuthenticationCredentials(BlogUser blogUser) throws BlojsomException {
        String authorizationConfiguration = this._servletConfig.getInitParameter("blog-authorization");
        if (BlojsomUtils.checkNullOrBlank(authorizationConfiguration)) {
            this._logger.error((Object)"No authorization configuration file specified");
            throw new BlojsomException("No authorization configuration file specified");
        }
        InputStream is = this._servletConfig.getServletContext().getResourceAsStream(this._baseConfigurationDirectory + blogUser.getId() + '/' + authorizationConfiguration);
        BlojsomProperties authorizationProperties = new BlojsomProperties();
        try {
            ((Properties)authorizationProperties).load(is);
            is.close();
            Map authorizationMap = BlojsomUtils.propertiesToMap(authorizationProperties);
            blogUser.getBlog().setAuthorization(authorizationMap);
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new BlojsomException(e);
        }
    }

    public void authorize(BlogUser blogUser, Map authorizationContext, String username, String password) throws BlojsomException {
        Map authorizationMap = blogUser.getBlog().getAuthorization();
        boolean result = false;
        if (authorizationMap != null && authorizationMap.containsKey(username)) {
            String parsedPassword = BlojsomUtils.parseLastComma((String)authorizationMap.get(username))[0];
            if (blogUser.getBlog().getUseEncryptedPasswords().booleanValue()) {
                password = BlojsomUtils.digestString(password, blogUser.getBlog().getDigestAlgorithm());
            }
            if (password.equals(parsedPassword)) {
                result = true;
            }
        }
        if (!result) {
            throw new BlojsomException("Authorization failed for blog user: " + blogUser.getId() + " for username: " + username);
        }
    }

    public void checkPermission(BlogUser blogUser, Map permissionContext, String username, String permission) throws BlojsomException {
        if (username == null) {
            throw new BlojsomException("No username provided to check permission");
        }
        if (permission == null) {
            throw new BlojsomException("Cannot check null permission");
        }
        String permissionsConfiguration = this._servletConfig.getInitParameter("blog-permissions");
        if (BlojsomUtils.checkNullOrBlank(permissionsConfiguration)) {
            this._logger.warn((Object)"No permissions configuration file specified. Using default: permissions.properties");
            permissionsConfiguration = "permissions.properties";
        }
        InputStream is = this._servletConfig.getServletContext().getResourceAsStream(this._baseConfigurationDirectory + blogUser.getId() + '/' + permissionsConfiguration);
        BlojsomProperties permissionsProperties = new BlojsomProperties(true);
        if (is == null) {
            throw new BlojsomException("No permissions configuration file found");
        }
        try {
            Map permissions;
            ((Properties)permissionsProperties).load(is);
            is.close();
            Object permissionsForUser = permissionsProperties.get(username);
            if (permissionsForUser == null) {
                throw new BlojsomException("Permission: " + permission + " not found for username: " + username);
            }
            if (permissionsForUser instanceof List ? !(permissions = BlojsomUtils.listToMap((List)permissionsForUser)).containsKey("*") && !permissions.containsKey(permission) : !"*".equals(permissionsForUser) && !permissionsForUser.equals(permission)) {
                throw new BlojsomException("Permission: " + permission + " not found for username: " + username);
            }
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new BlojsomException(e);
        }
    }
}

