/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.weblogsping;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomFilter;
import org.blojsom.event.BlojsomListener;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.event.AddBlogEntryEvent;
import org.blojsom.plugin.admin.event.BlogEntryEvent;
import org.blojsom.plugin.admin.event.DeletedBlogEntryEvent;
import org.blojsom.plugin.admin.event.UpdatedBlogEntryEvent;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class WeblogsPingPlugin
implements BlojsomListener,
BlojsomPlugin,
BlojsomConstants {
    private Log _logger = LogFactory.getLog((Class)WeblogsPingPlugin.class);
    private static final String WEBLOGS_PING_METHOD = "weblogUpdates.ping";
    private static final String WEBLOGS_EXTENDED_PING_METHOD = "weblogUpdates.extendedPing";
    private static final String DEFAULT_PREFERRED_SYNDICATION_FLAVOR = "rss2";
    public static final String BLOG_PING_URLS_IP = "blog-ping-urls";
    public static final String NO_PING_WEBLOGS_METADATA = "no-ping-weblogs";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        BlojsomFilter pingEventFilter = new BlojsomFilter(){

            public boolean processEvent(BlojsomEvent event) {
                return event instanceof AddBlogEntryEvent || event instanceof DeletedBlogEntryEvent || event instanceof UpdatedBlogEntryEvent;
            }
        };
        blojsomConfiguration.getEventBroadcaster().addListener((BlojsomListener)this, pingEventFilter);
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        return entries;
    }

    public void handleEvent(BlojsomEvent event) {
        if (event instanceof BlogEntryEvent) {
            BlogEntryEvent entryEvent = (BlogEntryEvent)event;
            Blog blog = entryEvent.getBlogUser().getBlog();
            String syndicationURL = blog.getBlogURL();
            Map metaData = entryEvent.getBlogEntry().getMetaData();
            if (BlojsomUtils.checkMapForKey((Map)metaData, (String)NO_PING_WEBLOGS_METADATA)) {
                return;
            }
            String preferredSyndicationFlavor = blog.getBlogProperty("preferred-syndication-flavor");
            if (BlojsomUtils.checkNullOrBlank((String)preferredSyndicationFlavor)) {
                preferredSyndicationFlavor = DEFAULT_PREFERRED_SYNDICATION_FLAVOR;
            }
            syndicationURL = syndicationURL + "?flavor=" + preferredSyndicationFlavor;
            String pingURLsIP = blog.getBlogProperty(BLOG_PING_URLS_IP);
            String[] pingURLs = BlojsomUtils.parseDelimitedList((String)pingURLsIP, (String)" \t\n\f\r");
            if (pingURLs != null && pingURLs.length > 0) {
                Vector<String> params = new Vector<String>();
                Vector<String> extendedParams = new Vector<String>();
                params.add(blog.getBlogName());
                extendedParams.add(blog.getBlogName());
                params.add(blog.getBlogURL());
                extendedParams.add(blog.getBlogURL());
                extendedParams.add(blog.getBlogURL());
                extendedParams.add(syndicationURL);
                for (int i = 0; i < pingURLs.length; ++i) {
                    String pingURL = pingURLs[i];
                    try {
                        XmlRpcClient weblogsPingClient = new XmlRpcClient(pingURL);
                        try {
                            weblogsPingClient.execute(WEBLOGS_EXTENDED_PING_METHOD, extendedParams);
                        }
                        catch (XmlRpcException e) {
                            this._logger.error((Object)e);
                            try {
                                weblogsPingClient.execute(WEBLOGS_PING_METHOD, params);
                            }
                            catch (XmlRpcException e1) {
                                this._logger.error((Object)e1);
                            }
                            catch (IOException e1) {
                                this._logger.error((Object)e1);
                            }
                        }
                        catch (IOException e) {
                            this._logger.error((Object)e);
                        }
                        continue;
                    }
                    catch (MalformedURLException e) {
                        this._logger.error((Object)e);
                    }
                }
                this._logger.debug((Object)"Pinged notification URLs based on blog entry event");
            } else {
                this._logger.debug((Object)"No ping notification URLs specified");
            }
        }
    }

    public void processEvent(BlojsomEvent event) {
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

