/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.weather.beans;

import java.text.MessageFormat;
import org.blojsom.plugin.weather.beans.WeatherInformation;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NWSInformation
implements WeatherInformation {
    public static final String NWS_URL_FORMAT = "http://www.nws.noaa.gov/data/current_obs/{0}.xml";
    public static final String TAG_CREDIT = "credit";
    public static final String TAG_CREDIT_URL = "credit_URL";
    public static final String TAG_LOCATION = "location";
    public static final String TAG_OBSERVATION = "observation_time";
    public static final String TAG_WEATHER = "weather";
    public static final String TAG_TEMP_STRING = "temperature_string";
    public static final String TAG_TEMP_F = "temp_f";
    public static final String TAG_TEMP_C = "temp_c";
    public static final String TAG_HUMIDITY = "relative_humidity";
    public static final String TAG_WIND_STRING = "wind_string";
    public static final String TAG_WIND_DIRECTION = "wind_dir";
    public static final String TAG_WIND_DEGREES = "wind_degrees";
    public static final String TAG_WIND_MPH = "wind_mph";
    public static final String TAG_WIND_GUST_MPH = "wind_gust_mph";
    public static final String TAG_STATION = "station_id";
    public static final String TAG_VISIBILITY = "visibility_mi";
    public static final String TAG_HISTORY = "two_day_history_url";
    private String _temperatureF = "-0 F";
    private String _temperatureC = "-0 C";
    private String _stationCode = "";
    private String _location = "a";
    private String _visibility = "";
    private String _wind = "";
    private String _history = "#";
    private Document _document;

    public NWSInformation(String stationCode) {
        this._stationCode = stationCode;
    }

    public void parseDocument(Document document) {
        this._document = document;
        this._temperatureC = this.getValueOfTag(TAG_TEMP_C);
        this._temperatureF = this.getValueOfTag(TAG_TEMP_F);
        this._stationCode = this.getValueOfTag(TAG_STATION);
        this._location = this.getValueOfTag(TAG_LOCATION);
        this._visibility = this.getValueOfTag(TAG_VISIBILITY);
        this._wind = this.getValueOfTag(TAG_WIND_STRING);
        this._history = this.getValueOfTag(TAG_HISTORY);
    }

    private String getValueOfTag(String tag) {
        String result = null;
        try {
            Node tempNode;
            Node value;
            NodeList nodeList = this._document.getElementsByTagName(tag);
            if (nodeList != null && (value = (tempNode = nodeList.item(0)).getFirstChild()) != null) {
                result = value.getNodeValue();
            }
        }
        catch (DOMException e) {
            result = null;
        }
        return result;
    }

    public String getLocation() {
        return this._location;
    }

    public String getStationCode() {
        return this._stationCode;
    }

    public String getFahrenheit() {
        return this._temperatureF + " F";
    }

    public String getCelcius() {
        return this._temperatureC + " C";
    }

    public String getVisibility() {
        return this._visibility;
    }

    public String getWind() {
        return this._wind;
    }

    public String getHistoryUrl() {
        return this._history;
    }

    public String getProviderUrl() {
        return MessageFormat.format(NWS_URL_FORMAT, this._stationCode);
    }

    public String getValueForTag(String tag) {
        return this.getValueOfTag(tag);
    }
}

