/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.velocity;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public abstract class StandaloneVelocityPlugin
implements BlojsomPlugin,
BlojsomConstants {
    protected Log _logger = LogFactory.getLog((Class)StandaloneVelocityPlugin.class);
    private static final String BLOG_VELOCITY_PROPERTIES_IP = "velocity-properties";
    private static final String DEFAULT_VELOCITY_PROPERTIES = "/WEB-INF/velocity.properties";
    protected String _installationDirectory;
    protected String _baseConfigurationDirectory;
    protected String _templatesDirectory;
    protected Properties _velocityProperties;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._baseConfigurationDirectory = blojsomConfiguration.getBaseConfigurationDirectory();
        this._installationDirectory = blojsomConfiguration.getInstallationDirectory();
        this._templatesDirectory = blojsomConfiguration.getTemplatesDirectory();
        this._logger.debug((Object)("Using templates directory: " + this._templatesDirectory));
        String velocityConfiguration = servletConfig.getInitParameter(BLOG_VELOCITY_PROPERTIES_IP);
        if (BlojsomUtils.checkNullOrBlank((String)velocityConfiguration)) {
            velocityConfiguration = DEFAULT_VELOCITY_PROPERTIES;
        }
        this._velocityProperties = new Properties();
        InputStream is = servletConfig.getServletContext().getResourceAsStream(velocityConfiguration);
        try {
            this._velocityProperties.load(is);
            is.close();
        }
        catch (Exception e) {
            this._logger.error((Object)e);
        }
        this._logger.debug((Object)"Initialized Standalone Velocity plugin");
    }

    protected String getVelocityFileLoaderPath(String userId) {
        StringBuffer fileLoaderPath = new StringBuffer();
        fileLoaderPath.append(this._installationDirectory);
        fileLoaderPath.append(BlojsomUtils.removeInitialSlash((String)this._baseConfigurationDirectory));
        fileLoaderPath.append(userId).append("/");
        fileLoaderPath.append(BlojsomUtils.removeInitialSlash((String)this._templatesDirectory));
        fileLoaderPath.append(", ");
        fileLoaderPath.append(this._installationDirectory);
        fileLoaderPath.append(BlojsomUtils.removeInitialSlash((String)this._baseConfigurationDirectory));
        fileLoaderPath.append(BlojsomUtils.removeInitialSlash((String)this._templatesDirectory));
        return fileLoaderPath.toString();
    }

    protected String mergeTemplate(String template, BlogUser user, Map context) {
        VelocityEngine velocityEngine = new VelocityEngine();
        try {
            Properties updatedVelocityProperties = (Properties)this._velocityProperties.clone();
            updatedVelocityProperties.setProperty("file.resource.loader.path", this.getVelocityFileLoaderPath(user.getId()));
            velocityEngine.init(updatedVelocityProperties);
        }
        catch (Exception e) {
            this._logger.error((Object)e);
            return null;
        }
        StringWriter writer = new StringWriter();
        VelocityContext velocityContext = new VelocityContext(context);
        if (!velocityEngine.templateExists(template)) {
            this._logger.error((Object)("Could not find template for user: " + template));
            return null;
        }
        try {
            velocityEngine.mergeTemplate(template, "UTF-8", (Context)velocityContext, (Writer)writer);
        }
        catch (Exception e) {
            this._logger.error((Object)e);
            return null;
        }
        this._logger.debug((Object)("Merged template: " + template));
        return writer.toString();
    }
}

