/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.trackback;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomConstants;

public class AutoTrackbackPlugin
implements BlojsomPlugin,
BlojsomConstants {
    private Log _logger = LogFactory.getLog((Class)AutoTrackbackPlugin.class);
    private static final int REGEX_OPTIONS = 42;
    private static final Pattern RDF_OUTER_PATTERN = Pattern.compile("(<rdf:RDF.*?</rdf:RDF>).*?", 42);
    private static final Pattern RDF_INNER_PATTERN = Pattern.compile("(<rdf:Description.*/>)", 42);
    private static final Pattern DC_IDENTIFIER_PATTERN = Pattern.compile("dc:identifier=\"(.*)\"");
    private static final Pattern TRACKBACK_PING_PATTERN = Pattern.compile("trackback:ping=\"(.*)\"");
    private static final Pattern HREF_PATTERN = Pattern.compile("<\\s*a.*href\\s*=\\s*\"(([^\"]+).*?)\"\\s*>", 42);

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    private void trackbackAutodiscovery(Blog blog, BlogEntry blogEntry) {
        try {
            StringBuffer trackbackPingURLParameters = new StringBuffer();
            trackbackPingURLParameters.append("&").append("url").append("=").append(blogEntry.getLink());
            trackbackPingURLParameters.append("&").append("title").append("=").append(URLEncoder.encode(blogEntry.getTitle(), "UTF-8"));
            trackbackPingURLParameters.append("&").append("blog_name").append("=").append(URLEncoder.encode(blog.getBlogName(), "UTF-8"));
            String excerpt = blogEntry.getDescription().replaceAll("<.*?>", "");
            if (excerpt.length() > 255) {
                excerpt = excerpt.substring(0, 251);
                excerpt = excerpt + "...";
            }
            trackbackPingURLParameters.append("&").append("excerpt").append("=").append(URLEncoder.encode(excerpt, "UTF-8"));
            Matcher hrefMatcher = HREF_PATTERN.matcher(blogEntry.getDescription());
            while (hrefMatcher.find()) {
                String html;
                if (hrefMatcher.groupCount() != 2) continue;
                String hyperlink = hrefMatcher.group(1);
                this._logger.debug((Object)("Found hyperlink: " + hyperlink));
                URL hyperlinkURL = new URL(hyperlink);
                BufferedReader br = new BufferedReader(new InputStreamReader(hyperlinkURL.openStream()));
                StringBuffer contents = new StringBuffer();
                while ((html = br.readLine()) != null) {
                    contents.append(html).append("\n");
                }
                Matcher rdfOuterMatcher = RDF_OUTER_PATTERN.matcher(contents.toString());
                while (rdfOuterMatcher.find()) {
                    this._logger.debug((Object)"Found outer RDF text in hyperlink");
                    for (int i = 0; i < rdfOuterMatcher.groupCount(); ++i) {
                        String outerRdfText = rdfOuterMatcher.group(i);
                        Matcher rdfInnerMatcher = RDF_INNER_PATTERN.matcher(outerRdfText);
                        while (rdfInnerMatcher.find()) {
                            this._logger.debug((Object)"Found inner RDF text in hyperlink");
                            for (int j = 0; j < rdfInnerMatcher.groupCount(); ++j) {
                                String line;
                                String dcIdentifier;
                                String innerRdfText = rdfInnerMatcher.group(j);
                                Matcher dcIdentifierMatcher = DC_IDENTIFIER_PATTERN.matcher(innerRdfText);
                                if (!dcIdentifierMatcher.find() || !(dcIdentifier = dcIdentifierMatcher.group(1)).equals(hyperlink)) continue;
                                this._logger.debug((Object)"Matched dc:identifier to hyperlink");
                                Matcher trackbackPingMatcher = TRACKBACK_PING_PATTERN.matcher(innerRdfText);
                                if (!trackbackPingMatcher.find()) continue;
                                StringBuffer trackbackPingURL = new StringBuffer(trackbackPingMatcher.group(1));
                                this._logger.debug((Object)("Automatically sending trackback ping to URL: " + trackbackPingURL.toString()));
                                URL trackbackUrl = new URL(trackbackPingURL.toString());
                                HttpURLConnection trackbackUrlConnection = (HttpURLConnection)trackbackUrl.openConnection();
                                trackbackUrlConnection.setRequestMethod("POST");
                                trackbackUrlConnection.setRequestProperty("Content-Encoding", "UTF-8");
                                trackbackUrlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                                trackbackUrlConnection.setRequestProperty("Content-Length", "" + trackbackPingURLParameters.length());
                                trackbackUrlConnection.setDoOutput(true);
                                trackbackUrlConnection.getOutputStream().write(trackbackPingURLParameters.toString().getBytes("UTF-8"));
                                trackbackUrlConnection.connect();
                                BufferedReader trackbackStatus = new BufferedReader(new InputStreamReader(trackbackUrlConnection.getInputStream()));
                                StringBuffer status = new StringBuffer();
                                while ((line = trackbackStatus.readLine()) != null) {
                                    status.append(line).append("\n");
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            this._logger.error((Object)e);
        }
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            if (entry.getMetaData() != null) {
                Map entryMetaData = entry.getMetaData();
                if (!entryMetaData.containsKey("auto-trackback") || entryMetaData.containsKey("auto-trackback-complete")) continue;
                this.trackbackAutodiscovery(user.getBlog(), entry);
                entryMetaData.put("auto-trackback-complete", "true");
                try {
                    entry.save(user);
                }
                catch (BlojsomException e) {
                    this._logger.error((Object)e);
                }
                continue;
            }
            this._logger.debug((Object)("Skipping blog entry for autotrackback: " + entry.getPermalink()));
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

