/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.technorati;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomListener;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.event.ProcessBlogEntryEvent;
import org.blojsom.plugin.velocity.StandaloneVelocityPlugin;
import org.blojsom.util.BlojsomUtils;

public class TechnoratiTagsPlugin
extends StandaloneVelocityPlugin
implements BlojsomListener {
    private Log _logger = LogFactory.getLog((Class)TechnoratiTagsPlugin.class);
    private static final String TECHNORATI_TAGS_TEMPLATE = "org/blojsom/plugin/technorati/templates/admin-technorati-tags.vm";
    private static final String TECHNORATI_TAG_LINK_TEMPLATE = "org/blojsom/plugin/technorati/templates/technorati-tag-link.vm";
    private static final String TECHNORATI_TAGS = "TECHNORATI_TAGS";
    private static final String TECHNORATI_TAG_LINKS = "TECHNORATI_TAG_LINKS";
    public static final String METADATA_TECHNORATI_TAGS = "technorati-tags";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        blojsomConfiguration.getEventBroadcaster().addListener((BlojsomListener)this);
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        for (int i = 0; i < entries.length; ++i) {
            String[] tags;
            BlogEntry entry = entries[i];
            Map entryMetaData = entry.getMetaData();
            if (!BlojsomUtils.checkMapForKey((Map)entryMetaData, (String)METADATA_TECHNORATI_TAGS) || (tags = BlojsomUtils.parseOnlyCommaList((String)((String)entryMetaData.get(METADATA_TECHNORATI_TAGS)))) == null || tags.length <= 0) continue;
            ArrayList<String> tagLinks = new ArrayList<String>(tags.length);
            String tagLinkTemplate = this.mergeTemplate(TECHNORATI_TAG_LINK_TEMPLATE, user, new HashMap());
            for (int j = 0; j < tags.length; ++j) {
                String tag = tags[j].trim();
                tagLinks.add(MessageFormat.format(tagLinkTemplate, tag));
            }
            entryMetaData.put(TECHNORATI_TAG_LINKS, tagLinks.toArray(new String[tagLinks.size()]));
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public void handleEvent(BlojsomEvent event) {
    }

    public void processEvent(BlojsomEvent event) {
        if (event instanceof ProcessBlogEntryEvent) {
            this._logger.debug((Object)"Handling process blog entry event");
            ProcessBlogEntryEvent processBlogEntryEvent = (ProcessBlogEntryEvent)event;
            String technoratiTags = BlojsomUtils.getRequestValue((String)METADATA_TECHNORATI_TAGS, (HttpServletRequest)processBlogEntryEvent.getHttpServletRequest());
            Map context = processBlogEntryEvent.getContext();
            TreeMap<String, String> templateAdditions = (TreeMap<String, String>)processBlogEntryEvent.getContext().get("BLOJSOM_TEMPLATE_ADDITIONS");
            if (templateAdditions == null) {
                templateAdditions = new TreeMap<String, String>();
            }
            templateAdditions.put(this.getClass().getName(), "#parse('org/blojsom/plugin/technorati/templates/admin-technorati-tags.vm')");
            processBlogEntryEvent.getContext().put("BLOJSOM_TEMPLATE_ADDITIONS", templateAdditions);
            context.put(TECHNORATI_TAGS, technoratiTags);
            if (processBlogEntryEvent.getBlogEntry() != null) {
                processBlogEntryEvent.getBlogEntry().getMetaData().put(METADATA_TECHNORATI_TAGS, technoratiTags);
            }
            processBlogEntryEvent.getContext().put(TECHNORATI_TAGS, technoratiTags);
            this._logger.debug((Object)("Added/updated tags: " + technoratiTags));
        }
    }
}

