/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.technorati;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomUtils;

public class TagCloudPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)TagCloudPlugin.class);
    private static final String TAG_QUERY_PARAM = "tq";
    private static final String BLOJSOM_PLUGIN_TAG_CLOUD_MAP = "BLOJSOM_PLUGIN_TAG_CLOUD_MAP";
    private static final int MIN_FONTSIZE = 1;
    private static final int MAX_FONTSIZE = 10;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        TreeMap<String, Integer> tagMap = new TreeMap<String, Integer>();
        String tagQuery = BlojsomUtils.getRequestValue((String)TAG_QUERY_PARAM, (HttpServletRequest)httpServletRequest);
        ArrayList<BlogEntry> entriesMatchingTagQuery = new ArrayList<BlogEntry>(10);
        Integer maxTagCount = new Integer(1);
        for (int i = 0; i < entries.length; ++i) {
            String[] tags;
            BlogEntry entry = entries[i];
            if (!BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)"technorati-tags") || (tags = BlojsomUtils.parseOnlyCommaList((String)((String)entry.getMetaData().get("technorati-tags")))) == null || tags.length <= 0) continue;
            for (int j = 0; j < tags.length; ++j) {
                String tag = tags[j].trim();
                if (!BlojsomUtils.checkNullOrBlank((String)tagQuery) && tagQuery.equals(tag)) {
                    entriesMatchingTagQuery.add(entries[i]);
                }
                if (tagMap.containsKey(tag)) {
                    Integer tagCount = (Integer)tagMap.get(tag);
                    if ((tagCount = new Integer(tagCount + 1)) > maxTagCount) {
                        maxTagCount = new Integer(tagCount);
                    }
                    tagMap.put(tag, tagCount);
                    continue;
                }
                tagMap.put(tag, new Integer(1));
            }
        }
        Iterator tagKeyIterator = tagMap.keySet().iterator();
        while (tagKeyIterator.hasNext()) {
            String tag = (String)tagKeyIterator.next();
            Integer tagCount = (Integer)tagMap.get(tag);
            int tagRank = this.rankTagPerEntries(tagCount, 1, maxTagCount);
            this._logger.debug((Object)("Tag rank for " + tag + " tag: " + tagRank));
            tagMap.put(tag, new Integer(tagRank));
        }
        context.put(BLOJSOM_PLUGIN_TAG_CLOUD_MAP, tagMap);
        if (!BlojsomUtils.checkNullOrBlank((String)tagQuery) && entriesMatchingTagQuery.size() > 0) {
            return entriesMatchingTagQuery.toArray(new BlogEntry[entriesMatchingTagQuery.size()]);
        }
        return entries;
    }

    private int rankTagPerEntries(int tagCount, int minTagCount, int maxTagCount) {
        if (minTagCount == maxTagCount) {
            return 10;
        }
        double scaledCount = (double)(tagCount - minTagCount) / (double)(maxTagCount - minTagCount);
        double scaledSize = scaledCount * 9.0 + 1.0;
        return (int)Math.ceil(scaledSize);
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

