/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.statistics;

import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomUtils;

public class WordCountPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)WordCountPlugin.class);
    public static final String WORD_COUNT_PLUGIN_HELPER = "WORD_COUNT_PLUGIN_HELPER";
    public static final String BLOJSOM_PLUGIN_WORD_COUNT_METADATA = "blojsom-plugin-word-count";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._logger.debug((Object)"Initialized Word Count plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            Map entryMetaData = entry.getMetaData();
            if (entry.getDescription() == null) {
                entryMetaData.put(BLOJSOM_PLUGIN_WORD_COUNT_METADATA, new Integer(0));
            } else {
                String entryWithoutTags = entry.getDescription();
                entryWithoutTags = entryWithoutTags.replaceAll("\\<.*?\\>", "");
                StringTokenizer tokenizer = new StringTokenizer(entryWithoutTags);
                entryMetaData.put(BLOJSOM_PLUGIN_WORD_COUNT_METADATA, new Integer(tokenizer.countTokens()));
            }
            entry.setMetaData(entryMetaData);
        }
        context.put(WORD_COUNT_PLUGIN_HELPER, new WordCountHelper());
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public class WordCountHelper {
        public Integer countWords(String text) {
            if (BlojsomUtils.checkNullOrBlank((String)text)) {
                return new Integer(0);
            }
            String textWithoutTokens = text.replaceAll("\\<.*?\\>", "");
            StringTokenizer tokenizer = new StringTokenizer(textWithoutTokens);
            return new Integer(tokenizer.countTokens());
        }
    }
}

