/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.statistics;

import java.util.Date;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomUtils;

public class DaysSincePostedPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)DaysSincePostedPlugin.class);
    public static final String DAYS_SINCE_POSTED_PLUGIN_HELPER = "DAYS_SINCE_POSTED_PLUGIN_HELPER";
    public static final String BLOJSOM_PLUGIN_DAYS_SINCE_POSTED_METADATA = "blojsom-plugin-days-since-posted";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._logger.debug((Object)"Initialized Days Since Posted plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        Date today = new Date();
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            Map metaData = entry.getMetaData();
            Integer daysSincePosted = new Integer(BlojsomUtils.daysBetweenDates((Date)entry.getDate(), (Date)today));
            metaData.put(BLOJSOM_PLUGIN_DAYS_SINCE_POSTED_METADATA, daysSincePosted);
            entry.setMetaData(metaData);
        }
        context.put(DAYS_SINCE_POSTED_PLUGIN_HELPER, new DaysSincePostedHelper());
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public class DaysSincePostedHelper {
        public Integer daysSincePosted(Date date) {
            return new Integer(BlojsomUtils.daysBetweenDates((Date)date, (Date)new Date()));
        }
    }
}

