/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.showmore.admin;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.WebAdminPlugin;
import org.blojsom.plugin.showmore.ShowMeMoreConfiguration;
import org.blojsom.plugin.showmore.ShowMeMoreUtilities;
import org.blojsom.util.BlojsomUtils;

public class ShowMeMoreAdminPlugin
extends WebAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)ShowMeMoreAdminPlugin.class);
    private String _showMeMoreConfigurationFile;
    private static final String FAILED_SHOWMEMORE_PERMISSION_KEY = "failed.showmemore.permission.text";
    private static final String FAILED_SHOWMEMORE_CONFIGURATION_SAVE_KEY = "failed.showmemore.configuration.save.text";
    private static final String SAVED_SHOWMEMORE_CONFIGURATION_KEY = "saved.showmemore.configuration.text";
    private static final String EDIT_SHOWMEMORE_SETTINGS_PAGE = "/org/blojsom/plugin/showmore/admin/templates/admin-edit-showmemore-settings";
    private static final String UPDATE_SHOWMEMORE_SETTINGS = "update-showmemore-settings";
    private static final String SHOWMEMORE_CONFIGURATION = "SHOWMEMORE_CONFIGURATION";
    private static final String SHOWMEMORE_ADMIN_PERMISSION = "showmemore_admin";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        this._showMeMoreConfigurationFile = servletConfig.getInitParameter("plugin-showmemore");
        if (BlojsomUtils.checkNullOrBlank((String)this._showMeMoreConfigurationFile)) {
            throw new BlojsomPluginException("No value given for: plugin-showmemore configuration parameter");
        }
    }

    public String getDisplayName() {
        return "Show Me More plugin";
    }

    public String getInitialPage() {
        return EDIT_SHOWMEMORE_SETTINGS_PAGE;
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        entries = super.process(httpServletRequest, httpServletResponse, user, context, entries);
        String page = BlojsomUtils.getRequestValue((String)"page", (HttpServletRequest)httpServletRequest);
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, SHOWMEMORE_ADMIN_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_SHOWMEMORE_PERMISSION_KEY, FAILED_SHOWMEMORE_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        if ("/org/blojsom/plugin/admin/templates/admin-login".equals(page)) {
            return entries;
        }
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        ShowMeMoreConfiguration showMeMoreConfiguration = new ShowMeMoreConfiguration();
        if (UPDATE_SHOWMEMORE_SETTINGS.equals(action)) {
            String cutoffLength = BlojsomUtils.getRequestValue((String)"entry-length-cutoff", (HttpServletRequest)httpServletRequest);
            int entryLengthCutoff = 400;
            try {
                entryLengthCutoff = Integer.parseInt(cutoffLength);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            String entryTextCutoff = BlojsomUtils.getRequestValue((String)"entry-text-cutoff", (HttpServletRequest)httpServletRequest);
            String showMoreText = BlojsomUtils.getRequestValue((String)"show-me-more-text", (HttpServletRequest)httpServletRequest);
            String textCutoffStart = BlojsomUtils.getRequestValue((String)"entry-text-cutoff-start", (HttpServletRequest)httpServletRequest);
            String textCutoffEnd = BlojsomUtils.getRequestValue((String)"entry-text-cutoff-end", (HttpServletRequest)httpServletRequest);
            showMeMoreConfiguration = new ShowMeMoreConfiguration(entryLengthCutoff, entryTextCutoff, showMoreText, textCutoffStart, textCutoffEnd);
            try {
                ShowMeMoreUtilities.saveConfiguration(user.getId(), this._showMeMoreConfigurationFile, this._blojsomConfiguration, showMeMoreConfiguration);
                this.addOperationResultMessage(context, this.getAdminResource(SAVED_SHOWMEMORE_CONFIGURATION_KEY, SAVED_SHOWMEMORE_CONFIGURATION_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_SHOWMEMORE_CONFIGURATION_SAVE_KEY, FAILED_SHOWMEMORE_CONFIGURATION_SAVE_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
        }
        try {
            showMeMoreConfiguration = ShowMeMoreUtilities.loadConfiguration(user.getId(), this._showMeMoreConfigurationFile, this._blojsomConfiguration, this._servletConfig);
        }
        catch (IOException e) {
            this._logger.error((Object)e);
        }
        context.put(SHOWMEMORE_CONFIGURATION, showMeMoreConfiguration);
        return entries;
    }
}

