/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.showmore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.showmore.ShowMeMoreConfiguration;
import org.blojsom.util.BlojsomProperties;

public class ShowMeMoreUtilities {
    private ShowMeMoreUtilities() {
    }

    public static ShowMeMoreConfiguration loadConfiguration(String blogID, String showMeMoreConfigurationFile, BlojsomConfiguration blojsomConfiguration, ServletConfig servletConfig) throws IOException {
        int cutoff;
        BlojsomProperties showMeMoreProperties = new BlojsomProperties();
        String configurationFile = blojsomConfiguration.getBaseConfigurationDirectory() + blogID + '/' + showMeMoreConfigurationFile;
        InputStream is = servletConfig.getServletContext().getResourceAsStream(configurationFile);
        if (is == null) {
            throw new IOException("No show me more configuration file found: " + configurationFile);
        }
        showMeMoreProperties.load(is);
        is.close();
        String moreText = showMeMoreProperties.getProperty("show-me-more-text");
        String textCutoff = showMeMoreProperties.getProperty("entry-text-cutoff");
        String textCutoffStart = showMeMoreProperties.getProperty("entry-text-cutoff-start");
        String textCutoffEnd = showMeMoreProperties.getProperty("entry-text-cutoff-end");
        try {
            cutoff = Integer.parseInt(showMeMoreProperties.getProperty("entry-length-cutoff"));
        }
        catch (NumberFormatException e) {
            cutoff = 400;
        }
        ShowMeMoreConfiguration showMeMore = new ShowMeMoreConfiguration(cutoff, textCutoff, moreText, textCutoffStart, textCutoffEnd);
        return showMeMore;
    }

    public static void saveConfiguration(String blogID, String showMeMoreConfigurationFile, BlojsomConfiguration blojsomConfiguration, ShowMeMoreConfiguration showMeMoreConfiguration) throws IOException {
        BlojsomProperties showMeMoreProperties = new BlojsomProperties();
        showMeMoreProperties.put("entry-text-cutoff", showMeMoreConfiguration.getTextCutoff());
        showMeMoreProperties.put("entry-text-cutoff-start", showMeMoreConfiguration.getTextCutoffStart());
        showMeMoreProperties.put("entry-text-cutoff-end", showMeMoreConfiguration.getTextCutoffEnd());
        showMeMoreProperties.put("show-me-more-text", showMeMoreConfiguration.getMoreText());
        showMeMoreProperties.put("entry-length-cutoff", Integer.toString(showMeMoreConfiguration.getCutoff()));
        File showMeMoreConfig = new File(blojsomConfiguration.getInstallationDirectory() + blojsomConfiguration.getBaseConfigurationDirectory() + blogID + "/" + showMeMoreConfigurationFile);
        FileOutputStream fos = new FileOutputStream(showMeMoreConfig);
        showMeMoreProperties.store(fos, null);
        fos.close();
    }
}

