/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.showmore;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.showmore.ShowMeMoreConfiguration;
import org.blojsom.plugin.showmore.ShowMeMoreUtilities;
import org.blojsom.util.BlojsomUtils;

public class ShowMeMorePlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)ShowMeMorePlugin.class);
    private static final String SHOW_ME_MORE_PARAM = "smm";
    public static final String SHOW_ME_MORE_CONFIG_IP = "plugin-showmemore";
    public static final String ENTRY_LENGTH_CUTOFF = "entry-length-cutoff";
    public static final String ENTRY_TEXT_CUTOFF = "entry-text-cutoff";
    public static final String SHOW_ME_MORE_TEXT = "show-me-more-text";
    public static final String ENTRY_TEXT_CUTOFF_START = "entry-text-cutoff-start";
    public static final String ENTRY_TEXT_CUTOFF_END = "entry-text-cutoff-end";
    public static final int ENTRY_TEXT_CUTOFF_DEFAULT = 400;
    private String _showMeMoreConfigurationFile;
    private BlojsomConfiguration _blojsomConfiguration;
    private ServletConfig _servletConfig;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._servletConfig = servletConfig;
        this._blojsomConfiguration = blojsomConfiguration;
        this._showMeMoreConfigurationFile = servletConfig.getInitParameter(SHOW_ME_MORE_CONFIG_IP);
        if (BlojsomUtils.checkNullOrBlank((String)this._showMeMoreConfigurationFile)) {
            throw new BlojsomPluginException("No value given for: plugin-showmemore configuration parameter");
        }
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        ShowMeMoreConfiguration showMeMoreConfiguration;
        String wantsToSeeMore = httpServletRequest.getParameter(SHOW_ME_MORE_PARAM);
        if ("y".equalsIgnoreCase(wantsToSeeMore)) {
            return entries;
        }
        try {
            showMeMoreConfiguration = ShowMeMoreUtilities.loadConfiguration(user.getId(), this._showMeMoreConfigurationFile, this._blojsomConfiguration, this._servletConfig);
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            return entries;
        }
        int cutoff = showMeMoreConfiguration.getCutoff();
        String textCutoff = showMeMoreConfiguration.getTextCutoff();
        String moreText = showMeMoreConfiguration.getMoreText();
        String textCutoffStart = showMeMoreConfiguration.getTextCutoffStart();
        String textCutoffEnd = showMeMoreConfiguration.getTextCutoffEnd();
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            String description = entry.getDescription();
            StringBuffer partialDescription = new StringBuffer();
            if (!BlojsomUtils.checkNullOrBlank((String)textCutoffStart) && !BlojsomUtils.checkNullOrBlank((String)textCutoffEnd)) {
                StringBuffer showMeMoreText = new StringBuffer("<a href=\"");
                showMeMoreText.append(entry.getLink());
                showMeMoreText.append("&amp;");
                showMeMoreText.append(SHOW_ME_MORE_PARAM);
                showMeMoreText.append("=y\">");
                showMeMoreText.append(moreText);
                showMeMoreText.append("</a>");
                Pattern cutoffPattern = Pattern.compile("(" + textCutoffStart + ".*?" + textCutoffEnd + ").*?", 42);
                Matcher cutoffMatcher = cutoffPattern.matcher(description);
                if (cutoffMatcher.find()) {
                    description = cutoffMatcher.replaceAll(showMeMoreText.toString());
                    entry.setDescription(description);
                }
            }
            if (!BlojsomUtils.checkNullOrBlank((String)textCutoff)) {
                int indexOfCutoffText = description.indexOf(textCutoff);
                if (indexOfCutoffText != -1) {
                    partialDescription.append(description.substring(0, indexOfCutoffText));
                    partialDescription.append("&nbsp; <a href=\"");
                    partialDescription.append(entry.getLink());
                    partialDescription.append("&amp;");
                    partialDescription.append(SHOW_ME_MORE_PARAM);
                    partialDescription.append("=y\">");
                    partialDescription.append(moreText);
                    partialDescription.append("</a>");
                    entry.setDescription(partialDescription.toString());
                    continue;
                }
                if (cutoff <= 0 || description.length() <= cutoff) continue;
                partialDescription.append(description.substring(0, cutoff));
                partialDescription.append("&nbsp; <a href=\"");
                partialDescription.append(entry.getLink());
                partialDescription.append("&amp;");
                partialDescription.append(SHOW_ME_MORE_PARAM);
                partialDescription.append("=y\">");
                partialDescription.append(moreText);
                partialDescription.append("</a>");
                entry.setDescription(partialDescription.toString());
                continue;
            }
            if (cutoff <= 0 || description.length() <= cutoff) continue;
            partialDescription.append(description.substring(0, cutoff));
            partialDescription.append("&nbsp; <a href=\"");
            partialDescription.append(entry.getLink());
            partialDescription.append("&amp;");
            partialDescription.append(SHOW_ME_MORE_PARAM);
            partialDescription.append("=y\">");
            partialDescription.append(moreText);
            partialDescription.append("</a>");
            entry.setDescription(partialDescription.toString());
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

