/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.search;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;

public class SimpleSearchPlugin
implements BlojsomPlugin {
    public static final String QUERY_PARAM = "query";
    private Log _logger = LogFactory.getLog((Class)SimpleSearchPlugin.class);

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String query = httpServletRequest.getParameter(QUERY_PARAM);
        if (query == null) {
            return entries;
        }
        this._logger.debug((Object)("User query: " + query));
        query = query.toLowerCase();
        ArrayList<BlogEntry> entriesMatchingQuery = new ArrayList<BlogEntry>(5);
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            if ((entry.getTitle() == null || entry.getTitle().toLowerCase().indexOf(query) == -1) && (entry.getDescription() == null || entry.getDescription().toLowerCase().indexOf(query) == -1)) continue;
            entriesMatchingQuery.add(entry);
        }
        if (entriesMatchingQuery.size() == 0) {
            return new BlogEntry[0];
        }
        return entriesMatchingQuery.toArray(new BlogEntry[entriesMatchingQuery.size()]);
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

