/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.referer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.referer.BlogReferer;
import org.blojsom.plugin.referer.BlogRefererGroup;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class RefererLogPlugin
implements BlojsomPlugin {
    private static final String HEADER_REFERER = "referer";
    private static final String REFERER_CONFIG_IP = "plugin-referer";
    private static final String REFERER_LOG_HEADER = "blojsom referer log";
    private static final int FIELD_FLAVOR = 0;
    private static final int FIELD_DATE = 1;
    private static final int FIELD_COUNT = 2;
    private static final String HITCOUNTER_KEY = ".hitcounter";
    private static final String COMMENTED_LINE = "#";
    private static final int REFERER_MAX_LENGTH_DEFAULT = 40;
    private static final String REFERER_LOG_FILE_IP = "referer-filename";
    private static final String REFERER_MAX_LENGTH_IP = "referer-display-size";
    private static final String REFERER_HIT_COUNTS_IP = "hit-count-flavors";
    public static final String REFERER_DATE_FORMAT = "yyyy-MM-dd";
    public static final String REFERER_CONTEXT_NAME = "REFERER_HISTORY";
    public static final String REFERER_CONTEXT_MAX_LENGTH = "REFERER_MAX_LENGTH";
    private Log _logger = LogFactory.getLog((Class)RefererLogPlugin.class);
    private Map _refererUsers;

    private List populateBlacklistPatterns(ServletConfig servletConfig, String blacklistFile) {
        ArrayList<Pattern> blacklistPatterns = new ArrayList<Pattern>(5);
        InputStream is = servletConfig.getServletContext().getResourceAsStream(blacklistFile);
        if (is != null) {
            try {
                this._logger.info((Object)("Processing blacklist filter [" + blacklistFile + "]"));
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String regexp = null;
                while ((regexp = br.readLine()) != null) {
                    if (regexp.startsWith(COMMENTED_LINE) || "".equals(regexp)) continue;
                    blacklistPatterns.add(Pattern.compile(regexp));
                }
                br.close();
            }
            catch (IOException e) {
                this._logger.error((Object)e);
            }
        }
        return blacklistPatterns;
    }

    private boolean isBlacklisted(List blacklistPatterns, String referer) {
        boolean result = false;
        if (blacklistPatterns != null) {
            int count = blacklistPatterns.size();
            if (referer != null && count > 0) {
                for (int x = 0; x < count && !(result = ((Pattern)blacklistPatterns.get(x)).matcher(referer).find()); ++x) {
                }
            }
        }
        return result;
    }

    private void loadRefererLog(String refererlog, List blacklistPatterns, Map refererGroups, List hitCountFlavors) {
        File _refererfile = new File(refererlog);
        if (_refererfile.exists()) {
            BlojsomProperties _refererproperties = new BlojsomProperties();
            try {
                FileInputStream is = new FileInputStream(_refererfile);
                _refererproperties.load(is);
                ((InputStream)is).close();
                Enumeration<Object> _refererenum = _refererproperties.keys();
                while (_refererenum.hasMoreElements()) {
                    String _key = (String)_refererenum.nextElement();
                    String[] _details = BlojsomUtils.parseDelimitedList((String)_key, (String)".");
                    String _flavor = _details[0];
                    String _url = (String)_refererproperties.get(_key);
                    if (this.isBlacklisted(blacklistPatterns, _url)) continue;
                    BlogRefererGroup _group = refererGroups.containsKey(_flavor) ? (BlogRefererGroup)refererGroups.get(_flavor) : new BlogRefererGroup(hitCountFlavors.contains(_flavor));
                    if (hitCountFlavors.contains(_flavor)) {
                        _group.addHitCount(RefererLogPlugin.getDateFromReferer(_details[1]), Integer.parseInt(_details[2]));
                    } else {
                        _group.addReferer(_flavor, _url, RefererLogPlugin.getDateFromReferer(_details[1]), Integer.parseInt(_details[2]));
                    }
                    refererGroups.put(_flavor, _group);
                }
            }
            catch (IOException e) {
                this._logger.error((Object)e);
            }
        }
    }

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        String refererConfiguration = servletConfig.getInitParameter(REFERER_CONFIG_IP);
        if (BlojsomUtils.checkNullOrBlank((String)refererConfiguration)) {
            throw new BlojsomPluginException("No value given for: plugin-referer configuration parameter");
        }
        String[] users = blojsomConfiguration.getBlojsomUsers();
        this._refererUsers = new HashMap(users.length);
        for (int i = 0; i < users.length; ++i) {
            String user = users[i];
            BlojsomProperties refererProperties = new BlojsomProperties();
            String configurationFile = blojsomConfiguration.getBaseConfigurationDirectory() + user + '/' + refererConfiguration;
            InputStream is = servletConfig.getServletContext().getResourceAsStream(configurationFile);
            if (is == null) {
                this._logger.info((Object)("No referer log configuration file found: " + configurationFile));
                continue;
            }
            try {
                refererProperties.load(is);
                is.close();
                int refererMaxLength = 40;
                ArrayList<String> hitCountFlavors = new ArrayList<String>();
                try {
                    String hitcounters;
                    BlogUser blog = blojsomConfiguration.loadBlog(user);
                    String blogUrlFilter = blog.getBlog().getBlogURL();
                    String maxlength = refererProperties.getProperty(REFERER_MAX_LENGTH_IP);
                    if (maxlength != null) {
                        try {
                            refererMaxLength = Integer.parseInt(maxlength);
                        }
                        catch (NumberFormatException e) {
                            refererMaxLength = 40;
                        }
                    }
                    if ((hitcounters = refererProperties.getProperty(REFERER_HIT_COUNTS_IP)) != null) {
                        String[] _hitflavors = BlojsomUtils.parseCommaList((String)hitcounters);
                        for (int x = 0; x < _hitflavors.length; ++x) {
                            hitCountFlavors.add(_hitflavors[x]);
                        }
                        this._logger.info((Object)("Hit count flavors = " + hitCountFlavors.size()));
                    }
                    String refererLog = refererProperties.getProperty(REFERER_LOG_FILE_IP);
                    String blacklistFilename = refererProperties.getProperty("blog-blacklist-file");
                    List blacklist = new ArrayList();
                    if (BlojsomUtils.checkNullOrBlank((String)blacklistFilename)) {
                        this._logger.error((Object)("No value given for: blog-blacklist-file configuration parameter for user: " + user));
                    } else {
                        blacklistFilename = blojsomConfiguration.getBaseConfigurationDirectory() + user + '/' + blacklistFilename;
                        blacklist = this.populateBlacklistPatterns(servletConfig, blacklistFilename);
                    }
                    HashMap refererGroups = new HashMap(5);
                    this.loadRefererLog(refererLog, blacklist, refererGroups, hitCountFlavors);
                    RefererLogConfiguration refererLogConfiguration = new RefererLogConfiguration(blacklist, refererLog, blogUrlFilter, refererGroups, hitCountFlavors, refererMaxLength);
                    this._refererUsers.put(user, refererLogConfiguration);
                }
                catch (BlojsomException e) {
                    this._logger.error((Object)e);
                }
                continue;
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                throw new BlojsomPluginException((Throwable)e);
            }
        }
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String referer = httpServletRequest.getHeader(HEADER_REFERER);
        String flavor = httpServletRequest.getParameter("flavor");
        String userId = user.getId();
        RefererLogConfiguration refererLogConfiguration = (RefererLogConfiguration)this._refererUsers.get(userId);
        if (refererLogConfiguration == null) {
            return entries;
        }
        List hitCountFlavors = refererLogConfiguration.getHitCountFlavors();
        Map refererGroups = refererLogConfiguration.getRefererGroups();
        if (!this.isBlacklisted(refererLogConfiguration.getBlacklistPatterns(), referer)) {
            if (flavor == null) {
                flavor = "html";
            }
            if (hitCountFlavors.contains(flavor)) {
                this._logger.debug((Object)("[HitCounter] flavor=" + flavor + " - referer=" + referer));
                BlogRefererGroup group = refererGroups.containsKey(flavor) ? (BlogRefererGroup)refererGroups.get(flavor) : new BlogRefererGroup(true);
                group.addHitCount(new Date(), 1);
                refererGroups.put(flavor, group);
            } else if (referer != null && !referer.startsWith(refererLogConfiguration.getBlogUrlFilter())) {
                this._logger.debug((Object)("[Referer] flavor=" + flavor + " - referer=" + referer));
                BlogRefererGroup group = refererGroups.containsKey(flavor) ? (BlogRefererGroup)refererGroups.get(flavor) : new BlogRefererGroup(hitCountFlavors.contains(flavor));
                group.addReferer(flavor, referer, new Date());
                refererGroups.put(flavor, group);
            }
        }
        context.put(REFERER_CONTEXT_NAME, refererGroups);
        context.put(REFERER_CONTEXT_MAX_LENGTH, new Integer(refererLogConfiguration.getRefererMaxLength()));
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
        Iterator refererUserIterator = this._refererUsers.keySet().iterator();
        while (refererUserIterator.hasNext()) {
            String user = (String)refererUserIterator.next();
            RefererLogConfiguration refererLogConfiguration = (RefererLogConfiguration)this._refererUsers.get(user);
            Map refererGroups = refererLogConfiguration.getRefererGroups();
            String refererlog = refererLogConfiguration.getRefererLog();
            BlojsomProperties refererProperties = new BlojsomProperties();
            Iterator groupiterator = refererGroups.keySet().iterator();
            while (groupiterator.hasNext()) {
                String groupflavor = (String)groupiterator.next();
                BlogRefererGroup group = (BlogRefererGroup)refererGroups.get(groupflavor);
                if (group.isHitCounter()) {
                    refererProperties.put(groupflavor + "." + RefererLogPlugin.getRefererDate(group.getLastReferralDate()) + "." + group.getReferralCount(), HITCOUNTER_KEY);
                    continue;
                }
                Iterator flavoriterator = group.keySet().iterator();
                while (flavoriterator.hasNext()) {
                    String flavorkey = (String)flavoriterator.next();
                    BlogReferer referer = (BlogReferer)group.get(flavorkey);
                    refererProperties.put(groupflavor + "." + RefererLogPlugin.getRefererDate(referer.getLastReferral()) + "." + referer.getCount(), referer.getUrl());
                }
            }
            try {
                FileOutputStream fos = new FileOutputStream(refererlog, false);
                refererProperties.store(fos, REFERER_LOG_HEADER);
                fos.close();
            }
            catch (IOException e) {
                this._logger.error((Object)e);
            }
        }
    }

    private static Date getDateFromReferer(String rfcdate) {
        Date result = null;
        SimpleDateFormat sdf = new SimpleDateFormat(REFERER_DATE_FORMAT);
        try {
            result = sdf.parse(rfcdate);
        }
        catch (ParseException e) {
            result = new Date();
        }
        return result;
    }

    public static String getRefererDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(REFERER_DATE_FORMAT);
        return sdf.format(date);
    }

    private static class RefererLogConfiguration {
        private List _blacklistPatterns;
        private String _refererLog = null;
        private String _blogUrlFilter = null;
        private Map _refererGroups;
        private List _hitCountFlavors;
        private int _refererMaxLength = 40;

        public RefererLogConfiguration(List blacklistPatterns, String refererLog, String blogUrlFilter, Map refererGroups, List hitCountFlavors, int refererMaxLength) {
            this._blacklistPatterns = blacklistPatterns;
            this._refererLog = refererLog;
            this._blogUrlFilter = blogUrlFilter;
            this._refererGroups = refererGroups;
            this._hitCountFlavors = hitCountFlavors;
            this._refererMaxLength = refererMaxLength;
        }

        public List getBlacklistPatterns() {
            return this._blacklistPatterns;
        }

        public String getRefererLog() {
            return this._refererLog;
        }

        public String getBlogUrlFilter() {
            return this._blogUrlFilter;
        }

        public Map getRefererGroups() {
            return this._refererGroups;
        }

        public List getHitCountFlavors() {
            return this._hitCountFlavors;
        }

        public int getRefererMaxLength() {
            return this._refererMaxLength;
        }
    }
}

