/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.referer;

import java.util.Date;
import org.blojsom.plugin.referer.RefererLogPlugin;

public class BlogReferer {
    private String _url;
    private String _flavor;
    private Date _lastreferal;
    private int _count;
    private boolean _istoday = false;

    public BlogReferer(String flavor, String url, Date date, int count) {
        this._url = url;
        this._lastreferal = date;
        this._count = count;
        this._flavor = flavor;
        this._istoday = this.determineToday();
    }

    public String getFlavor() {
        return this._flavor;
    }

    public void setFlavor(String flavor) {
        this._flavor = flavor;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public Date getLastReferral() {
        return this._lastreferal;
    }

    public boolean isToday() {
        return this._istoday;
    }

    public void setLastReferral(Date lastreferal) {
        if (lastreferal.compareTo(this._lastreferal) < 0) {
            this._lastreferal = lastreferal;
            this._istoday = this.determineToday();
        }
    }

    public int getCount() {
        return this._count;
    }

    public void increment() {
        ++this._count;
    }

    public void setCount(int count) {
        this._count = count;
    }

    private boolean determineToday() {
        return RefererLogPlugin.getRefererDate(new Date()).equals(RefererLogPlugin.getRefererDate(this._lastreferal));
    }
}

