/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.pingback;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.XmlRpcClient;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomListener;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.event.AddBlogEntryEvent;
import org.blojsom.plugin.admin.event.BlogEntryEvent;
import org.blojsom.plugin.admin.event.UpdatedBlogEntryEvent;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class PingbackPlugin
implements BlojsomPlugin,
BlojsomListener,
BlojsomConstants {
    private static Log _logger = LogFactory.getLog((Class)PingbackPlugin.class);
    private static final String PINGBACK_METHOD = "pingback.ping";
    private static final String X_PINGBACK_HEADER = "X-Pingback";
    private static final String PINGBACK_LINK_REGEX = "<link rel=\"pingback\" href=\"([^\"]+)\" ?/?>";
    private static final String HREF_REGEX = "href\\s*=\\s*\"(.*?)\"";
    public static final String PINGBACK_PLUGIN_METADATA_SEND_PINGBACKS = "send-pingbacks";
    private PingbackPluginAsyncCallback _callbackHandler;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._callbackHandler = new PingbackPluginAsyncCallback();
        blojsomConfiguration.getEventBroadcaster().addListener((BlojsomListener)this);
        _logger.debug((Object)"Initialized pingback plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public void handleEvent(BlojsomEvent event) {
        if (event instanceof AddBlogEntryEvent || event instanceof UpdatedBlogEntryEvent) {
            BlogEntryEvent blogEntryEvent = (BlogEntryEvent)event;
            String text = blogEntryEvent.getBlogEntry().getDescription();
            if (!BlojsomUtils.checkNullOrBlank((String)text) && BlojsomUtils.checkMapForKey((Map)blogEntryEvent.getBlogEntry().getMetaData(), (String)PINGBACK_PLUGIN_METADATA_SEND_PINGBACKS)) {
                String pingbackURL = null;
                String sourceURI = blogEntryEvent.getBlogEntry().getLink();
                String targetURI = null;
                Pattern hrefPattern = Pattern.compile(HREF_REGEX, 106);
                Matcher hrefMatcher = hrefPattern.matcher(text);
                _logger.debug((Object)("Checking for href's in entry: " + blogEntryEvent.getBlogEntry().getPermalink()));
                while (hrefMatcher.find()) {
                    targetURI = hrefMatcher.group(1);
                    _logger.debug((Object)("Found potential targetURI: " + targetURI));
                    try {
                        HttpURLConnection urlConnection = (HttpURLConnection)new URL(targetURI).openConnection();
                        urlConnection.setRequestMethod("GET");
                        urlConnection.connect();
                        pingbackURL = urlConnection.getHeaderField(X_PINGBACK_HEADER);
                        if (pingbackURL == null) {
                            String input;
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
                            StringBuffer content = new StringBuffer();
                            while ((input = bufferedReader.readLine()) != null) {
                                content.append(input).append(LINE_SEPARATOR);
                            }
                            bufferedReader.close();
                            Pattern pingbackLinkPattern = Pattern.compile(PINGBACK_LINK_REGEX, 106);
                            Matcher pingbackLinkMatcher = pingbackLinkPattern.matcher(content.toString());
                            if (pingbackLinkMatcher.find()) {
                                pingbackURL = pingbackLinkMatcher.group(1);
                            }
                        }
                        if (pingbackURL == null || targetURI == null) continue;
                        Vector<String> parameters = new Vector<String>();
                        parameters.add(sourceURI);
                        parameters.add(targetURI);
                        try {
                            _logger.debug((Object)("Sending pingback to: " + pingbackURL + " sourceURI: " + sourceURI + " targetURI: " + targetURI));
                            XmlRpcClient xmlRpcClient = new XmlRpcClient(pingbackURL);
                            xmlRpcClient.executeAsync(PINGBACK_METHOD, parameters, (AsyncCallback)this._callbackHandler);
                        }
                        catch (MalformedURLException e) {
                            _logger.error((Object)e);
                        }
                    }
                    catch (IOException e) {
                        _logger.error((Object)e);
                    }
                }
            } else {
                _logger.debug((Object)"No text in blog entry or send-pingbacks not enabled.");
            }
        }
    }

    public void processEvent(BlojsomEvent event) {
    }

    private class PingbackPluginAsyncCallback
    implements AsyncCallback {
        public void handleResult(Object o, URL url, String s) {
            _logger.debug((Object)o.toString());
        }

        public void handleError(Exception e, URL url, String s) {
            _logger.error((Object)e);
        }
    }
}

