/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.permission;

import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.authorization.AuthorizationProvider;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.blog.BlojsomConfigurationException;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.permission.PermissionChecker;

public class PermissionCheckPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)PermissionCheckPlugin.class);
    public static final String BLOJSOM_PERMISSION_CHECKER = "BLOJSOM_PERMISSION_CHECKER";
    private AuthorizationProvider _authorizationProvider;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        try {
            Class<?> authorizationProviderClass = Class.forName(blojsomConfiguration.getAuthorizationProvider());
            this._authorizationProvider = (AuthorizationProvider)authorizationProviderClass.newInstance();
            this._authorizationProvider.init(servletConfig, blojsomConfiguration);
        }
        catch (ClassNotFoundException e) {
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (BlojsomConfigurationException e) {
            throw new BlojsomPluginException((Throwable)e);
        }
        this._logger.debug((Object)"Initialized Permission Check plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        PermissionChecker permissionChecker = new PermissionChecker(user, this._authorizationProvider, context);
        context.put(BLOJSOM_PERMISSION_CHECKER, permissionChecker);
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

