/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.nofollow;

import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogComment;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.blog.Trackback;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomUtils;

public class NoFollowPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)NoFollowPlugin.class);
    private static final String HYPERLINK_REGEX = "<a\\s([^>]*\\s*href\\s*=[^>]*)>";
    private static final String ATTRIBUTE_REGEX = "[^=[\\p{Space}]]*\\s*=\\s*\"[^\"]*\"|[^=[\\p{Space}]]*\\s*=\\s*'[^']*'|[^=[\\p{Space}]]*\\s*=[^[\\p{Space}]]*";
    private static final String NOFOLLOW_REGEX = "\\s*nofollow\\s*";
    private static final String REL_ATTR_REGEX = "rel\\s*=";
    private static final String REL_NOFOLLOW = " rel=\"nofollow\"";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._logger.debug((Object)"Initialized nofollow plugin");
    }

    protected String noFollowFy(String text) {
        if (BlojsomUtils.checkNullOrBlank((String)text)) {
            return text;
        }
        StringBuffer updatedText = new StringBuffer();
        Pattern hyperlinkPattern = Pattern.compile(HYPERLINK_REGEX, 106);
        Matcher hyperlinkMatcher = hyperlinkPattern.matcher(text);
        Pattern attributePattern = Pattern.compile(ATTRIBUTE_REGEX, 106);
        Pattern relAttrPattern = Pattern.compile(REL_ATTR_REGEX, 106);
        Pattern noFollow = Pattern.compile(NOFOLLOW_REGEX, 106);
        int lastIndex = 0;
        while (hyperlinkMatcher.find()) {
            updatedText.append(text.substring(lastIndex, hyperlinkMatcher.start()));
            String link = hyperlinkMatcher.group();
            Matcher attributeMatcher = attributePattern.matcher(link);
            StringBuffer updatedLink = new StringBuffer();
            boolean shouldAddAttr = true;
            while (attributeMatcher.find()) {
                String attr = attributeMatcher.group();
                Matcher relAttrMatcher = relAttrPattern.matcher(attr);
                while (relAttrMatcher.find()) {
                    int indexOfQuote;
                    Matcher noFollowMatcher = noFollow.matcher(attr);
                    if (noFollowMatcher.matches() || (indexOfQuote = attr.lastIndexOf("\"")) == -1) continue;
                    attr = attr.substring(0, indexOfQuote) + " nofollow\"";
                    shouldAddAttr = false;
                }
                updatedLink.append(attr);
            }
            if (shouldAddAttr) {
                updatedLink.append(REL_NOFOLLOW);
            }
            updatedLink.append(">");
            updatedText.append(updatedLink);
            lastIndex = hyperlinkMatcher.end();
        }
        updatedText.append(text.substring(lastIndex));
        return updatedText.toString();
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            Iterator commentsIterator = entry.getComments().iterator();
            while (commentsIterator.hasNext()) {
                BlogComment blogComment = (BlogComment)commentsIterator.next();
                String commentText = blogComment.getComment();
                commentText = this.noFollowFy(commentText);
                blogComment.setComment(commentText);
            }
            Iterator trackbacksIterator = entry.getTrackbacks().iterator();
            while (trackbacksIterator.hasNext()) {
                Trackback trackback = (Trackback)trackbacksIterator.next();
                String trackbackText = trackback.getExcerpt();
                trackbackText = this.noFollowFy(trackbackText);
                trackback.setExcerpt(trackbackText);
            }
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

