/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.moderation.admin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.WebAdminPlugin;
import org.blojsom.util.BlojsomUtils;

public class SpamPhraseModerationAdminPlugin
extends WebAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)SpamPhraseModerationAdminPlugin.class);
    private static final String SPAM_PHRASE_BLACKLIST_IP = "spam-phrase-blacklist";
    private static final String DEFAULT_SPAM_PHRASE_BLACKLIST_FILE = "spam-phrase-blacklist.properties";
    private String _spamPhraseBlacklist = "spam-phrase-blacklist.properties";
    private static final String FAILED_SPAM_PHRASE_PERMISSION_KEY = "failed.spam.phrase.permission.text";
    private static final String ADDED_SPAM_PHRASE_KEY = "added.spam.phrase.text";
    private static final String SPAM_PHRASE_ALREADY_ADDED_KEY = "spam.phrase.already.added.text";
    private static final String DELETED_SPAM_PHRASE_KEY = "deleted.spam.phrase.text";
    private static final String NO_SPAM_PHRASES_TO_DELETE_KEY = "no.spam.phrases.to.delete.text";
    private static final String BLOJSOM_PLUGIN_SPAM_PHRASES = "BLOJSOM_PLUGIN_SPAM_PHRASES";
    private static final String EDIT_SPAM_PHRASE_MODERATION_SETTINGS_PAGE = "/org/blojsom/plugin/moderation/admin/templates/admin-edit-spam-phrase-moderation-settings";
    private static final String SPAM_PHRASE = "spam-phrase";
    private static final String ADD_SPAM_PHRASE_ACTION = "add-spam-phrase";
    private static final String DELETE_SPAM_PHRASE_ACTION = "delete-spam-phrase";
    private static final String SPAM_PHRASE_MODERATION_PERMISSION = "spam_phrase_moderation";

    public String getDisplayName() {
        return "Spam Phrase Moderation plugin";
    }

    public String getInitialPage() {
        return EDIT_SPAM_PHRASE_MODERATION_SETTINGS_PAGE;
    }

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        String spamPhraseBlacklist = servletConfig.getInitParameter(SPAM_PHRASE_BLACKLIST_IP);
        if (!BlojsomUtils.checkNullOrBlank((String)spamPhraseBlacklist)) {
            this._spamPhraseBlacklist = spamPhraseBlacklist;
        }
        this._logger.debug((Object)"Initialized spam phrase blacklist administration plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        entries = super.process(httpServletRequest, httpServletResponse, user, context, entries);
        String page = BlojsomUtils.getRequestValue((String)"page", (HttpServletRequest)httpServletRequest);
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, SPAM_PHRASE_MODERATION_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_SPAM_PHRASE_PERMISSION_KEY, FAILED_SPAM_PHRASE_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        if ("/org/blojsom/plugin/admin/templates/admin-login".equals(page)) {
            return entries;
        }
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        List spamPhrases = this.loadSpamPhrases(user);
        String spamPhrase = BlojsomUtils.getRequestValue((String)SPAM_PHRASE, (HttpServletRequest)httpServletRequest);
        if (ADD_SPAM_PHRASE_ACTION.equals(action)) {
            if (!spamPhrases.contains(spamPhrase)) {
                spamPhrases.add(spamPhrase);
                this.writeSpamPhrases(user, spamPhrases);
                this.addOperationResultMessage(context, this.formatAdminResource(ADDED_SPAM_PHRASE_KEY, ADDED_SPAM_PHRASE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{spamPhrase}));
            } else {
                this.addOperationResultMessage(context, this.formatAdminResource(SPAM_PHRASE_ALREADY_ADDED_KEY, SPAM_PHRASE_ALREADY_ADDED_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{spamPhrase}));
            }
        } else if (DELETE_SPAM_PHRASE_ACTION.equals(action)) {
            String[] spamPhrasesToDelete = httpServletRequest.getParameterValues(SPAM_PHRASE);
            if (spamPhrasesToDelete != null && spamPhrasesToDelete.length > 0) {
                for (int i = 0; i < spamPhrasesToDelete.length; ++i) {
                    spamPhrases.set(Integer.parseInt(spamPhrasesToDelete[i]), null);
                }
                spamPhrases = BlojsomUtils.removeNullValues((List)spamPhrases);
                this.writeSpamPhrases(user, spamPhrases);
                this.addOperationResultMessage(context, this.formatAdminResource(DELETED_SPAM_PHRASE_KEY, DELETED_SPAM_PHRASE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{new Integer(spamPhrasesToDelete.length)}));
            } else {
                this.addOperationResultMessage(context, this.getAdminResource(NO_SPAM_PHRASES_TO_DELETE_KEY, NO_SPAM_PHRASES_TO_DELETE_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
        }
        context.put(BLOJSOM_PLUGIN_SPAM_PHRASES, spamPhrases);
        return entries;
    }

    protected List loadSpamPhrases(BlogUser blogUser) {
        File blacklistFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + "/" + blogUser.getId() + "/" + this._spamPhraseBlacklist);
        ArrayList<String> spamPhrases = new ArrayList<String>(25);
        if (blacklistFile.exists()) {
            try {
                String phrase;
                FileInputStream fis = new FileInputStream(blacklistFile);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                while ((phrase = br.readLine()) != null) {
                    spamPhrases.add(phrase);
                }
                br.close();
            }
            catch (IOException e) {
                this._logger.error((Object)e);
            }
        }
        return spamPhrases;
    }

    protected void writeSpamPhrases(BlogUser blogUser, List spamPhrases) {
        File blacklistFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + "/" + blogUser.getId() + "/" + this._spamPhraseBlacklist);
        try {
            FileOutputStream fos = new FileOutputStream(blacklistFile);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            Iterator phrasesIterator = spamPhrases.iterator();
            while (phrasesIterator.hasNext()) {
                String phrase = (String)phrasesIterator.next();
                bw.write(phrase);
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            this._logger.error((Object)e);
        }
    }
}

