/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.moderation.admin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.WebAdminPlugin;
import org.blojsom.util.BlojsomUtils;

public class IPAddressModerationAdminPlugin
extends WebAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)IPAddressModerationAdminPlugin.class);
    private static final String BLACKLIST = "blacklist";
    private static final String IP_BLACKLIST_IP = "ip-blacklist";
    private static final String IP_WHITELIST_IP = "ip-whitelist";
    private static final String DEFAULT_IP_BLACKLIST_FILE = "ip-blacklist.properties";
    private static final String DEFAULT_IP_WHITELIST_FILE = "ip-whitelist.properties";
    private String _ipBlacklist = "ip-blacklist.properties";
    private String _ipWhitelist = "ip-whitelist.properties";
    private static final String FAILED_IP_ADDRESS_MODERATION_PERMISSION_KEY = "failed.ip.address.moderation.permission.text";
    private static final String ADDED_IP_TO_BLACKLIST_KEY = "added.ip.to.blacklist.text";
    private static final String IP_ALREADY_ADDED_TO_BLACKLIST_KEY = "ip.already.added.to.blacklist.text";
    private static final String ADDED_IP_TO_WHITELIST_KEY = "added.ip.to.whitelist.text";
    private static final String IP_ALREADY_ADDED_TO_WHITELIST_KEY = "ip.already.added.to.whitelist.text";
    private static final String DELETED_IP_ADDRESSES_BLACKLIST_KEY = "deleted.ip.addresses.blacklist.text";
    private static final String DELETED_IP_ADDRESSES_WHITELIST_KEY = "deleted.ip.addresses.whitelist.text";
    private static final String NO_IP_ADDRESSES_SELECTED_KEY = "no.ip.addresses.selected.text";
    private static final String BLOJSOM_PLUGIN_IP_WHITELIST = "BLOJSOM_PLUGIN_IP_WHITELIST";
    private static final String BLOJSOM_PLUGIN_IP_BLACKLIST = "BLOJSOM_PLUGIN_IP_BLACKLIST";
    private static final String EDIT_IP_MODERATION_SETTINGS_PAGE = "/org/blojsom/plugin/moderation/admin/templates/admin-edit-ip-moderation-settings";
    private static final String IP_ADDRESS = "ip-address";
    private static final String LIST_TYPE = "list-type";
    private static final String ADD_IP_ADDRESS_ACTION = "add-ip-address";
    private static final String DELETE_IP_ADDRESS_ACTION = "delete-ip-address";
    private static final String IP_MODERATION_PERMISSION = "ip_moderation";

    public String getDisplayName() {
        return "IP Address Moderation plugin";
    }

    public String getInitialPage() {
        return EDIT_IP_MODERATION_SETTINGS_PAGE;
    }

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        String ipWhitelist;
        super.init(servletConfig, blojsomConfiguration);
        String ipBlacklist = servletConfig.getInitParameter(IP_BLACKLIST_IP);
        if (!BlojsomUtils.checkNullOrBlank((String)ipBlacklist)) {
            this._ipBlacklist = ipBlacklist;
        }
        if (!BlojsomUtils.checkNullOrBlank((String)(ipWhitelist = servletConfig.getInitParameter(IP_WHITELIST_IP)))) {
            this._ipWhitelist = ipWhitelist;
        }
        this._logger.debug((Object)"Initialized IP address blacklist/whitelist moderation plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        entries = super.process(httpServletRequest, httpServletResponse, user, context, entries);
        String page = BlojsomUtils.getRequestValue((String)"page", (HttpServletRequest)httpServletRequest);
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, IP_MODERATION_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_IP_ADDRESS_MODERATION_PERMISSION_KEY, FAILED_IP_ADDRESS_MODERATION_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        if ("/org/blojsom/plugin/admin/templates/admin-login".equals(page)) {
            return entries;
        }
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        List ipAddressesFromBlacklist = this.loadIPList(user, this._ipBlacklist);
        List ipAddressesFromWhitelist = this.loadIPList(user, this._ipWhitelist);
        String listType = BlojsomUtils.getRequestValue((String)LIST_TYPE, (HttpServletRequest)httpServletRequest);
        if (ADD_IP_ADDRESS_ACTION.equals(action)) {
            String ipAddress = BlojsomUtils.getRequestValue((String)IP_ADDRESS, (HttpServletRequest)httpServletRequest);
            if (BLACKLIST.equals(listType)) {
                if (!ipAddressesFromBlacklist.contains(ipAddress)) {
                    ipAddressesFromBlacklist.add(ipAddress);
                    this.writeIPList(user, ipAddressesFromBlacklist, this._ipBlacklist);
                    this.addOperationResultMessage(context, this.formatAdminResource(ADDED_IP_TO_BLACKLIST_KEY, ADDED_IP_TO_BLACKLIST_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{ipAddress}));
                } else {
                    this.addOperationResultMessage(context, this.formatAdminResource(IP_ALREADY_ADDED_TO_BLACKLIST_KEY, IP_ALREADY_ADDED_TO_BLACKLIST_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{ipAddress}));
                }
            } else if (!ipAddressesFromWhitelist.contains(ipAddress)) {
                ipAddressesFromWhitelist.add(ipAddress);
                this.writeIPList(user, ipAddressesFromWhitelist, this._ipWhitelist);
                this.addOperationResultMessage(context, this.formatAdminResource(ADDED_IP_TO_WHITELIST_KEY, ADDED_IP_TO_WHITELIST_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{ipAddress}));
            } else {
                this.addOperationResultMessage(context, this.formatAdminResource(IP_ALREADY_ADDED_TO_WHITELIST_KEY, IP_ALREADY_ADDED_TO_WHITELIST_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{ipAddress}));
            }
        } else if (DELETE_IP_ADDRESS_ACTION.equals(action)) {
            String[] ipAddressesToDelete = httpServletRequest.getParameterValues(IP_ADDRESS);
            if (ipAddressesToDelete != null && ipAddressesToDelete.length > 0) {
                if (BLACKLIST.equals(listType)) {
                    for (int i = 0; i < ipAddressesToDelete.length; ++i) {
                        ipAddressesFromBlacklist.set(Integer.parseInt(ipAddressesToDelete[i]), null);
                    }
                    ipAddressesFromBlacklist = BlojsomUtils.removeNullValues((List)ipAddressesFromBlacklist);
                    this.writeIPList(user, ipAddressesFromBlacklist, this._ipBlacklist);
                    this.addOperationResultMessage(context, this.formatAdminResource(DELETED_IP_ADDRESSES_BLACKLIST_KEY, DELETED_IP_ADDRESSES_BLACKLIST_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{new Integer(ipAddressesToDelete.length)}));
                } else {
                    for (int i = 0; i < ipAddressesToDelete.length; ++i) {
                        ipAddressesFromWhitelist.set(Integer.parseInt(ipAddressesToDelete[i]), null);
                    }
                    ipAddressesFromWhitelist = BlojsomUtils.removeNullValues((List)ipAddressesFromWhitelist);
                    this.writeIPList(user, ipAddressesFromWhitelist, this._ipWhitelist);
                    this.addOperationResultMessage(context, this.formatAdminResource(DELETED_IP_ADDRESSES_WHITELIST_KEY, DELETED_IP_ADDRESSES_WHITELIST_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{new Integer(ipAddressesToDelete.length)}));
                }
            } else {
                this.addOperationResultMessage(context, this.getAdminResource(NO_IP_ADDRESSES_SELECTED_KEY, NO_IP_ADDRESSES_SELECTED_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
        }
        context.put(BLOJSOM_PLUGIN_IP_BLACKLIST, ipAddressesFromBlacklist);
        context.put(BLOJSOM_PLUGIN_IP_WHITELIST, ipAddressesFromWhitelist);
        return entries;
    }

    protected List loadIPList(BlogUser blogUser, String filename) {
        File ipAddressFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + "/" + blogUser.getId() + "/" + filename);
        ArrayList<String> ipAddresses = new ArrayList<String>(25);
        if (ipAddressFile.exists()) {
            try {
                String ipAddress;
                FileInputStream fis = new FileInputStream(ipAddressFile);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                while ((ipAddress = br.readLine()) != null) {
                    ipAddresses.add(ipAddress);
                }
                br.close();
            }
            catch (IOException e) {
                this._logger.error((Object)e);
            }
        }
        return ipAddresses;
    }

    protected void writeIPList(BlogUser blogUser, List ipAddresses, String filename) {
        File ipAddressFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + "/" + blogUser.getId() + "/" + filename);
        try {
            FileOutputStream fos = new FileOutputStream(ipAddressFile);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            Iterator ipIterator = ipAddresses.iterator();
            while (ipIterator.hasNext()) {
                String ipAddress = (String)ipIterator.next();
                bw.write(ipAddress);
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            this._logger.error((Object)e);
        }
    }
}

