/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.moderation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomListener;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.comment.event.CommentResponseSubmissionEvent;
import org.blojsom.plugin.response.event.ResponseSubmissionEvent;
import org.blojsom.plugin.trackback.event.TrackbackResponseSubmissionEvent;
import org.blojsom.util.BlojsomUtils;

public class IPAddressModerationPlugin
implements BlojsomPlugin,
BlojsomListener {
    private Log _logger = LogFactory.getLog((Class)IPAddressModerationPlugin.class);
    private static final String IP_BLACKLIST_IP = "ip-blacklist";
    private static final String IP_WHITELIST_IP = "ip-whitelist";
    private static final String DEFAULT_IP_BLACKLIST_FILE = "ip-blacklist.properties";
    private static final String DEFAULT_IP_WHITELIST_FILE = "ip-whitelist.properties";
    private static final String DELETE_IPSPAM = "delete-ipspam";
    private static final boolean DEFAULT_DELETE_IPSPAM = false;
    private BlojsomConfiguration _blojsomConfiguration;
    private String _ipBlacklist = "ip-blacklist.properties";
    private String _ipWhitelist = "ip-whitelist.properties";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        String ipWhitelist;
        blojsomConfiguration.getEventBroadcaster().addListener((BlojsomListener)this);
        this._blojsomConfiguration = blojsomConfiguration;
        String ipBlacklist = servletConfig.getInitParameter(IP_BLACKLIST_IP);
        if (!BlojsomUtils.checkNullOrBlank((String)ipBlacklist)) {
            this._ipBlacklist = ipBlacklist;
        }
        if (!BlojsomUtils.checkNullOrBlank((String)(ipWhitelist = servletConfig.getInitParameter(IP_WHITELIST_IP)))) {
            this._ipWhitelist = ipWhitelist;
        }
        this._logger.debug((Object)"Initialized IP address blacklist/whitelist plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public void handleEvent(BlojsomEvent event) {
    }

    public void processEvent(BlojsomEvent event) {
        block23: {
            if (event instanceof ResponseSubmissionEvent) {
                ResponseSubmissionEvent responseSubmissionEvent = (ResponseSubmissionEvent)event;
                String requestIPAddress = responseSubmissionEvent.getHttpServletRequest().getRemoteAddr();
                if (!BlojsomUtils.checkNullOrBlank((String)requestIPAddress)) {
                    Iterator ipIterator;
                    String ipAddress;
                    ArrayList<String> ipAddresses;
                    BufferedReader br;
                    FileInputStream fis;
                    File blacklistFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + "/" + responseSubmissionEvent.getBlog().getId() + "/" + this._ipBlacklist);
                    File whitelistFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + "/" + responseSubmissionEvent.getBlog().getId() + "/" + this._ipWhitelist);
                    boolean ipInWhitelist = false;
                    if (whitelistFile.exists()) {
                        try {
                            fis = new FileInputStream(whitelistFile);
                            br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                            ipAddresses = new ArrayList<String>(25);
                            while ((ipAddress = br.readLine()) != null) {
                                ipAddresses.add(ipAddress);
                            }
                            br.close();
                            ipIterator = ipAddresses.iterator();
                            while (ipIterator.hasNext()) {
                                ipAddress = (String)ipIterator.next();
                                if (!requestIPAddress.matches(ipAddress) && requestIPAddress.indexOf(ipAddress) == -1) continue;
                                this._logger.debug((Object)("IP address found in whitelist: " + requestIPAddress));
                                ipInWhitelist = true;
                            }
                        }
                        catch (IOException e) {
                            this._logger.error((Object)e);
                        }
                    } else {
                        this._logger.debug((Object)("IP address whitelist not found: " + this._ipWhitelist));
                    }
                    if (blacklistFile.exists() && !ipInWhitelist) {
                        try {
                            fis = new FileInputStream(blacklistFile);
                            br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                            ipAddresses = new ArrayList(25);
                            while ((ipAddress = br.readLine()) != null) {
                                ipAddresses.add(ipAddress);
                            }
                            br.close();
                            ipIterator = ipAddresses.iterator();
                            boolean deleteIPSpam = false;
                            Map metaData = responseSubmissionEvent.getMetaData();
                            String deleteIPSpamValue = responseSubmissionEvent.getBlog().getBlog().getBlogProperty(DELETE_IPSPAM);
                            if (!BlojsomUtils.checkNullOrBlank((String)deleteIPSpamValue)) {
                                deleteIPSpam = Boolean.valueOf(deleteIPSpamValue);
                            }
                            boolean ipSpamFound = false;
                            while (ipIterator.hasNext()) {
                                ipAddress = (String)ipIterator.next();
                                if (!requestIPAddress.matches(ipAddress) && requestIPAddress.indexOf(ipAddress) == -1) continue;
                                this._logger.debug((Object)("IP address found in blacklist: " + requestIPAddress));
                                ipSpamFound = true;
                                break;
                            }
                            if (!ipSpamFound) break block23;
                            if (!deleteIPSpam) {
                                this._logger.debug((Object)"Marking response for moderation");
                            } else {
                                this._logger.debug((Object)"Marking response for automatic deletion");
                            }
                            if (responseSubmissionEvent instanceof CommentResponseSubmissionEvent) {
                                if (!deleteIPSpam) {
                                    metaData.put("BLOJSOM_COMMENT_MODERATION_PLUGIN_APPROVED", Boolean.FALSE.toString());
                                } else {
                                    metaData.put("BLOJSOM_PLUGIN_COMMENT_METADATA_DESTROY", Boolean.TRUE);
                                }
                                break block23;
                            }
                            if (!(responseSubmissionEvent instanceof TrackbackResponseSubmissionEvent)) break block23;
                            if (!deleteIPSpam) {
                                metaData.put("BLOJSOM_TRACKBACK_MODERATION_PLUGIN_APPROVED", Boolean.FALSE.toString());
                                break block23;
                            }
                            metaData.put("BLOJSOM_PLUGIN_TRACKBACK_METADATA_DESTROY", Boolean.TRUE);
                        }
                        catch (IOException e) {
                            this._logger.error((Object)e);
                        }
                    } else {
                        this._logger.debug((Object)("IP address blacklist not found: " + this._ipWhitelist));
                    }
                } else {
                    this._logger.debug((Object)"IP address not available");
                }
            }
        }
    }
}

