/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.moblog;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.moblog.Mailbox;
import org.blojsom.util.BlojsomUtils;

public class MoblogPluginUtils {
    private static Log _logger = LogFactory.getLog((Class)MoblogPluginUtils.class);

    private static Map configureAuthorizedAddresses(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration, String user, String authFile) {
        Map authorizedAddresses = new HashMap();
        if (authFile != null) {
            String authorizationFile = blojsomConfiguration.getBaseConfigurationDirectory() + user + "/" + authFile;
            InputStream ais = servletConfig.getServletContext().getResourceAsStream(authorizationFile);
            if (ais == null) {
                _logger.info((Object)("No moblog-authorization configuration file found: " + authorizationFile));
            } else {
                Properties authorizationProperties = new Properties();
                try {
                    authorizationProperties.load(ais);
                    ais.close();
                    authorizedAddresses = BlojsomUtils.propertiesToMap((Properties)authorizationProperties);
                }
                catch (IOException e) {
                    _logger.error((Object)e);
                }
            }
        }
        return authorizedAddresses;
    }

    public static Mailbox readMailboxSettingsForUser(BlojsomConfiguration blojsomConfiguration, ServletConfig servletConfig, BlogUser blogUser) {
        String moblogConfiguration = servletConfig.getInitParameter("plugin-moblog");
        Mailbox mailbox = new Mailbox();
        mailbox.setEnabled(false);
        String user = blogUser.getId();
        Properties moblogProperties = new Properties();
        String configurationFile = blojsomConfiguration.getBaseConfigurationDirectory() + user + "/" + moblogConfiguration;
        InputStream is = servletConfig.getServletContext().getResourceAsStream(configurationFile);
        if (is == null) {
            _logger.info((Object)("No moblog configuration file found: " + configurationFile));
        } else {
            try {
                moblogProperties.load(is);
                is.close();
                if (moblogProperties.size() > 0) {
                    String secretWord;
                    String textMimeTypes;
                    String attachmentMimeTypes;
                    String[] types;
                    mailbox.setBlogUser(blogUser);
                    String authFile = moblogProperties.getProperty("moblog-authorization", "moblog-authorization.properties");
                    String hostname = moblogProperties.getProperty("moblog-hostname");
                    if (BlojsomUtils.checkNullOrBlank((String)hostname)) {
                        mailbox.setEnabled(false);
                        _logger.info((Object)("Marked moblog mailbox as disabled for user: " + user + ". No " + "moblog-hostname" + " property."));
                        return mailbox;
                    }
                    mailbox.setHostName(hostname);
                    String userid = moblogProperties.getProperty("moblog-userid");
                    if (BlojsomUtils.checkNullOrBlank((String)userid)) {
                        mailbox.setEnabled(false);
                        _logger.info((Object)("Marked moblog mailbox as disabled for user: " + user + ". No " + "moblog-userid" + " property."));
                        return mailbox;
                    }
                    mailbox.setUserId(userid);
                    String password = moblogProperties.getProperty("moblog-password");
                    if (BlojsomUtils.checkNullOrBlank((String)password)) {
                        mailbox.setEnabled(false);
                        _logger.info((Object)("Marked moblog mailbox as disabled for user: " + user + ". No " + "moblog-password" + " property."));
                        return mailbox;
                    }
                    mailbox.setPassword(password);
                    mailbox.setUrlPrefix(BlojsomUtils.removeTrailingSlash((String)blojsomConfiguration.getResourceDirectory()) + "/" + user + "/");
                    String resourceUrl = blojsomConfiguration.getQualifiedResourceDirectory();
                    mailbox.setOutputDirectory(resourceUrl + File.separator + user);
                    String blogCategoryName = moblogProperties.getProperty("moblog-category");
                    blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
                    if (!blogCategoryName.endsWith("/")) {
                        blogCategoryName = blogCategoryName + "/";
                    }
                    mailbox.setCategoryName(blogCategoryName);
                    mailbox.setEntriesDirectory(blogUser.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)blogCategoryName));
                    Boolean enabled = Boolean.valueOf(moblogProperties.getProperty("moblog-enabled", "false"));
                    mailbox.setEnabled(enabled);
                    String imageMimeTypes = moblogProperties.getProperty("moblog-image-mime-types", "image/jpg, image/jpeg, image/gif, image/png");
                    if (!BlojsomUtils.checkNullOrBlank((String)imageMimeTypes)) {
                        types = BlojsomUtils.parseCommaList((String)imageMimeTypes);
                        if (types.length > 0) {
                            HashMap<String, String> imageTypesMap = new HashMap<String, String>();
                            for (int i = 0; i < types.length; ++i) {
                                String type = types[i];
                                imageTypesMap.put(type, type);
                            }
                            mailbox.setImageMimeTypes(imageTypesMap);
                        }
                    } else {
                        mailbox.setImageMimeTypes(new HashMap());
                    }
                    if (!BlojsomUtils.checkNullOrBlank((String)(attachmentMimeTypes = moblogProperties.getProperty("moblog-attachment-mime-types")))) {
                        types = BlojsomUtils.parseCommaList((String)attachmentMimeTypes);
                        if (types.length > 0) {
                            HashMap<String, String> attachmentTypesMap = new HashMap<String, String>();
                            for (int i = 0; i < types.length; ++i) {
                                String type = types[i];
                                attachmentTypesMap.put(type, type);
                            }
                            mailbox.setAttachmentMimeTypes(attachmentTypesMap);
                        }
                    } else {
                        mailbox.setAttachmentMimeTypes(new HashMap());
                    }
                    if (!BlojsomUtils.checkNullOrBlank((String)(textMimeTypes = moblogProperties.getProperty("moblog-text-mime-types", "text/plain, text/html")))) {
                        types = BlojsomUtils.parseCommaList((String)textMimeTypes);
                        if (types.length > 0) {
                            HashMap<String, String> textTypesMap = new HashMap<String, String>();
                            for (int i = 0; i < types.length; ++i) {
                                String type = types[i];
                                textTypesMap.put(type, type);
                            }
                            mailbox.setTextMimeTypes(textTypesMap);
                        }
                    } else {
                        mailbox.setTextMimeTypes(new HashMap());
                    }
                    if (BlojsomUtils.checkNullOrBlank((String)(secretWord = moblogProperties.getProperty("moblog-secret-word")))) {
                        mailbox.setSecretWord(null);
                    } else {
                        mailbox.setSecretWord(secretWord);
                    }
                    mailbox.setAuthorizedAddresses(MoblogPluginUtils.configureAuthorizedAddresses(servletConfig, blojsomConfiguration, user, authFile));
                    String ignoreExpression = moblogProperties.getProperty("moblog-ignore-expression");
                    if (BlojsomUtils.checkNullOrBlank((String)ignoreExpression)) {
                        mailbox.setIgnoreExpression(null);
                    } else {
                        mailbox.setIgnoreExpression(ignoreExpression);
                    }
                }
            }
            catch (IOException e) {
                _logger.error((Object)e);
                return null;
            }
        }
        return mailbox;
    }

    public static int saveFile(String filename, String extension, InputStream input) throws IOException {
        int aByte;
        int count = 0;
        if (filename == null) {
            return count;
        }
        File file = new File(filename + extension);
        int i = 0;
        while (file.exists()) {
            file = new File(filename + i + extension);
            ++i;
        }
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        BufferedInputStream bis = new BufferedInputStream(input);
        while ((aByte = bis.read()) != -1) {
            bos.write(aByte);
            ++count;
        }
        bos.flush();
        bos.close();
        bis.close();
        return count;
    }
}

