/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.macro.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.WebAdminPlugin;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class MacroExpansionAdminPlugin
extends WebAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)MacroExpansionAdminPlugin.class);
    private static final String EDIT_MACRO_EXPANSION_SETTINGS_PAGE = "/org/blojsom/plugin/macro/admin/templates/admin-edit-macro-expansion-settings";
    private static final String BLOJSOM_PLUGIN_EDIT_MACRO_EXPANSION_MACROS = "BLOJSOM_PLUGIN_EDIT_MACRO_EXPANSION_MACROS";
    private static final String FAILED_MACRO_ADMIN_PERMISSION_KEY = "failed.macro.admin.permission.text";
    private static final String MISSING_MACRO_CONFIGURATION_FILE_KEY = "missing.macro.configuration.file.text";
    private static final String DELETED_MACROS_KEY = "deleted.macros.text";
    private static final String NO_MACROS_SELECTED_TO_DELETE_KEY = "no.macros.selected.to.delete.text";
    private static final String MISSING_MACRO_PARAMETERS_KEY = "missing.macro.parameters.text";
    private static final String ADDED_MACRO_KEY = "added.macro.text";
    private static final String MACRO_EXISTS_KEY = "macro.exists.text";
    private static final String MACRO_SHORT_NAME = "macro-short-name";
    private static final String MACRO_EXPANSION = "macro-expansion";
    private static final String MACROS = "macros";
    private static final String ADD_MACRO_ACTION = "add-macro";
    private static final String DELETE_SELECTED_MACROS_ACTION = "delete-selected-macros";
    private static final String MACRO_EXPANSION_ADMIN_PERMISSION = "macro_expansion_admin";

    public String getDisplayName() {
        return "Macro Expansion plugin";
    }

    public String getInitialPage() {
        return EDIT_MACRO_EXPANSION_SETTINGS_PAGE;
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        entries = super.process(httpServletRequest, httpServletResponse, user, context, entries);
        String page = BlojsomUtils.getRequestValue((String)"page", (HttpServletRequest)httpServletRequest);
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, MACRO_EXPANSION_ADMIN_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_MACRO_ADMIN_PERMISSION_KEY, FAILED_MACRO_ADMIN_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        if ("/org/blojsom/plugin/admin/templates/admin-login".equals(page)) {
            return entries;
        }
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        String macroConfiguration = this._servletConfig.getInitParameter("plugin-macros-expansion");
        if (BlojsomUtils.checkNullOrBlank((String)macroConfiguration)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.formatAdminResource(MISSING_MACRO_CONFIGURATION_FILE_KEY, MISSING_MACRO_CONFIGURATION_FILE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{"plugin-macros-expansion"}));
            return entries;
        }
        Map macros = this.readMacros(user.getId(), macroConfiguration);
        if (DELETE_SELECTED_MACROS_ACTION.equals(action)) {
            String[] macrosToDelete = httpServletRequest.getParameterValues(MACROS);
            if (macrosToDelete != null && macrosToDelete.length > 0) {
                for (int i = 0; i < macrosToDelete.length; ++i) {
                    String macro = macrosToDelete[i];
                    macros.remove(macro);
                }
                try {
                    this.writeMacroConfiguration(user.getId(), macroConfiguration, macros);
                }
                catch (IOException e) {
                    this._logger.error((Object)e);
                }
                this.addOperationResultMessage(context, this.formatAdminResource(DELETED_MACROS_KEY, DELETED_MACROS_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{new Integer(macrosToDelete.length)}));
            } else {
                this.addOperationResultMessage(context, this.getAdminResource(NO_MACROS_SELECTED_TO_DELETE_KEY, NO_MACROS_SELECTED_TO_DELETE_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
        } else if (ADD_MACRO_ACTION.equals(action)) {
            String macroShortName = BlojsomUtils.getRequestValue((String)MACRO_SHORT_NAME, (HttpServletRequest)httpServletRequest);
            String macroExpansion = BlojsomUtils.getRequestValue((String)MACRO_EXPANSION, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)macroShortName) || BlojsomUtils.checkNullOrBlank((String)macroExpansion)) {
                this.addOperationResultMessage(context, this.getAdminResource(MISSING_MACRO_PARAMETERS_KEY, MISSING_MACRO_PARAMETERS_KEY, user.getBlog().getBlogAdministrationLocale()));
            } else if (!macros.containsKey(macroShortName)) {
                macros.put(macroShortName, macroExpansion);
                try {
                    this.writeMacroConfiguration(user.getId(), macroConfiguration, macros);
                }
                catch (IOException e) {
                    this._logger.error((Object)e);
                }
                this.addOperationResultMessage(context, this.formatAdminResource(ADDED_MACRO_KEY, ADDED_MACRO_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{macroShortName}));
            } else {
                this.addOperationResultMessage(context, this.formatAdminResource(MACRO_EXISTS_KEY, MACRO_EXISTS_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{macroShortName}));
            }
        }
        this.readMacros(user.getId(), macroConfiguration);
        context.put(BLOJSOM_PLUGIN_EDIT_MACRO_EXPANSION_MACROS, macros);
        return entries;
    }

    private Map readMacros(String userId, String macroConfiguration) throws BlojsomPluginException {
        TreeMap macros = new TreeMap();
        BlojsomProperties macroProperties = new BlojsomProperties();
        String configurationFile = this._blojsomConfiguration.getBaseConfigurationDirectory() + userId + '/' + macroConfiguration;
        InputStream is = this._servletConfig.getServletContext().getResourceAsStream(configurationFile);
        if (is == null) {
            this._logger.info((Object)("No macro configuration file found: " + configurationFile));
        } else {
            try {
                macroProperties.load(is);
                is.close();
                macros = new TreeMap(BlojsomUtils.propertiesToMap((Properties)macroProperties));
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                throw new BlojsomPluginException((Throwable)e);
            }
        }
        return macros;
    }

    private void writeMacroConfiguration(String userId, String macroConfiguration, Map macros) throws IOException {
        File macroConfigurationFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + userId + "/" + macroConfiguration);
        FileOutputStream fos = new FileOutputStream(macroConfigurationFile);
        Properties macroProperties = BlojsomUtils.mapToProperties((Map)macros);
        macroProperties.store(fos, null);
        fos.close();
    }
}

