/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.limiter;

import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;

public class EntriesLimiterPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)EntriesLimiterPlugin.class);
    private static final String ENTRIES_PARAM = "entries";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        Integer _blogDisplayEntries = new Integer(user.getBlog().getBlogDisplayEntries());
        Integer blogDisplayEntries = new Integer(user.getBlog().getBlogDisplayEntries());
        String entriesParam = httpServletRequest.getParameter(ENTRIES_PARAM);
        if (entriesParam != null || !"".equals(entriesParam)) {
            try {
                blogDisplayEntries = new Integer(Integer.parseInt(entriesParam));
                if (blogDisplayEntries <= 0) {
                    blogDisplayEntries = new Integer(-1);
                } else if (blogDisplayEntries > entries.length) {
                    this._logger.debug((Object)("Display entries value out of range: " + blogDisplayEntries));
                    blogDisplayEntries = _blogDisplayEntries;
                }
                this._logger.debug((Object)("Overriding display entries: " + blogDisplayEntries));
            }
            catch (NumberFormatException e) {
                this._logger.debug((Object)("Invalid display entries value or no value supplied. Using: " + blogDisplayEntries));
            }
        }
        if (blogDisplayEntries == -1) {
            return entries;
        }
        if (entries.length <= blogDisplayEntries) {
            return entries;
        }
        BlogEntry[] filteredEntries = new BlogEntry[blogDisplayEntries.intValue()];
        for (int i = 0; i < blogDisplayEntries; ++i) {
            filteredEntries[i] = entries[i];
        }
        return filteredEntries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

