/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.limiter;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogComment;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class ConditionalGetPlugin
implements BlojsomPlugin,
BlojsomConstants {
    private Log _logger = LogFactory.getLog((Class)ConditionalGetPlugin.class);
    private static final String IF_MODIFIED_SINCE_HEADER = "If-Modified-Since";
    private static final String IF_NONE_MATCH_HEADER = "If-None-Match";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        if (entries.length > 0) {
            long ifModifiedSinceHeader = -1L;
            try {
                ifModifiedSinceHeader = httpServletRequest.getDateHeader(IF_MODIFIED_SINCE_HEADER);
            }
            catch (Exception e) {
                ifModifiedSinceHeader = -1L;
            }
            if (ifModifiedSinceHeader == -1L && httpServletRequest.getHeader(IF_NONE_MATCH_HEADER) == null) {
                this._logger.debug((Object)"No If-Modified-Since or If-None-Match HTTP headers present.");
            } else {
                ArrayList<Date> datesToCheck = new ArrayList<Date>(5);
                if (entries[0].getNumComments() > 0) {
                    BlogComment[] comments = entries[0].getCommentsAsArray();
                    for (int i = comments.length - 1; i >= 0; --i) {
                        BlogComment comment = comments[i];
                        datesToCheck.add(comment.getCommentDate());
                    }
                }
                datesToCheck.add(entries[0].getDate());
                Date[] dates = datesToCheck.toArray(new Date[datesToCheck.size()]);
                Date ifModifiedSinceDate = null;
                ifModifiedSinceHeader = -1L;
                try {
                    ifModifiedSinceHeader = httpServletRequest.getDateHeader(IF_MODIFIED_SINCE_HEADER);
                }
                catch (Exception e) {
                    ifModifiedSinceHeader = -1L;
                }
                if (ifModifiedSinceHeader != -1L) {
                    ifModifiedSinceDate = new Date(ifModifiedSinceHeader);
                }
                String ifNoneMatchHeader = null;
                if (httpServletRequest.getHeader(IF_NONE_MATCH_HEADER) != null) {
                    ifNoneMatchHeader = httpServletRequest.getHeader(IF_NONE_MATCH_HEADER);
                }
                for (int i = 0; i < dates.length; ++i) {
                    Date latestEntryDate = dates[i];
                    if (ifModifiedSinceDate != null) {
                        if (latestEntryDate.toString().equals(ifModifiedSinceDate.toString())) {
                            this._logger.debug((Object)"Returning 304 response based on If-Modified-Since header");
                            httpServletResponse.setStatus(304);
                            break;
                        }
                        this._logger.debug((Object)("Latest entry date/If-Modified-Since date: " + latestEntryDate.toString() + "/" + ifModifiedSinceDate.toString()));
                        continue;
                    }
                    if (ifNoneMatchHeader != null) {
                        String calculatedIfNoneMatchHeader = "\"" + BlojsomUtils.digestString((String)BlojsomUtils.getISO8601Date((Date)latestEntryDate)) + "\"";
                        if (ifNoneMatchHeader.equals(calculatedIfNoneMatchHeader)) {
                            this._logger.debug((Object)"Returning 304 response based on If-None-Match header");
                            httpServletResponse.setStatus(304);
                            break;
                        }
                        this._logger.debug((Object)("Calculated ETag/If-None-Match ETag: " + calculatedIfNoneMatchHeader + "/" + ifNoneMatchHeader));
                        continue;
                    }
                    this._logger.error((Object)"No If-Modified-Since or If-None-Match HTTP headers present and not caught in initial check.");
                }
            }
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

