/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.language;

import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomListener;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.event.ProcessBlogEntryEvent;
import org.blojsom.util.BlojsomUtils;

public class LanguageSelectionPlugin
implements BlojsomPlugin,
BlojsomListener {
    private Log _logger = LogFactory.getLog((Class)LanguageSelectionPlugin.class);
    private static final String LANGUAGE_SELECTION_TEMPLATE = "org/blojsom/plugin/language/templates/admin-language-selection.vm";
    private static final String BLOJSOM_JVM_LANGUAGES = "BLOJSOM_JVM_LANGUAGES";
    private static final String BLOJSOM_PLUGIN_CURRENT_LANGUAGE_SELECTION = "BLOJSOM_PLUGIN_CURRENT_LANGUAGE_SELECTION";
    private static final String METADATA_LANGUAGE = "language";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        blojsomConfiguration.getEventBroadcaster().addListener((BlojsomListener)this);
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public void handleEvent(BlojsomEvent event) {
    }

    public void processEvent(BlojsomEvent event) {
        if (event instanceof ProcessBlogEntryEvent) {
            this._logger.debug((Object)"Handling process blog entry event");
            ProcessBlogEntryEvent processBlogEntryEvent = (ProcessBlogEntryEvent)event;
            String language = BlojsomUtils.getRequestValue((String)METADATA_LANGUAGE, (HttpServletRequest)processBlogEntryEvent.getHttpServletRequest());
            Map context = processBlogEntryEvent.getContext();
            TreeMap<String, String> templateAdditions = (TreeMap<String, String>)processBlogEntryEvent.getContext().get("BLOJSOM_TEMPLATE_ADDITIONS");
            if (templateAdditions == null) {
                templateAdditions = new TreeMap<String, String>();
            }
            templateAdditions.put(this.getClass().getName(), "#parse('org/blojsom/plugin/language/templates/admin-language-selection.vm')");
            processBlogEntryEvent.getContext().put("BLOJSOM_TEMPLATE_ADDITIONS", templateAdditions);
            context.put(BLOJSOM_JVM_LANGUAGES, BlojsomUtils.getLanguagesForSystem((Locale)processBlogEntryEvent.getBlogUser().getBlog().getBlogAdministrationLocale()));
            if (processBlogEntryEvent.getBlogEntry() != null) {
                String currentLanguage = (String)processBlogEntryEvent.getBlogEntry().getMetaData().get(METADATA_LANGUAGE);
                this._logger.debug((Object)("Current language: " + currentLanguage));
                processBlogEntryEvent.getContext().put(BLOJSOM_PLUGIN_CURRENT_LANGUAGE_SELECTION, currentLanguage);
            }
            if (!BlojsomUtils.checkNullOrBlank((String)language)) {
                processBlogEntryEvent.getBlogEntry().getMetaData().put(METADATA_LANGUAGE, language);
                processBlogEntryEvent.getContext().put(BLOJSOM_PLUGIN_CURRENT_LANGUAGE_SELECTION, language);
                this._logger.debug((Object)("Added/updated language: " + language));
            } else {
                if (processBlogEntryEvent.getBlogEntry() != null) {
                    processBlogEntryEvent.getBlogEntry().getMetaData().remove(METADATA_LANGUAGE);
                }
                processBlogEntryEvent.getContext().remove(BLOJSOM_PLUGIN_CURRENT_LANGUAGE_SELECTION);
            }
        }
    }
}

