/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.footnote;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomUtils;

public class FootnotePlugin
implements BlojsomPlugin {
    private static final String FOOTNOTE_METADATA = "footnote";
    private static final String REGEX_FOOTNOTE = "\\[(\\d+)\\]";
    private static final String FOOTNOTE_LINKAGE_FORMAT = "[{0}] {1}";
    private static final String FOOTNOTES_PROCESSED_METADATA = "footnotes-processed";
    private Log _logger = LogFactory.getLog((Class)FootnotePlugin.class);

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        Pattern footnotePattern = Pattern.compile(REGEX_FOOTNOTE);
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            String content = entry.getDescription();
            Matcher matcher = footnotePattern.matcher(content);
            StringBuffer modifiedContent = new StringBuffer();
            TreeMap footnotes = new TreeMap();
            while (matcher.find()) {
                int footnoteIndex = -1;
                try {
                    footnoteIndex = Integer.parseInt(matcher.group(1));
                    if (BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)("footnote-" + footnoteIndex))) {
                        footnotes.put(Integer.toString(footnoteIndex), entry.getMetaData().get("footnote-" + footnoteIndex));
                    }
                    matcher.appendReplacement(modifiedContent, "<sup id=\"footnoteref-" + footnoteIndex + "\"><a href=\"#footnote-" + footnoteIndex + "\">" + footnoteIndex + "</a></sup>");
                }
                catch (NumberFormatException e) {
                    this._logger.error((Object)("Footnote index in post is not a valid integer [" + matcher.group(1) + "]"));
                }
            }
            matcher.appendTail(modifiedContent);
            if (!footnotes.isEmpty() && !BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)FOOTNOTES_PROCESSED_METADATA)) {
                modifiedContent.append("<br/><br/>");
                modifiedContent.append("<div class=\"footnote\">");
                modifiedContent.append("<hr/>");
                modifiedContent.append("<ol>");
                Iterator footnotesIterator = footnotes.keySet().iterator();
                while (footnotesIterator.hasNext()) {
                    String footnoteIndex = (String)footnotesIterator.next();
                    modifiedContent.append("<li id=\"footnote-" + footnoteIndex + "\"><p>");
                    modifiedContent.append(MessageFormat.format(FOOTNOTE_LINKAGE_FORMAT, footnoteIndex, entry.getMetaData().get("footnote-" + footnoteIndex)));
                    modifiedContent.append("<a href=\"#footnoteref-" + footnoteIndex + "\" class=\"footnoteBackLink\" title=\"Jump back to footnote " + footnoteIndex + " in the text.\">");
                    modifiedContent.append("&#8617;</a></p></li>");
                }
                modifiedContent.append("</ol>");
                modifiedContent.append("</div>");
                entry.getMetaData().put(FOOTNOTES_PROCESSED_METADATA, "true");
            }
            entry.setDescription(modifiedContent.toString());
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

