/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.filter;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomListener;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.comment.event.CommentResponseSubmissionEvent;
import org.blojsom.util.BlojsomUtils;

public class XSSFilterPlugin
implements BlojsomPlugin,
BlojsomListener {
    private Log _logger = LogFactory.getLog((Class)XSSFilterPlugin.class);
    private static final String[] DEFAULT_ALLOWED_BALANCED_TAGS = new String[]{"b", "i", "blockquote", "pre", "ul", "li", "ol"};
    private static final String[] DEFAULT_ALLOWED_UNBALANCED_TAGS = new String[]{"br"};
    private static final String XSS_FILTER_ALLOWED_BALANCED_TAGS_IP = "plugin-xss-filter-allowed-balanaced-tags";
    private static final String XSS_FILTER_ALLOWED_UNBALANCED_TAGS_IP = "plugin-xss-filter-allowed-unbalanaced-tags";
    private static final String XSS_FILTER_ALLOW_LINKS_IP = "plugin-xss-filter-allow-links";
    private static final String XSS_FILTER_ALLOWED_BALANCED_TAGS = "XSS_FILTER_ALLOWED_BALANCED_TAGS";
    private static final String XSS_FILTER_ALLOWED_UNBALANCED_TAGS = "XSS_FILTER_ALLOWED_UNBALANCED_TAGS";
    private static final String XSS_FILTER_ALLOW_LINKS = "XSS_FILTER_ALLOW_LINKS";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        blojsomConfiguration.getEventBroadcaster().addListener((BlojsomListener)this);
        this._logger.debug((Object)"Initialized XSS Filter plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        Blog blog = user.getBlog();
        String allowedBalancedTagsIP = blog.getBlogProperty(XSS_FILTER_ALLOWED_BALANCED_TAGS_IP);
        String[] allowedBalancedTags = DEFAULT_ALLOWED_BALANCED_TAGS;
        if (!BlojsomUtils.checkNullOrBlank((String)allowedBalancedTagsIP)) {
            allowedBalancedTags = BlojsomUtils.parseCommaList((String)allowedBalancedTagsIP);
        }
        context.put(XSS_FILTER_ALLOWED_BALANCED_TAGS, allowedBalancedTags);
        String allowedUnbalancedTagsIP = blog.getBlogProperty(XSS_FILTER_ALLOWED_UNBALANCED_TAGS_IP);
        String[] allowedUnbalancedTags = DEFAULT_ALLOWED_UNBALANCED_TAGS;
        if (!BlojsomUtils.checkNullOrBlank((String)allowedUnbalancedTagsIP)) {
            allowedUnbalancedTags = BlojsomUtils.parseCommaList((String)allowedUnbalancedTagsIP);
        }
        context.put(XSS_FILTER_ALLOWED_UNBALANCED_TAGS, allowedUnbalancedTags);
        String allowLinksIP = blog.getBlogProperty(XSS_FILTER_ALLOW_LINKS_IP);
        Boolean allowLinks = Boolean.TRUE;
        if (!BlojsomUtils.checkNullOrBlank((String)allowLinksIP)) {
            allowLinks = Boolean.valueOf(allowLinksIP);
        }
        context.put(XSS_FILTER_ALLOW_LINKS, allowLinks);
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public void handleEvent(BlojsomEvent event) {
    }

    public void processEvent(BlojsomEvent event) {
        if (event instanceof CommentResponseSubmissionEvent) {
            CommentResponseSubmissionEvent commentEvent = (CommentResponseSubmissionEvent)event;
            Blog blog = commentEvent.getBlog().getBlog();
            String allowedBalancedTagsIP = blog.getBlogProperty(XSS_FILTER_ALLOWED_BALANCED_TAGS_IP);
            String[] allowedBalancedTags = DEFAULT_ALLOWED_BALANCED_TAGS;
            if (!BlojsomUtils.checkNullOrBlank((String)allowedBalancedTagsIP)) {
                allowedBalancedTags = BlojsomUtils.parseCommaList((String)allowedBalancedTagsIP);
            }
            String allowedUnbalancedTagsIP = blog.getBlogProperty(XSS_FILTER_ALLOWED_UNBALANCED_TAGS_IP);
            String[] allowedUnbalancedTags = DEFAULT_ALLOWED_UNBALANCED_TAGS;
            if (!BlojsomUtils.checkNullOrBlank((String)allowedUnbalancedTagsIP)) {
                allowedUnbalancedTags = BlojsomUtils.parseCommaList((String)allowedUnbalancedTagsIP);
            }
            String allowLinksIP = blog.getBlogProperty(XSS_FILTER_ALLOW_LINKS_IP);
            boolean allowLinks = true;
            if (!BlojsomUtils.checkNullOrBlank((String)allowLinksIP)) {
                allowLinks = Boolean.valueOf(allowLinksIP);
            }
            String commentText = commentEvent.getContent();
            if ((commentText = BlojsomUtils.escapeStringSimple((String)commentText)) != null) {
                int i;
                for (i = 0; i < allowedBalancedTags.length; ++i) {
                    String allowedBalancedTag = allowedBalancedTags[i];
                    commentText = this.replaceBalancedTag(commentText, allowedBalancedTag);
                }
                for (i = 0; i < allowedUnbalancedTags.length; ++i) {
                    String allowedUnbalancedTag = allowedUnbalancedTags[i];
                    commentText = this.replaceUnbalancedTag(commentText, allowedUnbalancedTag);
                }
                if (allowLinks) {
                    commentText = this.processLinks(commentText);
                }
                commentText = commentText.replaceAll("&amp;lt;", "&lt;");
                commentText = commentText.replaceAll("&amp;gt;", "&gt;");
                commentText = commentText.replaceAll("&amp;#", "&#");
                commentEvent.setContent(commentText);
            }
        }
    }

    private String replaceBalancedTag(String input, String tag) {
        Pattern openingPattern = Pattern.compile("&lt;" + tag + "&gt;", 2);
        Pattern closingPattern = Pattern.compile("&lt;/" + tag + "&gt;", 2);
        Matcher openingMatcher = openingPattern.matcher(input);
        input = openingMatcher.replaceAll("<" + tag + ">");
        Matcher closingMatcher = closingPattern.matcher(input);
        input = closingMatcher.replaceAll("</" + tag + ">");
        return input;
    }

    private String replaceUnbalancedTag(String input, String tag) {
        Pattern unbalancedPattern = Pattern.compile("&lt;" + tag + "\\s*/*&gt;", 2);
        Matcher unbalancedMatcher = unbalancedPattern.matcher(input);
        input = unbalancedMatcher.replaceAll("<" + tag + " />");
        return input;
    }

    private String processLinks(String input) {
        Pattern openingLinkPattern = Pattern.compile("&lt;a href=.*?&gt;", 2);
        Pattern closingLinkPattern = Pattern.compile("&lt;/a&gt;", 2);
        Matcher closingMatcher = closingLinkPattern.matcher(input);
        input = closingMatcher.replaceAll("</a>");
        Matcher openingMatcher = openingLinkPattern.matcher(input);
        while (openingMatcher.find()) {
            int start = openingMatcher.start();
            int end = openingMatcher.end();
            String link = input.substring(start, end);
            link = "<" + link.substring(4, link.length() - 4) + ">";
            input = input.substring(0, start) + link + input.substring(end, input.length());
            openingMatcher = openingLinkPattern.matcher(input);
        }
        return input;
    }
}

