/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.fetcher;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomUtils;

public class FetcherHelperPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)FetcherHelperPlugin.class);
    private static final String BLOJSOM_PLUGIN_FETCHER_HELPER = "BLOJSOM_PLUGIN_FETCHER_HELPER";
    protected BlojsomFetcher _fetcher;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        String fetcherClassName = blojsomConfiguration.getFetcherClass();
        try {
            Class<?> fetcherClass = Class.forName(fetcherClassName);
            this._fetcher = (BlojsomFetcher)fetcherClass.newInstance();
            this._fetcher.init(servletConfig, blojsomConfiguration);
            this._logger.info((Object)("Added blojsom fetcher: " + fetcherClassName));
        }
        catch (ClassNotFoundException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (InstantiationException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        context.put(BLOJSOM_PLUGIN_FETCHER_HELPER, new FetcherHelper(this._fetcher, user));
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public class FetcherHelper {
        private BlojsomFetcher _fetcher;
        private BlogUser _blog;

        public FetcherHelper(BlojsomFetcher fetcher, BlogUser blog) {
            this._fetcher = fetcher;
            this._blog = blog;
        }

        public BlogEntry[] fetchEntriesForCategory(String categoryName, int entriesLimit) {
            BlogEntry[] entries = new BlogEntry[]{};
            categoryName = BlojsomUtils.normalize((String)categoryName);
            BlogCategory category = this._fetcher.newBlogCategory();
            category.setCategory(categoryName);
            category.setCategoryURL(this._blog.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)categoryName));
            HashMap<String, Object> fetchMap = new HashMap<String, Object>();
            fetchMap.put("FETCHER_CATEGORY", category);
            fetchMap.put("FETCHER_NUM_POSTS_INTEGER", new Integer(entriesLimit));
            try {
                entries = this._fetcher.fetchEntries(fetchMap, this._blog);
                if (entries != null) {
                    FetcherHelperPlugin.this._logger.debug((Object)("Retrieved " + entries.length + " entries from category: " + categoryName));
                } else {
                    FetcherHelperPlugin.this._logger.debug((Object)("No entries found in category: " + categoryName));
                }
            }
            catch (BlojsomFetcherException e) {
                FetcherHelperPlugin.this._logger.error((Object)e);
            }
            return entries;
        }

        public BlogEntry[] fetchEntriesForFlavor(String flavor, int entriesLimit) {
            BlogEntry[] entries = new BlogEntry[]{};
            HashMap<String, Object> fetchMap = new HashMap<String, Object>();
            fetchMap.put("FETCHER_FLAVOR", flavor);
            fetchMap.put("FETCHER_NUM_POSTS_INTEGER", new Integer(entriesLimit));
            try {
                entries = this._fetcher.fetchEntries(fetchMap, this._blog);
                if (entries != null) {
                    FetcherHelperPlugin.this._logger.debug((Object)("Retrieved " + entries.length + " entries for flavor: " + flavor));
                } else {
                    FetcherHelperPlugin.this._logger.debug((Object)("No entries found for flavor: " + flavor));
                }
            }
            catch (BlojsomFetcherException e) {
                FetcherHelperPlugin.this._logger.error((Object)e);
            }
            return entries;
        }

        public BlogEntry fetchPermalink(String categoryName, String permalink) {
            BlogEntry[] entries = new BlogEntry[]{};
            try {
                permalink = URLDecoder.decode(permalink, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                FetcherHelperPlugin.this._logger.error((Object)e);
            }
            categoryName = BlojsomUtils.normalize((String)categoryName);
            BlogCategory category = this._fetcher.newBlogCategory();
            category.setCategory(categoryName);
            category.setCategoryURL(this._blog.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)categoryName));
            HashMap<String, Object> fetchMap = new HashMap<String, Object>();
            fetchMap.put("FETCHER_CATEGORY", category);
            fetchMap.put("FETCHER_PERMALINK", permalink);
            try {
                entries = this._fetcher.fetchEntries(fetchMap, this._blog);
                if (entries != null) {
                    FetcherHelperPlugin.this._logger.debug((Object)("Retrieved " + entries.length + " entries from category: " + categoryName));
                } else {
                    FetcherHelperPlugin.this._logger.debug((Object)("No entries found in category: " + categoryName));
                }
            }
            catch (BlojsomFetcherException e) {
                FetcherHelperPlugin.this._logger.error((Object)e);
            }
            if (entries != null && entries.length > 0) {
                return entries[0];
            }
            return null;
        }
    }
}

