/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.excerpt;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomUtils;

public class ExcerptPlugin
implements BlojsomPlugin {
    private static final String SHOWME_PARAM = "smm";
    private static final String EXCERPT_EXPRESSION = "(^|\\s).*<div class=\"excerpt\">(.*)</div>.*";
    private static final String SHOWME_START = "$2 &nbsp;<a class=\"smm\" href=\"";
    private static final String SHOWME_FINISH = "&amp;smm=y\">Read More</a>";
    private Log _logger = LogFactory.getLog((Class)ExcerptPlugin.class);

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String showme = BlojsomUtils.getRequestValue((String)SHOWME_PARAM, (HttpServletRequest)httpServletRequest);
        if (showme == null) {
            this._logger.debug((Object)"Processing all entries");
            this.processEntries(entries);
        } else {
            this._logger.debug((Object)"Not processing because request param was set");
        }
        return entries;
    }

    private void processEntries(BlogEntry[] entries) {
        Pattern p = Pattern.compile(EXCERPT_EXPRESSION, 32);
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            String originalDescription = entry.getDescription();
            Matcher m = p.matcher(originalDescription);
            if (m.matches()) {
                this._logger.info((Object)("Performing excerpt on " + entry.getTitle()));
                StringBuffer newDescription = new StringBuffer(m.replaceAll(SHOWME_START));
                newDescription.append(entry.getLink());
                newDescription.append(SHOWME_FINISH);
                entry.setDescription(newDescription.toString());
                continue;
            }
            this._logger.info((Object)("Nothing to excerpt on " + entry.getTitle()));
        }
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

