/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.email;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.plugin.email.EmailMessage;
import org.blojsom.util.BlojsomUtils;

public class EmailUtils {
    private static Log _logger = LogFactory.getLog((Class)EmailUtils.class);
    public static final String BLOJSOM_OUTBOUNDMAIL = "BLOJSOM_OUTBOUNDMAIL";

    private static void checkContext(Map context) {
        if (!context.containsKey(BLOJSOM_OUTBOUNDMAIL)) {
            context.put(BLOJSOM_OUTBOUNDMAIL, new ArrayList(1));
        }
    }

    public static void notifyBlogAuthor(String subject, String message, Map context, String recipient) {
        EmailUtils.checkContext(context);
        List _messagelist = (List)context.get(BLOJSOM_OUTBOUNDMAIL);
        EmailMessage emailMessage = new EmailMessage(subject, message);
        if (!BlojsomUtils.checkNullOrBlank((String)recipient)) {
            emailMessage.setTo(recipient);
        }
        _messagelist.add(emailMessage);
        context.put(BLOJSOM_OUTBOUNDMAIL, _messagelist);
    }

    public static InternetAddress constructRecipientAddress(String recipient, String defaultname, String defaultemail) throws UnsupportedEncodingException, AddressException {
        InternetAddress result = null;
        result = recipient == null ? new InternetAddress(defaultemail, defaultname) : new InternetAddress(recipient);
        return result;
    }

    public static InternetAddress constructSenderAddress(String sender, String defaultname, String defaultemail) throws UnsupportedEncodingException, AddressException {
        InternetAddress result = null;
        result = sender == null ? new InternetAddress(defaultemail, defaultname) : new InternetAddress(sender);
        return result;
    }

    public static void sendMailMessage(Session mailsession, EmailMessage emailmessage, InternetAddress defaultaddress) {
        try {
            MimeMessage message = new MimeMessage(mailsession);
            MimeMultipart mimeMultipart = new MimeMultipart("alternative");
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setContent((Object)emailmessage.getMessage(), "text/plain");
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)emailmessage.getMessage(), "text/html");
            mimeMultipart.addBodyPart((BodyPart)textPart);
            mimeMultipart.addBodyPart((BodyPart)htmlPart);
            InternetAddress _msgfrom = EmailUtils.constructSenderAddress(emailmessage.getFrom(), "blojsom", defaultaddress.getAddress());
            InternetAddress _msgto = defaultaddress;
            message.setFrom((Address)_msgfrom);
            if (!BlojsomUtils.checkNullOrBlank((String)emailmessage.getTo())) {
                _msgto = new InternetAddress(emailmessage.getTo());
                _logger.debug((Object)("Constructing e-mail message to blog entry author: " + emailmessage.getTo()));
            }
            message.addRecipient(Message.RecipientType.TO, (Address)_msgto);
            message.setSubject(emailmessage.getSubject());
            message.setContent((Multipart)mimeMultipart);
            message.setSentDate(new Date());
            _logger.info((Object)("Sending e-mail message to: " + _msgto.getAddress()));
            Transport.send((Message)message);
        }
        catch (UnsupportedEncodingException e) {
            _logger.error((Object)e);
        }
        catch (MessagingException e) {
            _logger.error((Object)e);
        }
    }
}

