/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.date;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomUtils;

public class DateFormatPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)DateFormatPlugin.class);
    private static final String BLOG_TIMEZONE_ID_IP = "blog-timezone-id";
    private static final String BLOG_DATEFORMAT_PATTERN_IP = "blog-dateformat-pattern";
    public static final String BLOJSOM_DATE_FORMAT = "BLOJSOM_DATE_FORMAT";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String _blogDateFormatPattern;
        Blog blog = user.getBlog();
        String blogTimeZoneId = blog.getBlogProperty(BLOG_TIMEZONE_ID_IP);
        if (BlojsomUtils.checkNullOrBlank((String)blogTimeZoneId)) {
            blogTimeZoneId = TimeZone.getDefault().getID();
        }
        this._logger.debug((Object)("Timezone ID: " + blogTimeZoneId));
        TimeZone _blogTimeZone = TimeZone.getTimeZone(blogTimeZoneId);
        String blogDateFormatPattern = blog.getBlogProperty(BLOG_DATEFORMAT_PATTERN_IP);
        if (BlojsomUtils.checkNullOrBlank((String)blogDateFormatPattern)) {
            _blogDateFormatPattern = null;
            this._logger.debug((Object)"No value supplied for blog-dateformat-pattern");
        } else {
            _blogDateFormatPattern = blogDateFormatPattern;
            this._logger.debug((Object)("Date format pattern: " + blogDateFormatPattern));
        }
        Locale _blogLocale = new Locale(blog.getBlogLanguage());
        DateFormat _blogDateFormat = DateFormat.getDateTimeInstance(0, 0, _blogLocale);
        _blogDateFormat.setTimeZone(_blogTimeZone);
        if (_blogDateFormatPattern != null) {
            try {
                SimpleDateFormat sdf = (SimpleDateFormat)_blogDateFormat;
                sdf.applyPattern(_blogDateFormatPattern);
                _blogDateFormat = sdf;
            }
            catch (IllegalArgumentException ie) {
                this._logger.error((Object)("Date format pattern \"" + _blogDateFormatPattern + "\" is invalid - using DateFormat.FULL"));
            }
            catch (ClassCastException ce) {
                this._logger.warn((Object)"Cannot cast to SimpleDateFormat to apply date format pattern");
            }
        }
        context.put(BLOJSOM_DATE_FORMAT, _blogDateFormat);
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

