/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.crosspost;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomListener;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.event.AddBlogEntryEvent;
import org.blojsom.plugin.admin.event.BlogEntryEvent;
import org.blojsom.plugin.crosspost.beans.Destination;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class CrosspostPlugin
implements BlojsomPlugin,
BlojsomListener,
BlojsomConstants {
    private Log _logger = LogFactory.getLog((Class)CrosspostPlugin.class);
    public static final String PLUGIN_CROSSPOST_CONFIGURATION_IP = "plugin-crosspost";
    private static final String PLUGIN_CROSSPOST_METADATA_KEY = "blojsom.crosspost";
    private ServletConfig _servletConfig;
    private BlojsomConfiguration _blojsomConfiguration;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._servletConfig = servletConfig;
        this._blojsomConfiguration = blojsomConfiguration;
        this._blojsomConfiguration.getEventBroadcaster().addListener((BlojsomListener)this);
        this._logger.debug((Object)"Initialized crosspost plugin.");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    private Map processConfiguration(BlogUser blogUser) {
        String[] destinations;
        HashMap<String, Destination> destinationMap = new HashMap<String, Destination>();
        String xpostConfiguration = this._servletConfig.getInitParameter(PLUGIN_CROSSPOST_CONFIGURATION_IP);
        String configurationFile = this._blojsomConfiguration.getBaseConfigurationDirectory() + blogUser.getId() + "/" + xpostConfiguration;
        BlojsomProperties userXpost = new BlojsomProperties();
        try {
            InputStream is = this._servletConfig.getServletContext().getResourceAsStream(configurationFile);
            if (is == null) {
                this._logger.info((Object)("No Crosspost configuration file for blog: " + blogUser.getId()));
                return destinationMap;
            }
            userXpost.load(is);
            is.close();
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            return destinationMap;
        }
        Map configurationMap = BlojsomUtils.propertiesToMap((Properties)userXpost);
        String destinationChain = (String)configurationMap.get("destinations");
        if (destinationChain != null && (destinations = BlojsomUtils.parseCommaList((String)destinationChain)) != null) {
            destinationMap = new HashMap(destinations.length);
            for (int x = 0; x < destinations.length; ++x) {
                String id = destinations[x];
                Destination destination = new Destination();
                String title = (String)configurationMap.get(id + ".title");
                destination.setTitle(title);
                String url = (String)configurationMap.get(id + ".url");
                destination.setUrl(url);
                String userid = (String)configurationMap.get(id + ".userid");
                destination.setUserId(userid);
                String password = (String)configurationMap.get(id + ".password");
                destination.setPassword(password);
                String category = (String)configurationMap.get(id + ".category");
                destination.setCategory(category);
                String blogid = (String)configurationMap.get(id + ".blogid");
                destination.setBlogId(blogid);
                int apiType = 0;
                String type = (String)configurationMap.get(id + ".type");
                if (type.toLowerCase().equalsIgnoreCase("metaweblog")) {
                    apiType = 1;
                }
                destination.setApiType(apiType);
                this._logger.info((Object)("Adding CrossPost Destination [" + destination.getTitle() + "] @ [" + destination.getUrl() + "]"));
                destinationMap.put(id, destination);
            }
        }
        return destinationMap;
    }

    public void handleEvent(BlojsomEvent event) {
        BlogEntryEvent entryEvent;
        if (event instanceof BlogEntryEvent && (entryEvent = (BlogEntryEvent)event) instanceof AddBlogEntryEvent) {
            AddBlogEntryEvent addEntryEvent = (AddBlogEntryEvent)entryEvent;
            BlogCategory blogCategory = addEntryEvent.getBlogEntry().getBlogCategory();
            Map categoryMetaData = blogCategory.getMetaData();
            if (categoryMetaData != null) {
                String[] destinations;
                String xpost = (String)categoryMetaData.get(PLUGIN_CROSSPOST_METADATA_KEY);
                if (xpost != null && (destinations = BlojsomUtils.parseCommaList((String)xpost)) != null) {
                    Map destinationsMap = this.processConfiguration(entryEvent.getBlogUser());
                    for (int x = 0; x < destinations.length; ++x) {
                        String destination = destinations[x];
                        this._logger.info((Object)("Crossposting to " + destination));
                        if (!destinationsMap.containsKey(destination)) continue;
                        Destination d = (Destination)destinationsMap.get(destination);
                        this.publishCrosspost(addEntryEvent.getBlogEntry(), d);
                    }
                }
            } else {
                this._logger.info((Object)("No category metadata for " + blogCategory.getCategory()));
            }
        }
    }

    public void processEvent(BlojsomEvent event) {
    }

    private void publishCrosspost(BlogEntry entry, Destination destination) {
        String method = null;
        Vector<Object> param = new Vector<Object>();
        param.add("0");
        param.add(destination.getCategory());
        param.add(destination.getUserId());
        param.add(destination.getPassword());
        if (destination.getApiType() == 0) {
            method = "blogger.newPost";
            param.add(entry.getTitle() + "\n" + entry.getDescription());
        } else {
            method = "metaWeblog.newPost";
            param.add(entry.getTitle() + "\n" + entry.getDescription());
        }
        param.add(Boolean.TRUE);
        String url = destination.getUrl();
        try {
            XmlRpcClient xpostClient = new XmlRpcClient(url);
            xpostClient.execute(method, param);
        }
        catch (XmlRpcException e) {
            this._logger.error((Object)e);
        }
        catch (IOException e) {
            this._logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

