/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.common;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomListener;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.event.ProcessBlogEntryEvent;
import org.blojsom.util.BlojsomUtils;

public class RSSEnclosurePlugin
implements BlojsomPlugin,
BlojsomListener {
    private Log _logger = LogFactory.getLog((Class)RSSEnclosurePlugin.class);
    private BlojsomConfiguration _blojsomConfiguration;
    private static final String RSS_ENCLOSURE_TEMPLATE = "org/blojsom/plugin/common/templates/admin-rss-enclosure-attachment.vm";
    private static final String RSS_ENCLOSURE_ATTACHMENT = "RSS_ENCLOSURE_ATTACHMENT";
    private static final String RSS_ENCLOSURE_URL_ITEM = "RSS_ENCLOSURE_URL_ITEM";
    private static final String RSS_ENCLOSURE_LENGTH_ITEM = "RSS_ENCLOSURE_LENGTH_ITEM";
    private static final String RSS_ENCLOSURE_TYPE_ITEM = "RSS_ENCLOSURE_TYPE_ITEM";
    private static final String RSS_ENCLOSURE_LINK_TEMPLATE = "<enclosure url=\"{0}\" length=\"{1}\" type=\"{2}\" />";
    protected static final String MIME_TYPE_XMPEGURL = "audio/x-mpegurl m3u";
    protected static final String MIME_TYPE_XMPEG = "audio/x-mpeg mp1 mp2 mp3 mpa mpega";
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    public static final String METADATA_RSS_ENCLOSURE = "rss-enclosure";
    public static final String METADATA_ESS_ENCLOSURE_OBJECT = "rss-enclosure-object";
    public static final String RSS_ENCLOSURE_URL = "rss-enclosure-url";
    public static final String RSS_ENCLOSURE_LENGTH = "rss-enclosure-length";
    public static final String RSS_ENCLOSURE_TYPE = "rss-enclosure-type";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._blojsomConfiguration = blojsomConfiguration;
        this._blojsomConfiguration.getEventBroadcaster().addListener((BlojsomListener)this);
        this._logger.debug((Object)"Initialized RSS enclosures plugin");
    }

    protected void addAdditionalMimeTypes(MimetypesFileTypeMap mimeTypes) {
        mimeTypes.addMimeTypes(MIME_TYPE_XMPEGURL);
        mimeTypes.addMimeTypes(MIME_TYPE_XMPEG);
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            if (BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)RSS_ENCLOSURE_URL) && BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)RSS_ENCLOSURE_LENGTH) && BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)RSS_ENCLOSURE_TYPE)) {
                String rssEnclosureURL = (String)entry.getMetaData().get(RSS_ENCLOSURE_URL);
                long rssEnclosureLength = -1L;
                try {
                    rssEnclosureLength = Long.parseLong((String)entry.getMetaData().get(RSS_ENCLOSURE_LENGTH));
                }
                catch (NumberFormatException e) {
                    this._logger.error((Object)e);
                }
                String rssEnclosureType = (String)entry.getMetaData().get(RSS_ENCLOSURE_TYPE);
                String rssEnclosure = MessageFormat.format(RSS_ENCLOSURE_LINK_TEMPLATE, rssEnclosureURL, new Long(rssEnclosureLength).toString(), rssEnclosureType);
                RSSEnclosure rssEnclosureObject = new RSSEnclosure(rssEnclosureURL, rssEnclosureLength, rssEnclosureType);
                entry.getMetaData().put(METADATA_RSS_ENCLOSURE, rssEnclosure);
                entry.getMetaData().put(METADATA_ESS_ENCLOSURE_OBJECT, rssEnclosureObject);
                this._logger.debug((Object)("Added explicit enclosure: " + rssEnclosure));
                continue;
            }
            if (!BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)METADATA_RSS_ENCLOSURE)) continue;
            String enclosureName = BlojsomUtils.getFilenameFromPath((String)((String)entry.getMetaData().get(METADATA_RSS_ENCLOSURE)));
            File enclosure = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getResourceDirectory() + user.getId() + "/" + enclosureName);
            if (!enclosure.exists()) continue;
            this._logger.debug((Object)("Adding enclosure to entry for file: " + enclosureName));
            MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
            this.addAdditionalMimeTypes(mimetypesFileTypeMap);
            String type = mimetypesFileTypeMap.getContentType(enclosure);
            StringBuffer enclosureElement = new StringBuffer();
            String url = user.getBlog().getBlogBaseURL() + this._blojsomConfiguration.getResourceDirectory() + user.getId() + "/" + enclosure.getName();
            enclosureElement.append("<enclosure url=\"");
            enclosureElement.append(url);
            enclosureElement.append("\" length=\"");
            enclosureElement.append(enclosure.length());
            enclosureElement.append("\" type=\"");
            if (BlojsomUtils.checkNullOrBlank((String)type)) {
                type = DEFAULT_MIME_TYPE;
            }
            enclosureElement.append(type);
            enclosureElement.append("\" />");
            RSSEnclosure rssEnclosure = new RSSEnclosure(url, enclosure.length(), type);
            entry.getMetaData().put(METADATA_RSS_ENCLOSURE, enclosureElement.toString());
            entry.getMetaData().put(METADATA_ESS_ENCLOSURE_OBJECT, rssEnclosure);
            this._logger.debug((Object)("Added enclosure: " + enclosureElement.toString()));
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public void handleEvent(BlojsomEvent event) {
    }

    public void processEvent(BlojsomEvent event) {
        if (event instanceof ProcessBlogEntryEvent) {
            this._logger.debug((Object)"Handling process blog entry event");
            ProcessBlogEntryEvent processBlogEntryEvent = (ProcessBlogEntryEvent)event;
            String blogID = processBlogEntryEvent.getBlogUser().getId();
            TreeMap<String, String> templateAdditions = (TreeMap<String, String>)processBlogEntryEvent.getContext().get("BLOJSOM_TEMPLATE_ADDITIONS");
            if (templateAdditions == null) {
                templateAdditions = new TreeMap<String, String>();
            }
            templateAdditions.put(this.getClass().getName(), "#parse('org/blojsom/plugin/common/templates/admin-rss-enclosure-attachment.vm')");
            processBlogEntryEvent.getContext().put("BLOJSOM_TEMPLATE_ADDITIONS", templateAdditions);
            File resourceDirectory = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getResourceDirectory() + blogID + "/");
            AbstractMap resourceFilesMap = null;
            if (resourceDirectory.exists()) {
                File[] resourceFiles = resourceDirectory.listFiles();
                if (resourceFiles != null) {
                    resourceFilesMap = new HashMap(resourceFiles.length);
                    for (int i = 0; i < resourceFiles.length; ++i) {
                        File resourceFile = resourceFiles[i];
                        resourceFilesMap.put(resourceFile.getName(), resourceFile.getName());
                    }
                }
            } else {
                resourceFilesMap = new HashMap<String, String>();
            }
            if (processBlogEntryEvent.getBlogEntry() != null) {
                String currentEnclosure = (String)processBlogEntryEvent.getBlogEntry().getMetaData().get(METADATA_RSS_ENCLOSURE);
                String currentEnclosureURL = (String)processBlogEntryEvent.getBlogEntry().getMetaData().get(RSS_ENCLOSURE_URL);
                String currentEnclosureLength = (String)processBlogEntryEvent.getBlogEntry().getMetaData().get(RSS_ENCLOSURE_LENGTH);
                String currentEnclosureType = (String)processBlogEntryEvent.getBlogEntry().getMetaData().get(RSS_ENCLOSURE_TYPE);
                this._logger.debug((Object)("Current enclosure: " + currentEnclosure));
                processBlogEntryEvent.getContext().put(RSS_ENCLOSURE_ATTACHMENT, currentEnclosure);
                processBlogEntryEvent.getContext().put(RSS_ENCLOSURE_URL_ITEM, currentEnclosureURL);
                processBlogEntryEvent.getContext().put(RSS_ENCLOSURE_LENGTH_ITEM, currentEnclosureLength);
                processBlogEntryEvent.getContext().put(RSS_ENCLOSURE_TYPE_ITEM, currentEnclosureType);
            }
            String rssEnclosure = BlojsomUtils.getRequestValue((String)METADATA_RSS_ENCLOSURE, (HttpServletRequest)processBlogEntryEvent.getHttpServletRequest());
            String rssEnclosureURL = BlojsomUtils.getRequestValue((String)RSS_ENCLOSURE_URL, (HttpServletRequest)processBlogEntryEvent.getHttpServletRequest());
            String rssEnclosureLength = BlojsomUtils.getRequestValue((String)RSS_ENCLOSURE_LENGTH, (HttpServletRequest)processBlogEntryEvent.getHttpServletRequest());
            String rssEnclosureType = BlojsomUtils.getRequestValue((String)RSS_ENCLOSURE_TYPE, (HttpServletRequest)processBlogEntryEvent.getHttpServletRequest());
            if (!BlojsomUtils.checkNullOrBlank((String)rssEnclosureURL) && processBlogEntryEvent.getBlogEntry() != null) {
                processBlogEntryEvent.getBlogEntry().getMetaData().put(RSS_ENCLOSURE_URL, rssEnclosureURL);
                if (BlojsomUtils.checkNullOrBlank((String)rssEnclosureLength) && BlojsomUtils.checkNullOrBlank((String)rssEnclosureType)) {
                    String[] enclosureProperties = this.discoverEnclosureProperties(rssEnclosureURL);
                    rssEnclosureLength = enclosureProperties[0];
                    rssEnclosureType = enclosureProperties[1];
                }
                processBlogEntryEvent.getBlogEntry().getMetaData().put(RSS_ENCLOSURE_LENGTH, rssEnclosureLength);
                processBlogEntryEvent.getBlogEntry().getMetaData().put(RSS_ENCLOSURE_TYPE, rssEnclosureType);
                processBlogEntryEvent.getContext().put(RSS_ENCLOSURE_URL_ITEM, rssEnclosureURL);
                processBlogEntryEvent.getContext().put(RSS_ENCLOSURE_LENGTH_ITEM, rssEnclosureLength);
                processBlogEntryEvent.getContext().put(RSS_ENCLOSURE_TYPE_ITEM, rssEnclosureType);
                this._logger.debug((Object)("Added/updated RSS enclosure (explict): " + rssEnclosureURL));
            } else {
                if (processBlogEntryEvent.getBlogEntry() != null) {
                    processBlogEntryEvent.getBlogEntry().getMetaData().remove(RSS_ENCLOSURE_URL);
                    processBlogEntryEvent.getBlogEntry().getMetaData().remove(RSS_ENCLOSURE_TYPE);
                    processBlogEntryEvent.getBlogEntry().getMetaData().remove(RSS_ENCLOSURE_LENGTH);
                }
                processBlogEntryEvent.getContext().remove(RSS_ENCLOSURE_URL_ITEM);
                processBlogEntryEvent.getContext().remove(RSS_ENCLOSURE_TYPE_ITEM);
                processBlogEntryEvent.getContext().remove(RSS_ENCLOSURE_LENGTH_ITEM);
                if (!BlojsomUtils.checkNullOrBlank((String)rssEnclosure) && processBlogEntryEvent.getBlogEntry() != null) {
                    processBlogEntryEvent.getBlogEntry().getMetaData().put(METADATA_RSS_ENCLOSURE, rssEnclosure);
                    processBlogEntryEvent.getContext().put(RSS_ENCLOSURE_ATTACHMENT, rssEnclosure);
                    this._logger.debug((Object)("Added/updated RSS enclosure: " + BlojsomUtils.getFilenameFromPath((String)rssEnclosure)));
                } else {
                    if (processBlogEntryEvent.getBlogEntry() != null) {
                        processBlogEntryEvent.getBlogEntry().getMetaData().remove(METADATA_RSS_ENCLOSURE);
                    }
                    processBlogEntryEvent.getContext().remove(RSS_ENCLOSURE_ATTACHMENT);
                }
            }
            resourceFilesMap = new TreeMap(resourceFilesMap);
            processBlogEntryEvent.getContext().put("PLUGIN_RSS_ENCLOSURE_FILES", resourceFilesMap);
        }
    }

    protected String[] discoverEnclosureProperties(String rssEnclosureURL) {
        String[] enclosureProperties = new String[]{"", ""};
        try {
            if (!rssEnclosureURL.toLowerCase().startsWith("http://")) {
                this._logger.debug((Object)"RSS enclosure URL not an HTTP-accessible resource");
            } else {
                URL enclosure = new URL(rssEnclosureURL);
                HttpURLConnection httpURLConnection = (HttpURLConnection)enclosure.openConnection();
                httpURLConnection.setRequestMethod("HEAD");
                httpURLConnection.connect();
                enclosureProperties[0] = Integer.toString(httpURLConnection.getContentLength());
                enclosureProperties[1] = httpURLConnection.getContentType();
                httpURLConnection.disconnect();
            }
        }
        catch (Exception e) {
            this._logger.error((Object)"Error retrieving enclosure properties", (Throwable)e);
        }
        return enclosureProperties;
    }

    public class RSSEnclosure {
        private String url;
        private long length;
        private String type;

        public RSSEnclosure(String url, long length, String type) {
            this.url = url;
            this.length = length;
            this.type = type;
        }

        public String getUrl() {
            return this.url;
        }

        public long getLength() {
            return this.length;
        }

        public String getType() {
            return this.type;
        }
    }
}

