/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.comment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogComment;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;

public class RecentCommentsPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)RecentCommentsPlugin.class);
    private static final int DEFAULT_COMMENT_COUNT = 25;
    private static final String BLOJSOM_RECENT_COMMENTS = "BLOJSOM_RECENT_COMMENTS";
    private static final String PARAM_COMMEN_COUNT = "count";
    public static final Comparator COMMENT_DATE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            BlogComment f1 = (BlogComment)o1;
            BlogComment f2 = (BlogComment)o2;
            if (f1.getCommentDate().before(f2.getCommentDate())) {
                return 1;
            }
            return -1;
        }
    };

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String countParam = httpServletRequest.getParameter(PARAM_COMMEN_COUNT);
        int count = 25;
        if (countParam != null && !"".equals(countParam)) {
            try {
                count = Integer.parseInt(countParam);
            }
            catch (NumberFormatException e) {
                this._logger.error((Object)"Invalid value for Recent Comments count param, using default");
                count = 25;
            }
        }
        List<BlogComment> commentsList = new ArrayList(100);
        for (int x = 0; x < entries.length; ++x) {
            BlogEntry entry = entries[x];
            BlogComment[] comments = entry.getCommentsAsArray();
            if (comments == null || comments.length <= 0) continue;
            for (int y = 0; y < comments.length; ++y) {
                BlogComment comment = comments[y];
                commentsList.add(comment);
            }
        }
        if (commentsList.size() > 0) {
            Collections.sort(commentsList, COMMENT_DATE_COMPARATOR);
            if (commentsList.size() > count) {
                commentsList = commentsList.subList(0, count - 1);
            }
            context.put(BLOJSOM_RECENT_COMMENTS, commentsList);
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

