/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.comment;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogComment;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.comment.event.CommentAddedEvent;
import org.blojsom.plugin.comment.event.CommentResponseSubmissionEvent;
import org.blojsom.plugin.common.VelocityPlugin;
import org.blojsom.plugin.email.EmailUtils;
import org.blojsom.util.BlojsomMetaDataConstants;
import org.blojsom.util.BlojsomUtils;
import org.blojsom.util.CookieUtils;

public class CommentPlugin
extends VelocityPlugin
implements BlojsomMetaDataConstants {
    private Log _logger = LogFactory.getLog((Class)CommentPlugin.class);
    public static final String COMMENT_PLUGIN_EMAIL_TEMPLATE = "org/blojsom/plugin/comment/comment-plugin-email-template.vm";
    public static final String DEFAULT_COMMENT_PREFIX = "[blojsom] Comment on: ";
    public static final String COMMENT_PREFIX_IP = "plugin-comment-email-prefix";
    public static final String COMMENT_AUTOFORMAT_IP = "plugin-comment-autoformat";
    public static final String COMMENT_COOKIE_EXPIRATION_DURATION_IP = "plugin-comment-expiration-duration";
    public static final String COMMENT_THROTTLE_MINUTES_IP = "plugin-comment-throttle";
    public static final String COMMENT_DAYS_EXPIRATION_IP = "plugin-comment-days-expiration";
    private static final int COMMENT_THROTTLE_DEFAULT_MINUTES = 5;
    public static final String COMMENT_PARAM = "comment";
    public static final String AUTHOR_PARAM = "author";
    public static final String AUTHOR_EMAIL_PARAM = "authorEmail";
    public static final String AUTHOR_URL_PARAM = "authorURL";
    public static final String COMMENT_TEXT_PARAM = "commentText";
    private static final String REMEMBER_ME_PARAM = "remember";
    private static final String COOKIE_AUTHOR = "blojsom.cookie.author";
    private static final String COOKIE_EMAIL = "blojsom.cookie.authorEmail";
    private static final String COOKIE_URL = "blojsom.cookie.authorURL";
    private static final String COOKIE_REMEMBER_ME = "blojsom.cookie.rememberme";
    private static final int COOKIE_EXPIRATION_AGE = 604800;
    public static final String BLOJSOM_COMMENT_PLUGIN_ENABLED = "BLOJSOM_COMMENT_PLUGIN_ENABLED";
    public static final String BLOJSOM_COMMENT_PLUGIN_AUTHOR = "BLOJSOM_COMMENT_PLUGIN_AUTHOR";
    public static final String BLOJSOM_COMMENT_PLUGIN_AUTHOR_EMAIL = "BLOJSOM_COMMENT_PLUGIN_AUTHOR_EMAIL";
    public static final String BLOJSOM_COMMENT_PLUGIN_AUTHOR_URL = "BLOJSOM_COMMENT_PLUGIN_AUTHOR_URL";
    public static final String BLOJSOM_COMMENT_PLUGIN_REMEMBER_ME = "BLOJSOM_COMMENT_PLUGIN_REMEMBER_ME";
    public static final String BLOJSOM_COMMENT_PLUGIN_METADATA_IP = "BLOJSOM_COMMENT_PLUGIN_METADATA_IP";
    public static final String BLOJSOM_COMMENT_PLUGIN_BLOG_ENTRY = "BLOJSOM_COMMENT_PLUGIN_BLOG_ENTRY";
    public static final String BLOJSOM_COMMENT_PLUGIN_BLOG_COMMENT = "BLOJSOM_COMMENT_PLUGIN_BLOG_COMMENT";
    public static final String BLOJSOM_PLUGIN_COMMENT_METADATA = "BLOJSOM_PLUGIN_COMMENT_METADATA";
    public static final String BLOJSOM_PLUGIN_COMMENT_METADATA_DESTROY = "BLOJSOM_PLUGIN_COMMENT_METADATA_DESTROY";
    private Map _ipAddressCommentTimes;
    private BlojsomFetcher _fetcher;
    private BlojsomConfiguration _configuration;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        this._configuration = blojsomConfiguration;
        this._ipAddressCommentTimes = new HashMap(10);
        String fetcherClassName = blojsomConfiguration.getFetcherClass();
        try {
            Class<?> fetcherClass = Class.forName(fetcherClassName);
            this._fetcher = (BlojsomFetcher)fetcherClass.newInstance();
            this._fetcher.init(servletConfig, blojsomConfiguration);
            this._logger.info((Object)("Added blojsom fetcher: " + fetcherClassName));
        }
        catch (ClassNotFoundException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (InstantiationException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        int _cookieExpiration;
        String cookieExpiration;
        String[] bannedIPList;
        Blog blog = user.getBlog();
        context.put(BLOJSOM_COMMENT_PLUGIN_ENABLED, blog.getBlogCommentsEnabled());
        if (!blog.getBlogCommentsEnabled().booleanValue()) {
            this._logger.debug((Object)("blog comments not enabled for user: " + user.getId()));
            return entries;
        }
        String bannedIPListParam = blog.getBlogProperty("blog-banned-ip-addresses");
        if (bannedIPListParam == null) {
            bannedIPList = null;
            this._logger.info((Object)"Blog configuration parameter not supplied for: blog-banned-ip-addresses");
        } else {
            bannedIPList = BlojsomUtils.parseCommaList((String)bannedIPListParam);
        }
        Boolean _blogCommentsEnabled = blog.getBlogCommentsEnabled();
        Boolean _blogEmailEnabled = blog.getBlogEmailEnabled();
        String _emailPrefix = blog.getBlogProperty(COMMENT_PREFIX_IP);
        if (_emailPrefix == null) {
            _emailPrefix = DEFAULT_COMMENT_PREFIX;
        }
        if (BlojsomUtils.checkNullOrBlank((String)(cookieExpiration = blog.getBlogProperty(COMMENT_COOKIE_EXPIRATION_DURATION_IP)))) {
            _cookieExpiration = 604800;
        } else {
            try {
                _cookieExpiration = Integer.parseInt(cookieExpiration);
            }
            catch (NumberFormatException e) {
                _cookieExpiration = 604800;
            }
        }
        if (entries.length == 0) {
            return entries;
        }
        String remoteIPAddress = httpServletRequest.getRemoteAddr();
        if (this.isIPBanned(bannedIPList, remoteIPAddress)) {
            this._logger.debug((Object)("Attempted comment from banned IP address: " + remoteIPAddress));
            return entries;
        }
        String author = httpServletRequest.getParameter(AUTHOR_PARAM);
        String authorEmail = httpServletRequest.getParameter(AUTHOR_EMAIL_PARAM);
        String authorURL = httpServletRequest.getParameter(AUTHOR_URL_PARAM);
        String rememberMe = httpServletRequest.getParameter(REMEMBER_ME_PARAM);
        Cookie authorCookie = CookieUtils.getCookie((HttpServletRequest)httpServletRequest, (String)COOKIE_AUTHOR);
        if (authorCookie != null && (author == null || "".equals(author))) {
            Cookie rememberMeCookie;
            Cookie authorUrlCookie;
            author = authorCookie.getValue();
            this._logger.debug((Object)("Pulling author from cookie: " + author));
            if ("".equals(author)) {
                author = null;
            } else {
                context.put(BLOJSOM_COMMENT_PLUGIN_AUTHOR, author);
            }
            Cookie authorEmailCookie = CookieUtils.getCookie((HttpServletRequest)httpServletRequest, (String)COOKIE_EMAIL);
            if (authorEmailCookie != null && (authorEmail == null || "".equals(authorEmail))) {
                authorEmail = authorEmailCookie.getValue();
                this._logger.debug((Object)("Pulling author email from cookie: " + authorEmail));
                if (authorEmail == null) {
                    authorEmail = "";
                } else {
                    context.put(BLOJSOM_COMMENT_PLUGIN_AUTHOR_EMAIL, authorEmail);
                }
            }
            if ((authorUrlCookie = CookieUtils.getCookie((HttpServletRequest)httpServletRequest, (String)COOKIE_URL)) != null && (authorURL == null || "".equals(authorURL))) {
                authorURL = authorUrlCookie.getValue();
                this._logger.debug((Object)("Pulling author URL from cookie: " + authorURL));
                if (authorURL == null) {
                    authorURL = "";
                } else {
                    context.put(BLOJSOM_COMMENT_PLUGIN_AUTHOR_URL, authorURL);
                }
            }
            if ((rememberMeCookie = CookieUtils.getCookie((HttpServletRequest)httpServletRequest, (String)COOKIE_REMEMBER_ME)) != null && (rememberMe == null || "".equals(rememberMe))) {
                rememberMe = rememberMeCookie.getValue();
                if (rememberMe == null) {
                    rememberMe = "";
                } else {
                    context.put(BLOJSOM_COMMENT_PLUGIN_REMEMBER_ME, rememberMe);
                }
            }
        }
        if ("y".equalsIgnoreCase(httpServletRequest.getParameter(COMMENT_PARAM)) && _blogCommentsEnabled.booleanValue()) {
            String commentText = httpServletRequest.getParameter(COMMENT_TEXT_PARAM);
            String permalink = httpServletRequest.getParameter("permalink");
            String category = httpServletRequest.getParameter("category");
            category = BlojsomUtils.urlDecode((String)category);
            String remember = httpServletRequest.getParameter(REMEMBER_ME_PARAM);
            String title = entries[0].getTitle();
            if (!(author == null || "".equals(author) || commentText == null || "".equals(commentText) || permalink == null || "".equals(permalink) || category == null || "".equals(category))) {
                block48: {
                    String commentThrottleValue = blog.getBlogProperty(COMMENT_THROTTLE_MINUTES_IP);
                    if (!BlojsomUtils.checkNullOrBlank((String)commentThrottleValue)) {
                        int commentThrottleMinutes;
                        try {
                            commentThrottleMinutes = Integer.parseInt(commentThrottleValue);
                        }
                        catch (NumberFormatException e) {
                            commentThrottleMinutes = 5;
                        }
                        this._logger.debug((Object)("Comment throttling enabled at: " + commentThrottleMinutes + " minutes"));
                        remoteIPAddress = httpServletRequest.getRemoteAddr();
                        if (this._ipAddressCommentTimes.containsKey(remoteIPAddress)) {
                            Calendar currentTime = Calendar.getInstance();
                            Calendar timeOfLastComment = (Calendar)this._ipAddressCommentTimes.get(remoteIPAddress);
                            long timeDifference = currentTime.getTimeInMillis() - timeOfLastComment.getTimeInMillis();
                            long differenceInMinutes = timeDifference / 60000L;
                            if (differenceInMinutes < (long)commentThrottleMinutes) {
                                this._logger.debug((Object)("Comment throttle enabled. Comment from IP address: " + remoteIPAddress + " in less than " + commentThrottleMinutes + " minutes"));
                                return entries;
                            }
                            this._logger.debug((Object)"Comment throttle enabled. Resetting date of last comment to current time");
                            this._ipAddressCommentTimes.put(remoteIPAddress, currentTime);
                        } else {
                            Calendar calendar = Calendar.getInstance();
                            this._ipAddressCommentTimes.put(remoteIPAddress, calendar);
                        }
                    }
                    author = author.trim();
                    commentText = commentText.trim();
                    boolean autoformatComments = Boolean.valueOf(blog.getBlogProperty(COMMENT_AUTOFORMAT_IP));
                    if (autoformatComments) {
                        commentText = BlojsomUtils.replace((String)commentText, (String)"\n", (String)"<br />");
                    }
                    authorEmail = authorEmail != null ? authorEmail.trim() : "";
                    authorURL = authorURL != null ? authorURL.trim() : "";
                    if (!category.endsWith("/")) {
                        category = category + "/";
                    }
                    if (authorURL != null && !"".equals(authorURL) && !authorURL.toLowerCase().startsWith("http://")) {
                        authorURL = "http://" + authorURL;
                    }
                    BlogCategory blogCategory = this._fetcher.newBlogCategory();
                    blogCategory.setCategory(category);
                    blogCategory.setCategoryURL(user.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)category));
                    HashMap<String, Object> fetchMap = new HashMap<String, Object>();
                    fetchMap.put("FETCHER_CATEGORY", blogCategory);
                    fetchMap.put("FETCHER_PERMALINK", permalink);
                    try {
                        BlogEntry[] fetchedEntries = this._fetcher.fetchEntries(fetchMap, user);
                        if (fetchedEntries.length <= 0) break block48;
                        BlogEntry entry = fetchedEntries[0];
                        if (BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)"blog-entry-comments-disabled")) {
                            this._logger.debug((Object)("Comments have been disabled for blog entry: " + entry.getId()));
                            return entries;
                        }
                        String commentDaysExpiration = blog.getBlogProperty(COMMENT_DAYS_EXPIRATION_IP);
                        if (BlojsomUtils.checkNullOrBlank((String)commentDaysExpiration)) break block48;
                        try {
                            int daysExpiration = Integer.parseInt(commentDaysExpiration);
                            int daysBetweenDates = BlojsomUtils.daysBetweenDates((Date)entry.getDate(), (Date)new Date());
                            if (daysExpiration > 0 && daysBetweenDates >= daysExpiration) {
                                this._logger.debug((Object)("Comment period for this entry has expired. Expiration period set at " + daysExpiration + " days. Difference in days: " + daysBetweenDates));
                                return entries;
                            }
                        }
                        catch (NumberFormatException e) {
                            this._logger.error((Object)("Error in parameter plugin-comment-days-expiration: " + commentDaysExpiration));
                        }
                    }
                    catch (BlojsomFetcherException e) {
                        this._logger.error((Object)e);
                    }
                }
                HashMap<String, String> commentMetaData = new HashMap<String, String>();
                commentMetaData.put(BLOJSOM_COMMENT_PLUGIN_METADATA_IP, remoteIPAddress);
                if (context.containsKey(BLOJSOM_PLUGIN_COMMENT_METADATA)) {
                    Map metaData = (Map)context.get(BLOJSOM_PLUGIN_COMMENT_METADATA);
                    Iterator metaDataKeys = metaData.keySet().iterator();
                    while (metaDataKeys.hasNext()) {
                        Object key = metaDataKeys.next();
                        Object value = metaData.get(key);
                        commentMetaData.put((String)key, (String)value);
                    }
                }
                CommentResponseSubmissionEvent commentResponseSubmissionEvent = new CommentResponseSubmissionEvent(this, new Date(), user, httpServletRequest, httpServletResponse, author, authorEmail, authorURL, commentText, commentMetaData);
                this._configuration.getEventBroadcaster().processEvent((BlojsomEvent)commentResponseSubmissionEvent);
                author = commentResponseSubmissionEvent.getSubmitter();
                authorEmail = commentResponseSubmissionEvent.getSubmitterItem1();
                authorURL = commentResponseSubmissionEvent.getSubmitterItem2();
                commentText = commentResponseSubmissionEvent.getContent();
                if (!commentMetaData.containsKey(BLOJSOM_PLUGIN_COMMENT_METADATA_DESTROY)) {
                    BlogComment _comment = this.addBlogComment(author, authorEmail, authorURL, commentText, _blogCommentsEnabled, commentMetaData, user, entries[0]);
                    context.put("BLOJSOM_LAST_MODIFIED", new Long(new Date().getTime()));
                    if (_comment != null) {
                        try {
                            entries[0].load(user);
                        }
                        catch (BlojsomException e) {
                            this._logger.error((Object)e);
                        }
                        this._configuration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new CommentAddedEvent((Object)this, new Date(), _comment, user));
                        HashMap<String, Object> emailTemplateContext = new HashMap<String, Object>();
                        emailTemplateContext.put("BLOJSOM_BLOG", blog);
                        emailTemplateContext.put("BLOJSOM_USER", user);
                        emailTemplateContext.put(BLOJSOM_COMMENT_PLUGIN_BLOG_COMMENT, _comment);
                        emailTemplateContext.put(BLOJSOM_COMMENT_PLUGIN_BLOG_ENTRY, entries[0]);
                        String emailComment = this.mergeTemplate(COMMENT_PLUGIN_EMAIL_TEMPLATE, user, emailTemplateContext);
                        if (_blogEmailEnabled.booleanValue()) {
                            this.sendCommentEmail(_emailPrefix, title, emailComment, context, (String)entries[0].getMetaData().get("blog-entry-author"), blog);
                        }
                    }
                } else {
                    this._logger.info((Object)"Comment meta-data contained destroy key. Comment was not saved");
                }
                if (remember != null && !"".equals(remember)) {
                    CookieUtils.addCookie((HttpServletResponse)httpServletResponse, (int)_cookieExpiration, (String)COOKIE_AUTHOR, (String)author);
                    context.put(BLOJSOM_COMMENT_PLUGIN_AUTHOR, author);
                    CookieUtils.addCookie((HttpServletResponse)httpServletResponse, (int)_cookieExpiration, (String)COOKIE_EMAIL, (String)authorEmail);
                    context.put(BLOJSOM_COMMENT_PLUGIN_AUTHOR_EMAIL, authorEmail);
                    CookieUtils.addCookie((HttpServletResponse)httpServletResponse, (int)_cookieExpiration, (String)COOKIE_URL, (String)authorURL);
                    context.put(BLOJSOM_COMMENT_PLUGIN_AUTHOR_URL, authorURL);
                    CookieUtils.addCookie((HttpServletResponse)httpServletResponse, (int)_cookieExpiration, (String)COOKIE_REMEMBER_ME, (String)"true");
                    context.put(BLOJSOM_COMMENT_PLUGIN_REMEMBER_ME, "true");
                }
            }
        }
        return entries;
    }

    public void sendCommentEmail(String emailPrefix, String title, String comment, Map context, String author, Blog blog) {
        String recipientEmail = blog.getAuthorizedUserEmail(author);
        EmailUtils.notifyBlogAuthor(emailPrefix + title, comment, context, recipientEmail);
    }

    private BlogComment addBlogComment(String author, String authorEmail, String authorURL, String userComment, boolean blogCommentsEnabled, Map commentMetaData, BlogUser blogUser, BlogEntry blogEntry) {
        BlogComment comment = null;
        if (blogCommentsEnabled) {
            userComment = BlojsomUtils.escapeMetaAndLink((String)userComment);
            try {
                comment = this._fetcher.newBlogComment();
                comment.setBlogEntry(blogEntry);
                comment.setAuthor(author);
                comment.setAuthorEmail(authorEmail);
                comment.setAuthorURL(authorURL);
                comment.setComment(userComment);
                comment.setCommentDate(new Date());
                comment.setMetaData(commentMetaData);
                comment.save(blogUser);
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e);
                comment = null;
            }
        }
        return comment;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

