/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.comment;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;

public class CommentModerationPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)CommentModerationPlugin.class);
    public static final String COMMENT_MODERATION_ENABLED = "comment-moderation-enabled";
    public static final String BLOJSOM_COMMENT_MODERATION_PLUGIN_APPROVED = "BLOJSOM_COMMENT_MODERATION_PLUGIN_APPROVED";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._logger.debug((Object)"Initialized comment moderation plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        this.moderateComment(httpServletRequest, httpServletResponse, user, context, entries);
        return entries;
    }

    protected void moderateComment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        Blog blog = user.getBlog();
        if ("true".equalsIgnoreCase(blog.getBlogProperty(COMMENT_MODERATION_ENABLED)) && "y".equalsIgnoreCase(httpServletRequest.getParameter("comment")) && user.getBlog().getBlogCommentsEnabled().booleanValue()) {
            Map commentMetaData = context.containsKey("BLOJSOM_PLUGIN_COMMENT_METADATA") ? (Map)context.get("BLOJSOM_PLUGIN_COMMENT_METADATA") : new HashMap();
            commentMetaData.put(BLOJSOM_COMMENT_MODERATION_PLUGIN_APPROVED, Boolean.FALSE.toString());
            context.put("BLOJSOM_PLUGIN_COMMENT_METADATA", commentMetaData);
            this._logger.debug((Object)"Marking comment as requiring approval");
        }
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

