/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.categories;

import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class CategoryTemplatePlugin
implements BlojsomPlugin,
BlojsomConstants {
    private static final String CATEGORY_TEMPLATE_METADATA = "category.template";
    protected static Log _logger = LogFactory.getLog((Class)CategoryTemplatePlugin.class);

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        _logger.debug((Object)"Initialized category template plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        BlogCategory blogCategory = (BlogCategory)context.get("BLOJSOM_REQUESTED_CATEGORY");
        if (BlojsomUtils.checkMapForKey((Map)blogCategory.getMetaData(), (String)CATEGORY_TEMPLATE_METADATA)) {
            String pageForCategory = (String)blogCategory.getMetaData().get(CATEGORY_TEMPLATE_METADATA);
            pageForCategory = BlojsomUtils.normalize((String)pageForCategory);
            String currentPageParam = BlojsomUtils.getRequestValue((String)"page", (HttpServletRequest)httpServletRequest);
            if (!BlojsomUtils.checkNullOrBlank((String)currentPageParam)) {
                pageForCategory = pageForCategory + "-" + currentPageParam;
            }
            _logger.debug((Object)("Using template for category: " + pageForCategory));
            httpServletRequest.setAttribute("page", (Object)pageForCategory);
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

