/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.calendar;

import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.blojsom.util.BlojsomUtils;

public class BlogCalendar {
    private Calendar _calendar;
    private Calendar _today;
    private DateFormatSymbols _symbols;
    private Locale _locale;
    private Boolean[] _dayswithentry;
    private String[] _shortdownames;
    private String _blogURL;
    private int currentmonth;
    private int currentyear;
    private int currentday;
    private String _requestedDateKey;

    public BlogCalendar(Calendar calendar, String blogurl) {
        this(calendar, blogurl, Locale.getDefault());
    }

    public BlogCalendar(Calendar calendar, String blogurl, Locale locale) {
        this._locale = locale;
        this._calendar = calendar;
        this._today = Calendar.getInstance(this._locale);
        this._today.setTime(new Date());
        this._symbols = new DateFormatSymbols(this._locale);
        this._blogURL = blogurl;
        this.currentmonth = calendar.get(2);
        this.currentyear = calendar.get(1);
        this.currentday = calendar.get(5);
        this._dayswithentry = new Boolean[this._calendar.getActualMaximum(5)];
        Arrays.fill((Object[])this._dayswithentry, Boolean.FALSE);
        this._shortdownames = new String[7];
        String[] downames = this._symbols.getShortWeekdays();
        if (this._calendar.getFirstDayOfWeek() == 1) {
            for (int x = 0; x < this._shortdownames.length; ++x) {
                this._shortdownames[x] = downames[x + 1];
            }
        } else {
            for (int x = 2; x <= this._shortdownames.length; ++x) {
                this._shortdownames[x - 2] = downames[x];
            }
            this._shortdownames[6] = downames[1];
        }
    }

    public String getCaption() {
        return BlojsomUtils.getFormattedDate((Date)this._calendar.getTime(), (String)"MMMMM yyyy", (Locale)this._locale);
    }

    public int getFirstDayOfMonth() {
        this._calendar.set(5, 1);
        return this._calendar.get(7);
    }

    public int getDaysInMonth() {
        return this._calendar.getActualMaximum(5);
    }

    public void setEntryForDOM(int dom) {
        if (dom > 0 && dom <= this._dayswithentry.length) {
            this._dayswithentry[dom - 1] = true;
        }
    }

    public void removeEntryForDOM(int dom) {
        if (dom > 0 && dom <= this._dayswithentry.length) {
            this._dayswithentry[dom - 1] = false;
        }
    }

    public boolean dayHasEntry(int dom) {
        boolean result = false;
        if (dom > 0 && dom <= this._dayswithentry.length) {
            result = this._dayswithentry[dom - 1];
        }
        return result;
    }

    public Boolean[] getEntryDates() {
        return this._dayswithentry;
    }

    public String getMonthName(int month) {
        return this.getMonthNames()[month];
    }

    public String[] getMonthNames() {
        return this._symbols.getMonths();
    }

    public String getShortMonthName(int month) {
        return this.getShortMonthNames()[month];
    }

    public String[] getShortMonthNames() {
        return this._symbols.getShortMonths();
    }

    public String getDayOfWeekName(int dow) {
        return this.getDayOfWeekNames()[dow];
    }

    public String[] getDayOfWeekNames() {
        return this._symbols.getWeekdays();
    }

    public String getShortDayOfWeekName(int dow) {
        return this._shortdownames[dow - 1];
    }

    public String[] getShortDayOfWeekNames() {
        return this._shortdownames;
    }

    public String getCalendarUrl() {
        return this._blogURL;
    }

    public Calendar getCalendar() {
        return this._calendar;
    }

    public Calendar getToday() {
        return this._today;
    }

    public int getCurrentMonth() {
        return this.currentmonth;
    }

    public void setCurrentMonth(int currentmonth) {
        this.currentmonth = currentmonth;
        this._calendar.set(2, currentmonth);
    }

    public int getCurrentYear() {
        return this.currentyear;
    }

    public void setCurrentYear(int currentyear) {
        this.currentyear = currentyear;
        this._calendar.set(1, currentyear);
    }

    public int getCurrentDay() {
        return this.currentday;
    }

    public void setCurrentDay(int currentday) {
        this.currentday = currentday;
        this._calendar.set(5, currentday);
    }

    public String getRequestedDateKey() {
        return this._requestedDateKey;
    }

    public void setRequestedDateKey(String requestedDateKey) {
        this._requestedDateKey = requestedDateKey;
    }
}

