/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.calendar;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.calendar.AbstractCalendarPlugin;
import org.blojsom.plugin.calendar.BlogCalendar;
import org.blojsom.util.BlojsomUtils;

public abstract class AbstractVisualCalendarPlugin
extends AbstractCalendarPlugin {
    protected BlogCalendar _blogCalendar;

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        entries = super.process(httpServletRequest, httpServletResponse, user, context, entries);
        Locale locale = (Locale)context.get("BLOJSOM_CALENDAR_LOCALE");
        BlogCalendar blogCalendar = (BlogCalendar)context.get("BLOJSOM_CALENDAR");
        Calendar entrycalendar = Calendar.getInstance(locale);
        if (entries != null && entries.length > 0) {
            for (int x = 0; x < entries.length; ++x) {
                BlogEntry entry = entries[x];
                entrycalendar.setTime(entry.getDate());
                int entrymonth = entrycalendar.get(2);
                int entryyear = entrycalendar.get(1);
                if (entrymonth != blogCalendar.getCurrentMonth() || entryyear != blogCalendar.getCurrentYear()) continue;
                blogCalendar.setEntryForDOM(entrycalendar.get(5));
            }
            if (context.containsKey("BLOJSOM_PERMALINK")) {
                ArrayList files = new ArrayList();
                Date today = new Date();
                BlojsomUtils.visitFilesAndDirectories((Date)today, (String[])user.getBlog().getBlogFileExtensions(), (String[])user.getBlog().getBlogDirectoryFilter(), (File)new File(user.getBlog().getBlogHome()), files);
                Calendar checkCalendar = Calendar.getInstance(locale);
                for (int i = 0; i < files.size(); ++i) {
                    File entryOnDisk = (File)files.get(i);
                    checkCalendar.setTimeInMillis(entryOnDisk.lastModified());
                    int entrymonth = checkCalendar.get(2);
                    int entryyear = checkCalendar.get(1);
                    if (entrymonth != blogCalendar.getCurrentMonth() || entryyear != blogCalendar.getCurrentYear()) continue;
                    blogCalendar.setEntryForDOM(checkCalendar.get(5));
                }
            }
        }
        context.put("BLOJSOM_CALENDAR", blogCalendar);
        return entries;
    }
}

