/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.calendar;

import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.calendar.BlogCalendar;

public abstract class AbstractCalendarPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)AbstractCalendarPlugin.class);
    protected static final String BLOJSOM_CALENDAR_LOCALE = "BLOJSOM_CALENDAR_LOCALE";
    public static final String BLOJSOM_CALENDAR = "BLOJSOM_CALENDAR";
    public static final String BLOJSOM_CALENDAR_VTLHELPER = "BLOJSOM_CALENDAR_VTLHELPER";
    protected static final String YEAR_PARAM = "year";
    protected static final String MONTH_PARAM = "month";
    protected static final String DAY_PARAM = "day";
    protected static final String BLOJSOM_CALENDAR_FORMAT = "MMMMM yyyy";
    protected static final String BLOJSOM_CALENDAR_SHORTFORMAT = "MMM";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String requestedDateKey;
        Blog blog = user.getBlog();
        Locale locale = Locale.getDefault();
        String localeLanguage = blog.getBlogLanguage();
        if (localeLanguage != null) {
            locale = new Locale(localeLanguage);
        }
        context.put(BLOJSOM_CALENDAR_LOCALE, locale);
        String calendarUrl = user.getBlog().getBlogURL();
        Calendar calendar = Calendar.getInstance(locale);
        calendar.set(5, 1);
        int currentMonth = calendar.get(2);
        int currentYear = calendar.get(1);
        int currentDay = calendar.get(5);
        String year = null;
        String month = null;
        String day = null;
        year = httpServletRequest.getParameter(YEAR_PARAM);
        if (year != null) {
            if (year.length() != 4) {
                year = null;
            } else {
                try {
                    currentYear = Integer.parseInt(year);
                    calendar.set(1, currentYear);
                }
                catch (NumberFormatException e) {
                    year = "";
                    this._logger.error((Object)("Invalid Year Param submitted and ignored: " + year));
                }
                month = httpServletRequest.getParameter(MONTH_PARAM);
                if (month == null) {
                    month = "";
                } else if (month.length() < 2) {
                    month = "0" + month;
                }
                if (!month.equals("")) {
                    try {
                        currentMonth = Integer.parseInt(month) - 1;
                        calendar.set(2, currentMonth);
                    }
                    catch (NumberFormatException e) {
                        month = "";
                        this._logger.error((Object)("Invalid Month Param submitted and ignored: " + month));
                    }
                }
                if ((day = httpServletRequest.getParameter(DAY_PARAM)) == null) {
                    day = "";
                } else if (day.length() < 2) {
                    day = "0" + day;
                }
                if (!day.equals("")) {
                    try {
                        currentDay = Integer.parseInt(day);
                        if (currentDay > calendar.getActualMaximum(5)) {
                            this._logger.info((Object)"Adjusting day of month to max maximum for selected month");
                            currentDay = calendar.getActualMaximum(5);
                        }
                        calendar.set(5, currentDay);
                    }
                    catch (NumberFormatException e) {
                        this._logger.error((Object)("Invalid Day Param submitted and ignored: " + day));
                    }
                }
            }
            requestedDateKey = year + month + day;
        } else {
            requestedDateKey = null;
        }
        BlogCalendar blogCalendar = new BlogCalendar(calendar, calendarUrl, locale);
        blogCalendar.setRequestedDateKey(requestedDateKey);
        context.put(BLOJSOM_CALENDAR, blogCalendar);
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

