/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.aggregator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomUtils;

public class InternalAggregatorPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)InternalAggregatorPlugin.class);
    private static final int DEFAULT_MOST_RECENT_ENTRIES_SIZE = 3;
    private static final String BLOJSOM_PLUGIN_INTERNAL_AGGREGATOR_ENTRIES = "BLOJSOM_PLUGIN_INTERNAL_AGGREGATOR_ENTRIES";
    private static final String BLOJSOM_PLUGIN_INTERNAL_AGGREGATOR_BLOG_NAME = "BLOJSOM_PLUGIN_INTERNAL_AGGREGATOR_BLOG_NAME";
    private static final String BLOJSOM_PLUGIN_INTERNAL_AGGREGATOR_BLOG_URL = "BLOJSOM_PLUGIN_INTERNAL_AGGREGATOR_BLOG_URL";
    public static final String BLOJSOM_PLUGIN_INTERNAL_AGGREGATOR_OPT_OUT = "blojsom-plugin-internal-aggegator-opt-out";
    private BlojsomConfiguration _blojsomConfiguration;
    private BlojsomFetcher _fetcher;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._blojsomConfiguration = blojsomConfiguration;
        String fetcherClassName = blojsomConfiguration.getFetcherClass();
        try {
            Class<?> fetcherClass = Class.forName(fetcherClassName);
            this._fetcher = (BlojsomFetcher)fetcherClass.newInstance();
            this._fetcher.init(servletConfig, blojsomConfiguration);
            this._logger.info((Object)("Added blojsom fetcher: " + fetcherClassName));
        }
        catch (ClassNotFoundException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (InstantiationException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        this._logger.debug((Object)"Initialized internal aggregator plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String[] blogs = this._blojsomConfiguration.getBlojsomUsers();
        ArrayList<BlogEntry> aggregatedEntries = new ArrayList<BlogEntry>(50);
        BlogEntry[] entriesFromBlog = null;
        BlogEntry[] entriesToSort = null;
        for (int blogCounter = 0; blogCounter < blogs.length; ++blogCounter) {
            String blogID = blogs[blogCounter];
            BlogUser blogUser = null;
            try {
                blogUser = this._blojsomConfiguration.loadBlog(blogID);
                Blog blogInformation = blogUser.getBlog();
                Boolean optOut = Boolean.valueOf(blogInformation.getBlogProperty(BLOJSOM_PLUGIN_INTERNAL_AGGREGATOR_OPT_OUT));
                if (optOut.booleanValue()) continue;
                HashMap<String, Object> fetchParameters = new HashMap<String, Object>();
                fetchParameters.put("FETCHER_FLAVOR", blogInformation.getBlogDefaultFlavor());
                fetchParameters.put("FETCHER_NUM_POSTS_INTEGER", new Integer(blogInformation.getBlogDisplayEntries()));
                try {
                    entriesFromBlog = this._fetcher.fetchEntries(fetchParameters, blogUser);
                }
                catch (BlojsomFetcherException e) {
                    this._logger.error((Object)e);
                }
                if (entriesFromBlog == null || entriesFromBlog.length <= 0) continue;
                String blogName = blogInformation.getBlogName();
                String blogURL = blogInformation.getBlogURL();
                int counter = entriesFromBlog.length > 3 ? 3 : entriesFromBlog.length;
                for (int i = 0; i < counter; ++i) {
                    BlogEntry blogEntry = entriesFromBlog[i];
                    HashMap<String, String> blogEntryMetaData = blogEntry.getMetaData();
                    if (blogEntryMetaData == null) {
                        blogEntryMetaData = new HashMap<String, String>();
                    }
                    blogEntryMetaData.put(BLOJSOM_PLUGIN_INTERNAL_AGGREGATOR_BLOG_NAME, blogName);
                    blogEntryMetaData.put(BLOJSOM_PLUGIN_INTERNAL_AGGREGATOR_BLOG_URL, blogURL);
                    blogEntry.setMetaData(blogEntryMetaData);
                    aggregatedEntries.add(blogEntry);
                }
                continue;
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e);
            }
        }
        if (aggregatedEntries.size() > 0) {
            entriesToSort = aggregatedEntries.toArray(new BlogEntry[aggregatedEntries.size()]);
            Arrays.sort(entriesToSort, BlojsomUtils.FILE_TIME_COMPARATOR);
            context.put(BLOJSOM_PLUGIN_INTERNAL_AGGREGATOR_ENTRIES, entriesToSort);
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

