/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.WebAdminPlugin;
import org.blojsom.plugin.admin.event.ProcessRequestEvent;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class ThemeSwitcherPlugin
extends WebAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)ThemeSwitcherPlugin.class);
    private static final String FAILED_PERMISSION_KEY = "failed.theme.switch.permission.text";
    private static final String NONE_SELECTED_KEY = "no.theme.flavor.selected.text";
    private static final String ADMIN_FLAVOR_PROTECTED_KEY = "admin.flavor.protected.text";
    private static final String FAILED_THEME_TEMPLATE_COPY_KEY = "failed.theme.template.copy.text";
    private static final String FAILED_FLAVOR_WRITE_KEY = "failed.flavor.write.text";
    private static final String THEME_SWITCHED_KEY = "theme.switched.text";
    private static final String THEME_SWITCHER_SETTINGS_PAGE = "/org/blojsom/plugin/admin/templates/admin-theme-switcher-settings";
    private static final String THEME_SWITCHER_PLUGIN_AVAILABLE_THEMES = "THEME_SWITCHER_PLUGIN_AVAILABLE_THEMES";
    private static final String THEME_SWITCHER_PLUGIN_FLAVORS = "THEME_SWITCHER_PLUGIN_FLAVORS";
    private static final String THEME_SWITCHER_PLUGIN_DEFAULT_FLAVOR = "THEME_SWITCHER_PLUGIN_DEFAULT_FLAVOR";
    private static final String CURRENT_HTML_THEME = "CURRENT_HTML_THEME";
    private static final String SWITCH_THEME_ACTION = "switch-theme";
    private static final String THEME = "theme";
    private static final String FLAVOR = "flavor-name";
    private static final String SWITCH_THEME_PERMISSION = "switch_theme";
    private static final String DEFAULT_THEMES_DIRECTORY = "/themes/";
    private static final String THEMES_DIRECTORY_IP = "themes-directory";
    private String _themesDirectory;
    private String _flavorConfiguration;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        this._themesDirectory = servletConfig.getInitParameter(THEMES_DIRECTORY_IP);
        if (BlojsomUtils.checkNullOrBlank((String)this._themesDirectory)) {
            this._themesDirectory = DEFAULT_THEMES_DIRECTORY;
        }
        this._themesDirectory = BlojsomUtils.checkStartingAndEndingSlash((String)this._themesDirectory);
        this._flavorConfiguration = servletConfig.getInitParameter("flavor-configuration");
    }

    public String getDisplayName() {
        return "Theme Switcher plugin";
    }

    public String getInitialPage() {
        return THEME_SWITCHER_SETTINGS_PAGE;
    }

    protected String[] getAvailableThemes() {
        File[] themesInstalled;
        ArrayList<String> themes = new ArrayList<String>(0);
        File themesDirectory = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + this._themesDirectory);
        if (themesDirectory.exists() && themesDirectory.isDirectory() && (themesInstalled = themesDirectory.listFiles(BlojsomUtils.getDirectoryFilter())) != null && themesInstalled.length > 0) {
            for (int i = 0; i < themesInstalled.length; ++i) {
                File installedTheme = themesInstalled[i];
                themes.add(installedTheme.getName());
            }
        }
        Object[] availableThemes = themes.toArray(new String[themes.size()]);
        Arrays.sort(availableThemes);
        return availableThemes;
    }

    protected void writeFlavorConfiguration(BlogUser user) throws IOException {
        Iterator flavorIterator = user.getFlavors().keySet().iterator();
        BlojsomProperties flavorProperties = new BlojsomProperties();
        Map flavorToTemplateMap = user.getFlavorToTemplate();
        Map flavorToContentTypeMap = user.getFlavorToContentType();
        while (flavorIterator.hasNext()) {
            String flavor = (String)flavorIterator.next();
            flavorProperties.setProperty(flavor, flavorToTemplateMap.get(flavor) + ", " + flavorToContentTypeMap.get(flavor));
        }
        File flavorFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + user.getId() + "/" + this._flavorConfiguration);
        FileOutputStream fos = new FileOutputStream(flavorFile);
        flavorProperties.store(fos, null);
        fos.close();
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        entries = super.process(httpServletRequest, httpServletResponse, user, context, entries);
        String page = BlojsomUtils.getRequestValue((String)"page", (HttpServletRequest)httpServletRequest);
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, SWITCH_THEME_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_PERMISSION_KEY, FAILED_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        if ("/org/blojsom/plugin/admin/templates/admin-login".equals(page)) {
            return entries;
        }
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        context.put(THEME_SWITCHER_PLUGIN_AVAILABLE_THEMES, this.getAvailableThemes());
        context.put(THEME_SWITCHER_PLUGIN_FLAVORS, new TreeMap(user.getFlavors()));
        context.put(THEME_SWITCHER_PLUGIN_DEFAULT_FLAVOR, user.getBlog().getBlogDefaultFlavor());
        String currentHtmlFlavor = (String)user.getFlavorToTemplate().get("html");
        currentHtmlFlavor = currentHtmlFlavor.substring(0, currentHtmlFlavor.indexOf(46));
        context.put(CURRENT_HTML_THEME, currentHtmlFlavor);
        if (SWITCH_THEME_ACTION.equals(action)) {
            String theme = BlojsomUtils.getRequestValue((String)THEME, (HttpServletRequest)httpServletRequest);
            String flavor = BlojsomUtils.getRequestValue((String)FLAVOR, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)theme) || BlojsomUtils.checkNullOrBlank((String)flavor)) {
                this.addOperationResultMessage(context, this.getAdminResource(NONE_SELECTED_KEY, NONE_SELECTED_KEY, user.getBlog().getBlogAdministrationLocale()));
                return entries;
            }
            if ("admin".equalsIgnoreCase(flavor)) {
                this.addOperationResultMessage(context, this.getAdminResource(ADMIN_FLAVOR_PROTECTED_KEY, ADMIN_FLAVOR_PROTECTED_KEY, user.getBlog().getBlogAdministrationLocale()));
                return entries;
            }
            File copyFromTemplatesDirectory = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + this._themesDirectory + theme + "/" + this._blojsomConfiguration.getTemplatesDirectory());
            File[] templateFiles = copyFromTemplatesDirectory.listFiles();
            String mainTemplate = null;
            if (templateFiles != null && templateFiles.length > 0) {
                for (int i = 0; i < templateFiles.length; ++i) {
                    File templateFile = templateFiles[i];
                    if (templateFile.isDirectory() || !templateFile.getName().startsWith(theme + ".")) continue;
                    mainTemplate = templateFile.getName();
                }
            }
            if (mainTemplate == null) {
                mainTemplate = (String)user.getFlavorToTemplate().get(flavor);
                this._logger.debug((Object)("No main template supplied for " + theme + " theme. Using existing template for flavor: " + mainTemplate));
            }
            File copyToTemplatesDirectory = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + user.getId() + "/" + this._blojsomConfiguration.getTemplatesDirectory());
            try {
                BlojsomUtils.copyDirectory((File)copyFromTemplatesDirectory, (File)copyToTemplatesDirectory);
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_THEME_TEMPLATE_COPY_KEY, FAILED_THEME_TEMPLATE_COPY_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
            File copyFromResourcesDirectory = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + this._themesDirectory + theme + "/" + this._blojsomConfiguration.getResourceDirectory());
            File copyToResourcesDirectory = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getResourceDirectory() + user.getId() + "/");
            try {
                BlojsomUtils.copyDirectory((File)copyFromResourcesDirectory, (File)copyToResourcesDirectory);
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_THEME_TEMPLATE_COPY_KEY, FAILED_THEME_TEMPLATE_COPY_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
            Map flavorTemplatesForUser = user.getFlavorToTemplate();
            flavorTemplatesForUser.put(flavor, mainTemplate);
            try {
                this.writeFlavorConfiguration(user);
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_FLAVOR_WRITE_KEY, FAILED_FLAVOR_WRITE_KEY, user.getBlog().getBlogAdministrationLocale()));
                return entries;
            }
            currentHtmlFlavor = (String)user.getFlavorToTemplate().get("html");
            currentHtmlFlavor = currentHtmlFlavor.substring(0, currentHtmlFlavor.indexOf(46));
            context.put(CURRENT_HTML_THEME, currentHtmlFlavor);
            this.addOperationResultMessage(context, this.formatAdminResource(THEME_SWITCHED_KEY, THEME_SWITCHED_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{theme, flavor}));
            this._blojsomConfiguration.getEventBroadcaster().processEvent((BlojsomEvent)new ProcessRequestEvent(this, new Date(), user, httpServletRequest, httpServletResponse, context));
        } else {
            this._blojsomConfiguration.getEventBroadcaster().processEvent((BlojsomEvent)new ProcessRequestEvent(this, new Date(), user, httpServletRequest, httpServletResponse, context));
            context.put(THEME_SWITCHER_PLUGIN_AVAILABLE_THEMES, this.getAvailableThemes());
        }
        return entries;
    }
}

