/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.BaseAdminPlugin;
import org.blojsom.plugin.email.EmailMessage;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class ForgottenPasswordPlugin
extends BaseAdminPlugin
implements BlojsomConstants {
    private Log _logger = LogFactory.getLog((Class)ForgottenPasswordPlugin.class);
    private static final String AUTHORIZATION_CREDENTIAL_FAILURE_KEY = "authorization.credential.failure.text";
    private static final String FAILED_PASSWORD_CHANGE_KEY = "failed.password.change.text";
    private static final String CONSTRUCTED_PASSWORD_EMAIL_KEY = "constructed.password.email.text";
    private static final String AUTHORIZED_EMAIL_BLANK_KEY = "authorized.email.blank.text";
    private static final String USERNAME_BLANK_KEY = "username.blank.text";
    private static final String FORGOTTEN_USERNAME_PARAM = "forgotten-username";
    private static final String FORGOTTEN_PASSWORD_PAGE = "forgotten-password";
    private String _authorizationConfiguration;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        this._authorizationConfiguration = servletConfig.getInitParameter("blog-authorization");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        try {
            this._authorizationProvider.loadAuthenticationCredentials(user);
        }
        catch (BlojsomException e) {
            this.addOperationResultMessage(context, this.formatAdminResource(AUTHORIZATION_CREDENTIAL_FAILURE_KEY, AUTHORIZATION_CREDENTIAL_FAILURE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{user.getId()}));
            this._logger.error((Object)e);
            return entries;
        }
        String username = BlojsomUtils.getRequestValue((String)FORGOTTEN_USERNAME_PARAM, (HttpServletRequest)httpServletRequest);
        if (!BlojsomUtils.checkNullOrBlank((String)username)) {
            Blog blog = user.getBlog();
            String authorizedUserEmail = blog.getAuthorizedUserEmail(username);
            if (!BlojsomUtils.checkNullOrBlank((String)authorizedUserEmail)) {
                EmailMessage emailMessage = null;
                if (!blog.getUseEncryptedPasswords().booleanValue()) {
                    emailMessage = new EmailMessage(blog.getBlogOwnerEmail(), authorizedUserEmail, "Forgotten password", "Here is your password: " + blog.getAuthorization().get(username));
                } else {
                    String currentPassword = (String)blog.getAuthorization().get(username);
                    Random random = new Random(new Date().getTime() + System.currentTimeMillis());
                    int password = random.nextInt(Integer.MAX_VALUE);
                    String updatedPassword = new String(Integer.toString(password));
                    emailMessage = new EmailMessage(blog.getBlogOwnerEmail(), authorizedUserEmail, "Forgotten password", "Here is your password: " + updatedPassword);
                    updatedPassword = BlojsomUtils.digestString((String)updatedPassword, (String)blog.getDigestAlgorithm());
                    try {
                        blog.setAuthorizedUserPassword(username, updatedPassword);
                        this.writeAuthorizationConfiguration(blog.getAuthorization(), user.getId());
                    }
                    catch (IOException e) {
                        this._logger.error((Object)e);
                        blog.setAuthorizedUserPassword(username, currentPassword);
                        this.addOperationResultMessage(context, this.formatAdminResource(FAILED_PASSWORD_CHANGE_KEY, FAILED_PASSWORD_CHANGE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{username}));
                        return entries;
                    }
                }
                ArrayList<EmailMessage> emailMessages = new ArrayList<EmailMessage>();
                emailMessages.add(emailMessage);
                context.put("BLOJSOM_OUTBOUNDMAIL", emailMessages);
                this._logger.debug((Object)("Constructed forgotten password e-mail message for username: " + username));
                this.addOperationResultMessage(context, this.formatAdminResource(CONSTRUCTED_PASSWORD_EMAIL_KEY, CONSTRUCTED_PASSWORD_EMAIL_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{username}));
                httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin-login");
            } else {
                this._logger.debug((Object)("Authorized e-mail address was blank for user: " + username));
                this.addOperationResultMessage(context, this.formatAdminResource(AUTHORIZED_EMAIL_BLANK_KEY, AUTHORIZED_EMAIL_BLANK_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{username}));
                httpServletRequest.setAttribute("page", (Object)FORGOTTEN_PASSWORD_PAGE);
            }
        } else {
            this.addOperationResultMessage(context, this.getAdminResource(USERNAME_BLANK_KEY, USERNAME_BLANK_KEY, user.getBlog().getBlogAdministrationLocale()));
            httpServletRequest.setAttribute("page", (Object)FORGOTTEN_PASSWORD_PAGE);
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    private void writeAuthorizationConfiguration(Map authorizationMap, String user) throws IOException {
        File authorizationFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + user + "/" + this._authorizationConfiguration);
        this._logger.debug((Object)("Writing authorization file: " + authorizationFile.toString()));
        Properties authorizationProperties = BlojsomUtils.mapToProperties((Map)authorizationMap);
        FileOutputStream fos = new FileOutputStream(authorizationFile);
        authorizationProperties.store(fos, null);
        fos.close();
    }
}

