/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.BaseAdminPlugin;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class EditBlogUsersPlugin
extends BaseAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)EditBlogUsersPlugin.class);
    private static final String EDIT_BLOG_USERS_PAGE = "/org/blojsom/plugin/admin/templates/admin-edit-blog-users";
    private static final String PLUGIN_ADMIN_EDIT_USERS_IP = "plugin-admin-edit-users";
    private static final String BOOTSTRAP_DIRECTORY_IP = "bootstrap-directory";
    private static final String DEFAULT_BOOTSTRAP_DIRECTORY = "/bootstrap";
    private static final String BLOG_HOME_BASE_DIRECTORY_IP = "blog-home-base-directory";
    private static final String FAILED_DELETE_BLOGS_PERMISSION_KEY = "failed.delete.blogs.permission.text";
    private static final String FAILED_REMOVE_BLOG_CONFIGURATION_KEY = "failed.remove.blog.configuration.text";
    private static final String FAILED_REMOVE_BLOG_DIRECTORY_KEY = "failed.remove.blog.directory.text";
    private static final String FAILED_REMOVE_BLOG_RESOURCES_DIRECTORY_KEY = "failed.remove.blog.resources.text";
    private static final String DELETED_BLOG_KEY = "deleted.blog.text";
    private static final String FAILED_ADD_BLOGS_PERMISSION_KEY = "failed.add.blogs.permission.text";
    private static final String MISSING_WEBLOG_ID_KEY = "missing.weblog.id.text";
    private static final String WEBLOG_ID_EXISTS_KEY = "weblog.id.exists.text";
    private static final String WEBLOG_DIRECTORY_EXISTS_KEY = "weblog.directory.exists.text";
    private static final String MISSING_WEBLOG_URLS_KEY = "missing.weblog.urls.text";
    private static final String PASSWORDS_NOT_MATCHED_KEY = "passwords.not.matched.text";
    private static final String FAILED_BOOTSTRAP_DIRECTORY_COPY_KEY = "failed.bootstrap.directory.copy.text";
    private static final String FAILED_BLOG_DIRECTORY_CREATE_KEY = "failed.blog.directory.create.text=";
    private static final String ADDED_NEW_WEBLOG_KEY = "added.new.blog.text";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_USERS_MAP = "BLOJSOM_PLUGIN_EDIT_BLOG_USERS_MAP";
    private static final String DELETE_BLOG_USER_ACTION = "delete-blog-user";
    private static final String ADD_BLOG_USER_ACTION = "add-blog-user";
    private static final String BLOG_USER_ID = "blog-user-id";
    private static final String BLOG_USER_PASSWORD = "blog-user-password";
    private static final String BLOG_USER_PASSWORD_CHECK = "blog-user-password-check";
    private static final String ADD_BLOG_PERMISSION = "add_blog";
    private static final String DELETE_BLOG_PERMISSION = "delete_blog";
    private String _bootstrapDirectory;
    private String _blogHomeBaseDirectory;
    private String _flavorConfiguration;
    private String _pluginConfiguration;
    private String _authorizationConfiguration;
    private String _permissionsConfiguration;
    private ServletConfig _servletConfig;
    private Map _administrators;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        this._servletConfig = servletConfig;
        this._blojsomConfiguration = blojsomConfiguration;
        this._flavorConfiguration = servletConfig.getInitParameter("flavor-configuration");
        this._pluginConfiguration = servletConfig.getInitParameter("plugin-configuration");
        this._authorizationConfiguration = servletConfig.getInitParameter("blog-authorization");
        this._permissionsConfiguration = servletConfig.getInitParameter("blog-permissions");
        if (BlojsomUtils.checkNullOrBlank((String)this._permissionsConfiguration)) {
            this._permissionsConfiguration = "permissions.properties";
        }
        try {
            Properties configurationProperties = BlojsomUtils.loadProperties((ServletConfig)servletConfig, (String)PLUGIN_ADMIN_EDIT_USERS_IP, (boolean)true);
            this._bootstrapDirectory = configurationProperties.getProperty(BOOTSTRAP_DIRECTORY_IP);
            if (BlojsomUtils.checkNullOrBlank((String)this._bootstrapDirectory)) {
                this._bootstrapDirectory = DEFAULT_BOOTSTRAP_DIRECTORY;
            }
            this._blogHomeBaseDirectory = configurationProperties.getProperty(BLOG_HOME_BASE_DIRECTORY_IP);
            if (BlojsomUtils.checkNullOrBlank((String)this._blogHomeBaseDirectory)) {
                this._blogHomeBaseDirectory = this._blojsomConfiguration.getGlobalBlogHome();
                if (BlojsomUtils.checkNullOrBlank((String)this._blogHomeBaseDirectory)) {
                    throw new BlojsomPluginException("No blog base home directory specified.");
                }
            } else if (!this._blogHomeBaseDirectory.endsWith("/")) {
                this._blogHomeBaseDirectory = this._blogHomeBaseDirectory + "/";
            }
            String administratorProperty = configurationProperties.getProperty("administrators");
            String[] administrators = BlojsomUtils.parseCommaList((String)administratorProperty);
            this._administrators = BlojsomUtils.arrayOfStringsToMap((String[])administrators);
        }
        catch (BlojsomException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        if (!this.authenticateUser(httpServletRequest, httpServletResponse, context, user)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin-login");
            return entries;
        }
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        context.put(BLOJSOM_PLUGIN_EDIT_BLOG_USERS_MAP, Collections.unmodifiableMap(BlojsomUtils.listToMap((List)BlojsomUtils.arrayToList((String[])this._blojsomConfiguration.getBlojsomUsers()))));
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        if (BlojsomUtils.checkNullOrBlank((String)action)) {
            this._logger.debug((Object)"User did not request edit action");
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
        } else if ("page".equals(action)) {
            this._logger.debug((Object)"User requested edit blog users page");
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_USERS_PAGE);
        } else if (DELETE_BLOG_USER_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested delete blog user action");
            if (!this._administrators.containsKey(user.getId()) || !this.checkPermission(user, null, username, DELETE_BLOG_PERMISSION)) {
                httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_DELETE_BLOGS_PERMISSION_KEY, FAILED_DELETE_BLOGS_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
                return entries;
            }
            String blogUserID = BlojsomUtils.getRequestValue((String)BLOG_USER_ID, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)blogUserID)) {
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_USERS_PAGE);
                return entries;
            }
            this._logger.debug((Object)("Deleting user: " + blogUserID));
            this._blojsomConfiguration.removeBlogID(blogUserID);
            File blogConfigurationDirectory = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + blogUserID + "/");
            if (!BlojsomUtils.deleteDirectory((File)blogConfigurationDirectory)) {
                this._logger.error((Object)("Unable to remove blog configuration directory: " + blogConfigurationDirectory.toString()));
                this.addOperationResultMessage(context, this.formatAdminResource(FAILED_REMOVE_BLOG_CONFIGURATION_KEY, FAILED_REMOVE_BLOG_CONFIGURATION_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogUserID}));
            } else {
                this._logger.debug((Object)("Removed blog configuration directory: " + blogConfigurationDirectory.toString()));
            }
            File blogDirectory = new File(this._blogHomeBaseDirectory + blogUserID + "/");
            if (!BlojsomUtils.deleteDirectory((File)blogDirectory)) {
                this._logger.error((Object)("Unable to remove blog directory for user: " + blogDirectory.toString()));
                this.addOperationResultMessage(context, this.formatAdminResource(FAILED_REMOVE_BLOG_DIRECTORY_KEY, FAILED_REMOVE_BLOG_DIRECTORY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogUserID}));
            } else {
                this._logger.debug((Object)("Removed blog directory: " + blogDirectory.toString()));
            }
            File blogResourcesDirectory = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getResourceDirectory() + blogUserID + "/");
            if (!BlojsomUtils.deleteDirectory((File)blogResourcesDirectory)) {
                this._logger.error((Object)("Unable to remove blog resource directory: " + blogResourcesDirectory.toString()));
                this.addOperationResultMessage(context, this.formatAdminResource(FAILED_REMOVE_BLOG_RESOURCES_DIRECTORY_KEY, FAILED_REMOVE_BLOG_RESOURCES_DIRECTORY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogUserID}));
            } else {
                this._logger.debug((Object)("Removed blog resource directory: " + blogResourcesDirectory.toString()));
            }
            this.writeBlojsomConfiguration();
            this._logger.debug((Object)("Wrote new blojsom configuration after deleting user: " + blogUserID));
            this.addOperationResultMessage(context, this.formatAdminResource(DELETED_BLOG_KEY, DELETED_BLOG_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogUserID}));
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
        } else if (ADD_BLOG_USER_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested add blog user action");
            if (!this._administrators.containsKey(user.getId()) || !this.checkPermission(user, null, username, ADD_BLOG_PERMISSION)) {
                httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_ADD_BLOGS_PERMISSION_KEY, FAILED_ADD_BLOGS_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
                return entries;
            }
            Map blogUsers = this._blojsomConfiguration.getBlogIDs();
            String blogUserID = BlojsomUtils.getRequestValue((String)BLOG_USER_ID, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)blogUserID)) {
                this.addOperationResultMessage(context, this.getAdminResource(MISSING_WEBLOG_ID_KEY, MISSING_WEBLOG_ID_KEY, user.getBlog().getBlogAdministrationLocale()));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_USERS_PAGE);
                return entries;
            }
            if (blogUsers.containsKey(blogUserID)) {
                this._logger.debug((Object)("User: " + blogUserID + " already exists"));
                this.addOperationResultMessage(context, this.formatAdminResource(WEBLOG_ID_EXISTS_KEY, WEBLOG_ID_EXISTS_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogUserID}));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_USERS_PAGE);
                return entries;
            }
            this._logger.debug((Object)("Adding new user id: " + blogUserID));
            BlogUser blogUser = new BlogUser();
            blogUser.setId(blogUserID);
            File blogUserDirectory = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + blogUserID);
            if (blogUserDirectory.exists()) {
                this._logger.debug((Object)("User directory already exists for blog user: " + blogUserID));
                this.addOperationResultMessage(context, this.formatAdminResource(WEBLOG_DIRECTORY_EXISTS_KEY, WEBLOG_DIRECTORY_EXISTS_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogUserID}));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_USERS_PAGE);
                return entries;
            }
            String blogUserPassword = BlojsomUtils.getRequestValue((String)BLOG_USER_PASSWORD, (HttpServletRequest)httpServletRequest);
            String blogUserPasswordCheck = BlojsomUtils.getRequestValue((String)BLOG_USER_PASSWORD_CHECK, (HttpServletRequest)httpServletRequest);
            String blogBaseURL = BlojsomUtils.getRequestValue((String)"blog-base-url", (HttpServletRequest)httpServletRequest);
            String blogURL = BlojsomUtils.getRequestValue((String)"blog-url", (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)blogURL) || BlojsomUtils.checkNullOrBlank((String)blogBaseURL)) {
                this._logger.debug((Object)"No blog URL or base URL supplied");
                this.addOperationResultMessage(context, this.getAdminResource(MISSING_WEBLOG_URLS_KEY, MISSING_WEBLOG_URLS_KEY, user.getBlog().getBlogAdministrationLocale()));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_USERS_PAGE);
                return entries;
            }
            if (!blogURL.endsWith("/")) {
                blogURL = blogURL + "/";
            }
            if (!blogBaseURL.endsWith("/")) {
                blogBaseURL = blogBaseURL + "/";
            }
            if (!blogUserPassword.equals(blogUserPasswordCheck)) {
                this._logger.debug((Object)"User password does not equal password check");
                this.addOperationResultMessage(context, this.getAdminResource(PASSWORDS_NOT_MATCHED_KEY, PASSWORDS_NOT_MATCHED_KEY, user.getBlog().getBlogAdministrationLocale()));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_USERS_PAGE);
                return entries;
            }
            String bootstrap = this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + this._bootstrapDirectory + "/";
            this._logger.debug((Object)("Bootstrap directory: " + bootstrap));
            File bootstrapDirectory = new File(bootstrap);
            String userDirectory = this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + blogUserID + "/";
            this._logger.debug((Object)("User directory: " + userDirectory));
            File newUserDirectory = new File(userDirectory);
            this._logger.debug((Object)("Copying bootstrap directory: " + bootstrapDirectory.toString() + " to target user directory: " + newUserDirectory.toString()));
            try {
                BlojsomUtils.copyDirectory((File)bootstrapDirectory, (File)newUserDirectory);
            }
            catch (IOException e) {
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_BOOTSTRAP_DIRECTORY_COPY_KEY, FAILED_BOOTSTRAP_DIRECTORY_COPY_KEY, user.getBlog().getBlogAdministrationLocale()));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_USERS_PAGE);
                this._logger.error((Object)e);
                return entries;
            }
            try {
                Properties blogProperties = BlojsomUtils.loadProperties((ServletConfig)this._servletConfig, (String)(this._blojsomConfiguration.getBaseConfigurationDirectory() + blogUserID + '/' + "blog.properties"));
                blogProperties.put("blog-home", this._blogHomeBaseDirectory + blogUserID);
                File blogHomeDirectory = new File(this._blogHomeBaseDirectory + blogUserID);
                if (!blogHomeDirectory.mkdirs()) {
                    this._logger.error((Object)("Unable to create blog home directory: " + blogHomeDirectory.toString()));
                    this.addOperationResultMessage(context, this.formatAdminResource(FAILED_BLOG_DIRECTORY_CREATE_KEY, FAILED_BLOG_DIRECTORY_CREATE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogUserID}));
                    httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_USERS_PAGE);
                    return entries;
                }
                blogProperties.put("blog-base-url", blogBaseURL);
                blogProperties.put("blog-url", blogURL);
                File blogConfigurationFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + blogUserID + '/' + "blog.properties");
                FileOutputStream fos = new FileOutputStream(blogConfigurationFile);
                blogProperties.store(fos, null);
                fos.close();
                this._logger.debug((Object)("Wrote blog configuration information for new user: " + blogConfigurationFile.toString()));
                Blog blog = new Blog(blogProperties);
                blogUser.setBlog(blog);
                HashMap<String, String> authorizationMap = new HashMap<String, String>();
                authorizationMap.put(blogUserID, blogUserPassword);
                blogUser.getBlog().setAuthorization(authorizationMap);
                this._logger.debug((Object)("Set authorization information for new user: " + blogUserID));
                File blogAuthorizationFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + blogUserID + '/' + this._authorizationConfiguration);
                fos = new FileOutputStream(blogAuthorizationFile);
                Properties authorizationProperties = BlojsomUtils.mapToProperties((Map)blogUser.getBlog().getAuthorization());
                authorizationProperties.store(fos, null);
                fos.close();
                this._logger.debug((Object)("Wrote blog authorization information for new user: " + blogAuthorizationFile.toString()));
                File blogPermissionsFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + blogUserID + "/" + this._permissionsConfiguration);
                fos = new FileOutputStream(blogPermissionsFile);
                BlojsomProperties permissionsProperties = new BlojsomProperties(true);
                permissionsProperties.setProperty(blogUserID, "*");
                permissionsProperties.store(fos, null);
                fos.close();
                this._logger.debug((Object)("Wrote blog permissions information for new user: " + blogPermissionsFile.toString()));
                HashMap<String, String> flavors = new HashMap<String, String>();
                HashMap<String, String> flavorToTemplateMap = new HashMap<String, String>();
                HashMap<String, String> flavorToContentTypeMap = new HashMap<String, String>();
                Properties flavorProperties = BlojsomUtils.loadProperties((ServletConfig)this._servletConfig, (String)(this._blojsomConfiguration.getBaseConfigurationDirectory() + blogUserID + '/' + this._flavorConfiguration));
                Iterator<Object> flavorIterator = flavorProperties.keySet().iterator();
                while (flavorIterator.hasNext()) {
                    String flavor = (String)flavorIterator.next();
                    String[] flavorMapping = BlojsomUtils.parseCommaList((String)flavorProperties.getProperty(flavor));
                    flavors.put(flavor, flavor);
                    flavorToTemplateMap.put(flavor, flavorMapping[0]);
                    flavorToContentTypeMap.put(flavor, flavorMapping[1]);
                }
                blogUser.setFlavors(flavors);
                blogUser.setFlavorToTemplate(flavorToTemplateMap);
                blogUser.setFlavorToContentType(flavorToContentTypeMap);
                this._logger.debug((Object)("Loaded flavor information for new user: " + blogUserID));
                HashMap<String, String[]> pluginChainMap = new HashMap<String, String[]>();
                Properties pluginProperties = BlojsomUtils.loadProperties((ServletConfig)this._servletConfig, (String)(this._blojsomConfiguration.getBaseConfigurationDirectory() + blogUserID + '/' + this._pluginConfiguration));
                Iterator<Object> pluginIterator = pluginProperties.keySet().iterator();
                while (pluginIterator.hasNext()) {
                    String plugin = (String)pluginIterator.next();
                    if (plugin.indexOf("blojsom-plugin-chain") == -1) continue;
                    pluginChainMap.put(plugin, BlojsomUtils.parseCommaList((String)pluginProperties.getProperty(plugin)));
                    this._logger.debug((Object)("Added plugin chain: " + plugin + '=' + pluginProperties.getProperty(plugin) + " for user: " + blogUserID));
                }
                blogUser.setPluginChain(pluginChainMap);
                this._logger.debug((Object)("Loaded plugin chain map for new user: " + blogUserID));
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e);
            }
            catch (IOException e) {
                this._logger.error((Object)e);
            }
            File blogResourcesDirectory = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getResourceDirectory() + blogUserID + "/");
            File bootstrapResourcesDirectory = new File(bootstrapDirectory, this._blojsomConfiguration.getResourceDirectory());
            if (!blogResourcesDirectory.mkdirs()) {
                this._logger.error((Object)("Unable to create blog resource directory: " + blogResourcesDirectory.toString()));
            } else {
                this._logger.debug((Object)("Added blog resource directory: " + blogResourcesDirectory.toString()));
            }
            try {
                File resourcesDirectoryToDelete;
                if (bootstrapResourcesDirectory.exists()) {
                    BlojsomUtils.copyDirectory((File)bootstrapResourcesDirectory, (File)blogResourcesDirectory);
                }
                if ((resourcesDirectoryToDelete = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + blogUserID + this._blojsomConfiguration.getResourceDirectory())).exists()) {
                    BlojsomUtils.deleteDirectory((File)resourcesDirectoryToDelete);
                }
            }
            catch (IOException e) {
                this._logger.error((Object)e);
            }
            this._blojsomConfiguration.addBlogID(blogUserID);
            this.writeBlojsomConfiguration();
            this._logger.debug((Object)("Wrote new blojsom configuration after adding new user: " + blogUserID));
            this.addOperationResultMessage(context, this.formatAdminResource(ADDED_NEW_WEBLOG_KEY, ADDED_NEW_WEBLOG_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogUserID}));
        }
        return entries;
    }

    private void writeBlojsomConfiguration() {
        File blojsomConfigurationFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + "blojsom.properties");
        BlojsomProperties configurationProperties = new BlojsomProperties(true);
        configurationProperties.put("blojsom-users", BlojsomUtils.arrayToList((String[])this._blojsomConfiguration.getBlojsomUsers()));
        configurationProperties.put("blojsom-fetcher", this._blojsomConfiguration.getFetcherClass());
        configurationProperties.put("blojsom-default-user", this._blojsomConfiguration.getDefaultUser());
        configurationProperties.put("blojsom-installation-directory", this._blojsomConfiguration.getInstallationDirectory());
        configurationProperties.put("blojsom-configuration-base-directory", this._blojsomConfiguration.getBaseConfigurationDirectory());
        configurationProperties.put("blojsom-blog-home", this._blojsomConfiguration.getGlobalBlogHome());
        configurationProperties.put("blojsom-templates-directory", this._blojsomConfiguration.getTemplatesDirectory());
        configurationProperties.put("blojsom-resource-directory", this._blojsomConfiguration.getResourceDirectory());
        configurationProperties.put("blojsom-resource-manager", this._blojsomConfiguration.getResourceManager());
        configurationProperties.put("blojsom-resource-manager-bundles", "org.blojsom.plugin.admin.resources.messages");
        configurationProperties.put("blojsom-broadcaster", this._blojsomConfiguration.getEventBroadcaster().getClass().getName());
        configurationProperties.put("blojsom-authorization-provider", this._blojsomConfiguration.getAuthorizationProvider());
        configurationProperties.put("blojsom-installed-locales", BlojsomUtils.arrayOfStringsToString((String[])this._blojsomConfiguration.getInstalledLocalesAsStrings()));
        try {
            FileOutputStream fos = new FileOutputStream(blojsomConfigurationFile);
            configurationProperties.store(fos, null);
            fos.close();
        }
        catch (IOException e) {
            this._logger.error((Object)e);
        }
    }
}

