/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.BaseAdminPlugin;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class EditBlogTemplatesPlugin
extends BaseAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)EditBlogTemplatesPlugin.class);
    private static final String DEFAULT_ACCEPTED_TEMPLATE_EXTENSIONS = "vm";
    private static final String ACCEPTED_TEMPLATE_EXTENSIONS_INIT_PARAM = "accepted-template-extensions";
    private static final String EDIT_BLOG_TEMPLATES_PAGE = "/org/blojsom/plugin/admin/templates/admin-edit-blog-templates";
    private static final String EDIT_BLOG_TEMPLATE_PAGE = "/org/blojsom/plugin/admin/templates/admin-edit-blog-template";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_TEMPLATE_FILES = "BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_TEMPLATE_FILES";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_TEMPLATE_FILE = "BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_TEMPLATE_FILE";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_TEMPLATE = "BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_TEMPLATE";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_DIRECTORIES = "BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_DIRECTORIES";
    private static final String FAILED_EDIT_TEMPLATES_PERMISSION_KEY = "failed.edit.templates.permission.text";
    private static final String INVALID_TEMPLATE_PATH_KEY = "invalid.template.path.text";
    private static final String UNABLE_TO_LOAD_TEMPLATE_KEY = "unable.to.load.template.text";
    private static final String UNABLE_TO_DELETE_TEMPLATE_KEY = "unable.to.delete.template.text";
    private static final String UPDATED_TEMPLATE_KEY = "updated.template.text";
    private static final String NO_TEMPLATE_NAME_KEY = "no.template.name.text";
    private static final String INVALID_TEMPLATE_EXTENSION_KEY = "invalid.template.extension.text";
    private static final String TEMPLATE_DIRECTORY_NONEXISTENT_KEY = "template.directory.nonexistent.text";
    private static final String TEMPLATE_DIRECTORY_NOTSPECIFIED_KEY = "template.directory.notspecified.text";
    private static final String UNABLE_TO_ADD_TEMPLATE_DIRECTORY_KEY = "unable.to.add.template.directory.text";
    private static final String ADDED_TEMPLATE_DIRECTORY_KEY = "added.template.directory.text";
    private static final String CANNOT_REMOVE_TOP_TEMPLATE_DIRECTORY_KEY = "cannot.remove.top.template.directory.text";
    private static final String UNABLE_TO_DELETE_TEMPLATE_DIRECTORY_KEY = "unable.to.delete.template.directory.text";
    private static final String REMOVED_TEMPLATE_DIRECTORY_KEY = "removed.template.directory.text";
    private static final String DELETED_TEMPLATE_KEY = "deleted.template.text";
    private static final String ADD_BLOG_TEMPLATE_ACTION = "add-blog-template";
    private static final String DELETE_BLOG_TEMPLATE_ACTION = "delete-blog-template";
    private static final String EDIT_BLOG_TEMPLATES_ACTION = "edit-blog-template";
    private static final String UPDATE_BLOG_TEMPLATE_ACTION = "update-blog-template";
    private static final String ADD_TEMPLATE_DIRECTORY_ACTION = "add-template-directory";
    private static final String DELETE_TEMPLATE_DIRECTORY_ACTION = "delete-template-directory";
    private static final String BLOG_TEMPLATE = "blog-template";
    private static final String BLOG_TEMPLATE_DATA = "blog-template-data";
    private static final String BLOG_TEMPLATE_DIRECTORY = "blog-template-directory";
    private static final String TEMPLATE_DIRECTORY_TO_ADD = "template-directory-to-add";
    private static final String EDIT_BLOG_TEMPLATES_PERMISSION = "edit_blog_templates";
    private Map _acceptedTemplateExtensions;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        String acceptedTemplateExtensions = servletConfig.getInitParameter(ACCEPTED_TEMPLATE_EXTENSIONS_INIT_PARAM);
        if (BlojsomUtils.checkNullOrBlank((String)acceptedTemplateExtensions)) {
            acceptedTemplateExtensions = DEFAULT_ACCEPTED_TEMPLATE_EXTENSIONS;
        }
        this._acceptedTemplateExtensions = new HashMap();
        String[] templateExtensions = BlojsomUtils.parseCommaList((String)acceptedTemplateExtensions);
        for (int i = 0; i < templateExtensions.length; ++i) {
            String templateExtension = templateExtensions[i];
            this._acceptedTemplateExtensions.put(templateExtension, templateExtension);
        }
    }

    protected String sanitizeFilename(String blogTemplate) {
        String templateFilename = new File(blogTemplate).getName();
        int lastSeparator = (blogTemplate = BlojsomUtils.normalize((String)blogTemplate)).lastIndexOf(File.separator);
        if (lastSeparator == -1) {
            if (templateFilename != null) {
                return templateFilename;
            }
            return null;
        }
        blogTemplate = blogTemplate.substring(0, lastSeparator + 1) + templateFilename;
        return blogTemplate;
    }

    protected void putTemplatesInContext(File templatesDirectory, Map context) {
        ArrayList templateFiles = new ArrayList();
        BlojsomUtils.listFilesInSubdirectories((File)templatesDirectory, (String)templatesDirectory.getAbsolutePath(), templateFiles);
        Object[] templates = templateFiles.toArray(new File[templateFiles.size()]);
        Arrays.sort(templates);
        context.put(BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_TEMPLATE_FILES, templates);
    }

    protected void putTemplateDirectoriesInContext(File templatesDirectory, Map context) {
        ArrayList templateDirectories = new ArrayList();
        BlojsomUtils.listDirectoriesInSubdirectories((File)templatesDirectory, (String)templatesDirectory.getAbsolutePath(), templateDirectories);
        Object[] directories = templateDirectories.toArray(new File[templateDirectories.size()]);
        Arrays.sort(directories);
        context.put(BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_DIRECTORIES, directories);
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        if (!this.authenticateUser(httpServletRequest, httpServletResponse, context, user)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin-login");
            return entries;
        }
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, EDIT_BLOG_TEMPLATES_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_EDIT_TEMPLATES_PERMISSION_KEY, FAILED_EDIT_TEMPLATES_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        File templatesDirectory = new File(this._blojsomConfiguration.getInstallationDirectory() + BlojsomUtils.removeInitialSlash((String)this._blojsomConfiguration.getBaseConfigurationDirectory()) + user.getId() + this._blojsomConfiguration.getTemplatesDirectory());
        this._logger.debug((Object)("Looking for templates in directory: " + templatesDirectory.toString()));
        this.putTemplatesInContext(templatesDirectory, context);
        this.putTemplateDirectoriesInContext(templatesDirectory, context);
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        if (BlojsomUtils.checkNullOrBlank((String)action)) {
            this._logger.debug((Object)"User did not request edit action");
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
        } else if ("page".equals(action)) {
            this._logger.debug((Object)"User requested edit blog templates page");
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATES_PAGE);
        } else if (EDIT_BLOG_TEMPLATES_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested edit blog templates action");
            String blogTemplate = BlojsomUtils.getRequestValue((String)BLOG_TEMPLATE, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)blogTemplate)) {
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATES_PAGE);
                return entries;
            }
            if ((blogTemplate = this.sanitizeFilename(blogTemplate)) == null) {
                this.addOperationResultMessage(context, this.getAdminResource(INVALID_TEMPLATE_PATH_KEY, INVALID_TEMPLATE_PATH_KEY, user.getBlog().getBlogAdministrationLocale()));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATES_PAGE);
                return entries;
            }
            File blogTemplateFile = new File(this._blojsomConfiguration.getInstallationDirectory() + BlojsomUtils.removeInitialSlash((String)this._blojsomConfiguration.getBaseConfigurationDirectory()) + user.getId() + this._blojsomConfiguration.getTemplatesDirectory() + blogTemplate);
            this._logger.debug((Object)("Reading template file: " + blogTemplateFile.toString()));
            try {
                String input;
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(blogTemplateFile), "UTF-8"));
                StringBuffer template = new StringBuffer();
                while ((input = br.readLine()) != null) {
                    template.append(input);
                    template.append(BlojsomConstants.LINE_SEPARATOR);
                }
                br.close();
                context.put(BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_TEMPLATE_FILE, blogTemplate);
                context.put(BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_TEMPLATE, BlojsomUtils.escapeString((String)template.toString()));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATE_PAGE);
            }
            catch (UnsupportedEncodingException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.formatAdminResource(UNABLE_TO_LOAD_TEMPLATE_KEY, UNABLE_TO_LOAD_TEMPLATE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogTemplate}));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATES_PAGE);
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.formatAdminResource(UNABLE_TO_LOAD_TEMPLATE_KEY, UNABLE_TO_LOAD_TEMPLATE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogTemplate}));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATES_PAGE);
            }
        } else if (UPDATE_BLOG_TEMPLATE_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested update blog template action");
            String blogTemplate = BlojsomUtils.getRequestValue((String)BLOG_TEMPLATE, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)blogTemplate)) {
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATES_PAGE);
                return entries;
            }
            if ((blogTemplate = this.sanitizeFilename(blogTemplate)) == null) {
                this.addOperationResultMessage(context, this.getAdminResource(INVALID_TEMPLATE_PATH_KEY, INVALID_TEMPLATE_PATH_KEY, user.getBlog().getBlogAdministrationLocale()));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATES_PAGE);
                return entries;
            }
            String blogTemplateData = BlojsomUtils.getRequestValue((String)BLOG_TEMPLATE_DATA, (HttpServletRequest)httpServletRequest);
            File blogTemplateFile = new File(this._blojsomConfiguration.getInstallationDirectory() + BlojsomUtils.removeInitialSlash((String)this._blojsomConfiguration.getBaseConfigurationDirectory()) + user.getId() + this._blojsomConfiguration.getTemplatesDirectory() + blogTemplate);
            this._logger.debug((Object)("Writing template file: " + blogTemplateFile.toString()));
            try {
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(blogTemplateFile), "UTF-8"));
                bw.write(blogTemplateData);
                bw.close();
            }
            catch (UnsupportedEncodingException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.formatAdminResource(UNABLE_TO_DELETE_TEMPLATE_KEY, UNABLE_TO_DELETE_TEMPLATE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogTemplate}));
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.formatAdminResource(UNABLE_TO_DELETE_TEMPLATE_KEY, UNABLE_TO_DELETE_TEMPLATE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogTemplate}));
            }
            this.addOperationResultMessage(context, this.formatAdminResource(UPDATED_TEMPLATE_KEY, UPDATED_TEMPLATE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogTemplate}));
            context.put(BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_TEMPLATE_FILE, blogTemplate);
            context.put(BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_TEMPLATE, BlojsomUtils.escapeString((String)blogTemplateData));
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATE_PAGE);
        } else if (ADD_BLOG_TEMPLATE_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested add blog template action");
            String blogTemplate = BlojsomUtils.getRequestValue((String)BLOG_TEMPLATE, (HttpServletRequest)httpServletRequest);
            String blogTemplateDirectory = BlojsomUtils.getRequestValue((String)BLOG_TEMPLATE_DIRECTORY, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)blogTemplate)) {
                this.addOperationResultMessage(context, this.getAdminResource(NO_TEMPLATE_NAME_KEY, NO_TEMPLATE_NAME_KEY, user.getBlog().getBlogAdministrationLocale()));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATES_PAGE);
                return entries;
            }
            String templateName = BlojsomUtils.getFilenameFromPath((String)blogTemplate);
            String templateExtension = BlojsomUtils.getFileExtension((String)templateName);
            if (!this._acceptedTemplateExtensions.containsKey(templateExtension)) {
                this.addOperationResultMessage(context, this.formatAdminResource(INVALID_TEMPLATE_EXTENSION_KEY, INVALID_TEMPLATE_EXTENSION_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{templateExtension}));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATES_PAGE);
                return entries;
            }
            File addedTemplateDirectory = new File(templatesDirectory, blogTemplateDirectory = BlojsomUtils.normalize((String)blogTemplateDirectory));
            if (addedTemplateDirectory.exists()) {
                context.put(BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_TEMPLATE_FILE, blogTemplateDirectory + File.separator + templateName);
                context.put(BLOJSOM_PLUGIN_EDIT_BLOG_TEMPLATES_TEMPLATE, "");
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATE_PAGE);
            } else {
                this.addOperationResultMessage(context, this.getAdminResource(TEMPLATE_DIRECTORY_NONEXISTENT_KEY, TEMPLATE_DIRECTORY_NONEXISTENT_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
        } else if (ADD_TEMPLATE_DIRECTORY_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested add blog template directory action");
            String templateDirectoryToAdd = BlojsomUtils.getRequestValue((String)TEMPLATE_DIRECTORY_TO_ADD, (HttpServletRequest)httpServletRequest);
            String blogTemplateDirectory = BlojsomUtils.getRequestValue((String)BLOG_TEMPLATE_DIRECTORY, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)templateDirectoryToAdd)) {
                this.addOperationResultMessage(context, this.getAdminResource(TEMPLATE_DIRECTORY_NOTSPECIFIED_KEY, TEMPLATE_DIRECTORY_NOTSPECIFIED_KEY, user.getBlog().getBlogAdministrationLocale()));
            } else {
                blogTemplateDirectory = BlojsomUtils.normalize((String)blogTemplateDirectory);
                templateDirectoryToAdd = BlojsomUtils.normalize((String)templateDirectoryToAdd);
                File newTemplateDirectory = new File(templatesDirectory, blogTemplateDirectory + File.separator + templateDirectoryToAdd);
                this._logger.debug((Object)("Adding blog template directory: " + newTemplateDirectory.toString()));
                if (!newTemplateDirectory.mkdir()) {
                    this.addOperationResultMessage(context, this.formatAdminResource(UNABLE_TO_ADD_TEMPLATE_DIRECTORY_KEY, UNABLE_TO_ADD_TEMPLATE_DIRECTORY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{templateDirectoryToAdd}));
                } else {
                    this.addOperationResultMessage(context, this.formatAdminResource(ADDED_TEMPLATE_DIRECTORY_KEY, ADDED_TEMPLATE_DIRECTORY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{templateDirectoryToAdd}));
                    this.putTemplateDirectoriesInContext(templatesDirectory, context);
                }
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATES_PAGE);
        } else if (DELETE_TEMPLATE_DIRECTORY_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested delete blog template directory action");
            String blogTemplateDirectory = BlojsomUtils.getRequestValue((String)BLOG_TEMPLATE_DIRECTORY, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)blogTemplateDirectory)) {
                this.addOperationResultMessage(context, this.getAdminResource(CANNOT_REMOVE_TOP_TEMPLATE_DIRECTORY_KEY, CANNOT_REMOVE_TOP_TEMPLATE_DIRECTORY_KEY, user.getBlog().getBlogAdministrationLocale()));
            } else {
                blogTemplateDirectory = BlojsomUtils.normalize((String)blogTemplateDirectory);
                this._logger.debug((Object)("Sanitized template directory: " + blogTemplateDirectory));
                File templateDirectoryToDelete = new File(templatesDirectory, blogTemplateDirectory);
                this._logger.debug((Object)("Removing blog template directory: " + templateDirectoryToDelete));
                if (!BlojsomUtils.deleteDirectory((File)templateDirectoryToDelete, (boolean)true)) {
                    this.addOperationResultMessage(context, this.formatAdminResource(UNABLE_TO_DELETE_TEMPLATE_DIRECTORY_KEY, UNABLE_TO_DELETE_TEMPLATE_DIRECTORY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogTemplateDirectory}));
                } else {
                    this.addOperationResultMessage(context, this.formatAdminResource(REMOVED_TEMPLATE_DIRECTORY_KEY, REMOVED_TEMPLATE_DIRECTORY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogTemplateDirectory}));
                    this.putTemplateDirectoriesInContext(templatesDirectory, context);
                }
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATES_PAGE);
        } else if (DELETE_BLOG_TEMPLATE_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested delete blog template directory action");
            String blogTemplate = BlojsomUtils.getRequestValue((String)BLOG_TEMPLATE, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)blogTemplate)) {
                this.addOperationResultMessage(context, this.getAdminResource(NO_TEMPLATE_NAME_KEY, NO_TEMPLATE_NAME_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
            blogTemplate = this.sanitizeFilename(blogTemplate);
            File templateToDelete = new File(templatesDirectory, blogTemplate);
            this._logger.debug((Object)("Deleting blog template: " + templateToDelete.toString()));
            if (!templateToDelete.delete()) {
                this.addOperationResultMessage(context, this.formatAdminResource(UNABLE_TO_DELETE_TEMPLATE_KEY, UNABLE_TO_DELETE_TEMPLATE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogTemplate}));
            } else {
                this.addOperationResultMessage(context, this.formatAdminResource(DELETED_TEMPLATE_KEY, DELETED_TEMPLATE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogTemplate}));
                this.putTemplatesInContext(templatesDirectory, context);
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_TEMPLATES_PAGE);
        }
        return entries;
    }
}

